/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *          Copyright (c) 1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Draw text to the screen using one of the TI Roman fonts, which is
 *   selected to be compatible with the resolution of the screen.
 *   Call the set_textattr function (see last statement of program) once
 *   per frame to vary the intercharacter spacing.  The effect is that
 *   the text seems to stretch and contract on the screen.
 *----------------------------------------------------------------------
 *   04/12/90...Original version written..................J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "colors.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

#define NLINES	  3	  /* number of lines of text */

extern FONT ti_rom16, ti_rom20, ti_rom26;

static CONFIG cfg;
static FONTINFO fontinfo;

static char *s[NLINES] = { "Variable", "Intercharacter", "Spacing", };


main()
{
    int hres, vres, delta, i, index, wmax, w, h, x, y;
    short spacing;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(0);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */
    if (hres <= 320)
	index = install_font(&ti_rom16);
    else if (hres <= 640)
	index = install_font(&ti_rom20);
    else
	index = install_font(&ti_rom26);
    select_font(index);
    get_fontinfo(0, &fontinfo);  /* get font parameters */

    /* Infinite loop below displays examples of both
     * positive and negative intercharacter spacing.
     */
    h = 2*fontinfo.charhigh;
    spacing = 0;
    delta = 1;
    for (;;) {
	/* Draw text on screen. */
	set_fcolor(WHITE);
	set_ppop(8);	    /* OR */
	wmax = 0;
	y = vres/2 - (2*NLINES - 1)*h/4;
	for (i = 0; i < NLINES; i++) {
	    w = text_width(s[i]);
	    if (abs(w) > wmax)
		wmax = abs(w);
	    x = (hres - w)/2;
	    text_out(x, y, s[i]);
	    y += h;
	}
	draw_rect(hres-1, vres-1, 0, 0);
	for (i = 6; i; i--)
	    wait_scan(hres);

	/* Erase text. */
	set_fcolor(BLACK);
	set_ppop(0);	    /* REPLACE */
	y = vres/2 - (2*NLINES - 1)*h/4;
	for (i = 0; i < NLINES; i++) {
	    w = text_width(s[i]);
	    if (abs(w) > wmax)
		wmax = abs(w);
	    x = (hres - w)/2;
	    text_out(x, y, s[i]);
	    y += h;
	}

	/* Update extra intercharacter spacing. */
	if (wmax > hres)
	    delta = -delta;
	spacing += delta;
	h += 2*delta;
	set_textattr("%*e", 1, &spacing);
    }
}

