cd \glib340
echo off 
rem +----------------------------------------------------------------------+
rem :			   TMS340 Graphics Library			   :
rem :		 Copyright (c) 1988,90 Texas Instruments Inc.		   :
rem +----------------------------------------------------------------------+
if "%1" == "" goto INTRO
if "%1" == "tdb10" goto TDB10
if "%1" == "TDB10" goto TDB10
if "%1" == "tdb10min" goto TDB10MIN
if "%1" == "TDB10MIN" goto TDB10MIN
if "%1" == "sdb10" goto SDB10
if "%1" == "SDB10" goto SDB10
if "%1" == "sdb20" goto SDB20
if "%1" == "SDB20" goto SDB20
goto INTRO

:TDB10
echo +----------------------------------------------------------------------+
echo :                                                                      :
echo :    About to make TMS340 Graphics Library for the Texas Instruments   :
echo :    TMS34010 TIGA Development Board with full memory configuration.   :
echo :                          Type ^C to abort.                           :
echo :                                                                      :
echo +----------------------------------------------------------------------+
pause

REM --- Remake the core primitives
REM --- Change to \corprims directory
cd .\corprims
..\make INC=..\include corprims.mak
if errorlevel 1 goto END

REM --- Remake the extended primitives
REM --- Change to \extprims directory
cd ..\extprims
..\make INC=..\include extprims.mak
if errorlevel 1 goto END

REM --- Remake the hardware-dependent primitives
REM --- Change to \oemprims directory
cd ..\tdb10\oemprims
..\..\make INC=..\..\include oemprims.mak
if errorlevel 1 goto END

REM --- Remake the demo programs (MODE0=1 page, MODE1=2 pages)
REM --- Change to \demos directory
cd ..\demos
..\..\make INC=..\..\include MODE0="-dMODE=0" MODE1="-dMODE=1" demos.mak

goto END

:TDB10MIN
echo +----------------------------------------------------------------------+
echo :                                                                      :
echo :    About to make TMS340 Graphics Library for the Texas Instruments   :
echo :    TMS34010 TIGA Development Board with minimum 512K VRAM, 0K DRAM.  :
echo :                          Type ^C to abort.                           :
echo :                                                                      :
echo +----------------------------------------------------------------------+
pause

REM --- Remake the core primitives
REM --- Change to \corprims directory
cd .\corprims
..\make INC=..\include corprims.mak
if errorlevel 1 goto END

REM --- Remake the extended primitives
REM --- Change to \extprims directory
cd ..\extprims
..\make INC=..\include extprims.mak
if errorlevel 1 goto END

REM --- Remake the hardware-dependent primitives
REM --- Change to \oemprims directory
cd ..\tdb10min\oemprims
..\..\make INC=..\..\include oemprims.mak
if errorlevel 1 goto END

REM --- Remake the demo programs (MODE0=1 page, MODE1=2 pages)
REM --- Change to \demos directory
cd ..\demos
..\..\make INC=..\..\include MODE0="-dMODE=0" MODE1="-dMODE=1" demos.mak

goto END

:SDB10
echo +----------------------------------------------------------------------+
echo :                                                                      :
echo :    About to make TMS340 Graphics Library for the                     :
echo :    Texas Instruments TMS34010 Software Development Board             :
echo :                          Type ^C to abort.                           :
echo :                                                                      :
echo +----------------------------------------------------------------------+
pause

REM --- Remake the core primitives
REM --- Change to \corprims directory
cd .\corprims
..\make INC=..\include corprims.mak
if errorlevel 1 goto END

REM --- Remake the extended primitives
REM --- Change to \extprims directory
cd ..\extprims
..\make INC=..\include extprims.mak
if errorlevel 1 goto END

REM --- Remake the hardware-dependent primitives
REM --- Change to \oemprims directory
cd ..\sdb10\oemprims
..\..\make INC=..\..\include oemprims.mak
if errorlevel 1 goto END

REM --- Remake the demo programs (MODE0=1 page, MODE1=2 pages)
REM --- Change to \demos directory
cd ..\demos
..\..\make INC=..\..\include MODE0="-dMODE=0" MODE1="-dMODE=1" demos.mak

goto END

:SDB20
echo +----------------------------------------------------------------------+
echo :                                                                      :
echo :    About to make TMS340 Graphics Library for the                     :
echo :    Texas Instruments TMS34020 Software Development Board             :
echo :                          Type ^C to abort.                           :
echo :                                                                      :
echo +----------------------------------------------------------------------+
pause

REM --- Remake the core primitives
REM --- Change to \corprims directory
cd .\corprims
..\make INC=..\include corprims.mak
if errorlevel 1 goto END

REM --- Remake the extended primitives
REM --- Change to \extprims directory
cd ..\extprims
..\make INC=..\include extprims.mak
if errorlevel 1 goto END

REM --- Remake the hardware-dependent primitives
REM --- Change to \oemprims directory
cd ..\sdb20\oemprims
..\..\make INC=..\..\include oemprims.mak
if errorlevel 1 goto END

REM --- Remake the demo programs (MODE0=1 page, MODE1=2 pages)
REM --- Change to \demos directory
cd ..\demos
..\..\make INC=..\..\include MODE0="-dMODE=0" MODE1="-dMODE=0" demos.mak

goto END

:INTRO
echo +----------------------------------------------------------------------+
echo :                                                                      :
echo :  This batch file will build the library object files from the        :
echo :  library source files in the \corprims, \extprims and \oemprims      :
echo :  directories.  It will also create and run a series of demo          :
echo :  programs for the designated target graphics card.                   :
echo :                                                                      :
echo :  To configure library for the TMS34010 TIGA Development Board        :
echo :  with a full memory configuration (1M byte VRAM, 1M byte DRAM):      :
echo :                         MAKELIB TDB10                                :
echo :  To configure library for the TMS34010 TIGA Development Board        :
echo :  with the minimum memory configuration (512K bytes of VRAM):         :
echo :                       MAKELIB TDB10MIN                               :
echo :  To configure library for the TMS34010 Software Development Board:   :
echo :                         MAKELIB SDB10                                :
echo :  To configure library for the TMS34020 Software Development Board:   :
echo :                         MAKELIB SDB20                                :
echo :                                                                      :
echo +----------------------------------------------------------------------+

:END
