;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
;                                                                         ;
; pen_point function                                                      ;
;                                                                         ;
;    Draw a point using the pen.  The pen is rectangular, and solid-      ;
;    filled with color 1.  The upper left corner of the pen is placed     ;
;    at the coordinates specified in the two input arguments.             ;
;-------------------------------------------------------------------------;
;  Usage:  pen_point(x,y);                                                ;
;                                                                         ;
;  Description of stack arguments:                                        ;
;          long x, y;        /* coordinates of point to be drawn */       ;
;                                                                         ;
;  Value returned in A8:  Undefined                                       ;
;                                                                         ;
;  Registers altered:  None                                               ;
;-------------------------------------------------------------------------;
; Revision History                                                        ;
;   2/14/86...Original version written ..................John S. Black    ;
;   9/29/86...Copyright header added.....................Stanley Acton    ;
;   3/02/87...Modified source file header................Jerry Van Aken   ;
;   8/07/87...Saved and restored B10-B14.................JV               ;
;   9/18/88...Added TIGA dm, globals and dstbm check.....Graham Short     ;
;-------------------------------------------------------------------------;
;
        .title    'pen point'
        .file     'penpoint.asm'
;
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _pen_point
        .globl    _dm_pen_point
;
;
;     REFERENCE EXTERNAL GLOBALS
;
       .include   gsptypes.inc
       .include   gspglobs.inc          
;
;     C-PACKET ENTRY POINT
;
_pen_point:
        MMTM      SP,B2,B7,B10,B11,B12,B13,B14  ;save register contents
* Form xy address by concatenating x and y coordinate values.
        MOVE      A14,B14                       ;copy STK pointer
        MOVE      *-B14,B2,1                    ;get x coordinate value
        MOVE      *-B14,B7,1                    ;get y coordinate value
        MOVE      B14,A14                       ;update STK pointer
        SLL       16,B7                         ;
        MOVY      B7,B2                         ;concatenate x with y
        jruc      common_ep
;
;     DIRECT MODE ENTRY POINT
;
_dm_pen_point:
        MMTM      SP,B2,B7,B10,B11,B12,B13,B14  ;save register contents
* Form xy address by concatenating x and y coordinate values.
        MOVE      A14,B14                       ;copy STK pointer
        MOVE      *-B14,B7,1                    ;get pointer to data area
        MOVE      *B7,B2,1                      ;get y::x coordinate values
        MOVE      B14,A14                       ;update STK pointer
;
;     TWO ENTRY POINTS JOIN HERE
;
common_ep:
;
; check for destination bitmap pointing to the screen, if not abort for now
; linear drawing capability will be added at a later time
;
        MOVE      @(_env+ENVIRONMENT_DSTBM),B7,1    ; destination bit-map global
        JRNZ      DONE                      ; if zero, dstbm is set to screen
;
;     MAIN ALGORITHM
;
        MOVE      @_env+ENVIRONMENT_XYORIGIN,B7,1       ;
        ADDXY     B7,B2                         ;normalize to screen coordinates
* Fill rectangle at pen position (x,y)          ;
        MOVE      @_env+ENVIRONMENT_PENSIZE,B7,1        ;set DYDX
        FILL      XY                            ;fill rectangular pen
DONE:   MMFM      SP,B2,B7,B10,B11,B12,B13,B14  ;restore register contents
        RETS      2
        .end

