;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1988-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;   name            set_windowing                                         ;
;                                                                         ;
;   synopsis        void set_windowing( mode )                            ;
;                   unsigned short mode;    /* windowing mode   */        ;
;                                                                         ;
;   description     The set_windowing() function sets the window clipping ;
;                   mode as follows:                                      ;
;                                                                         ;
;                       0 = Windowing disabled                            ;
;                       1 = Interrupt on attempt to write inside window   ;
;                       2 = Interrupt on attempt to write outside window  ;
;                       3 = Inhibit writes outside of window              ;
;-------------------------------------------------------------------------;
        .title    'set windowing mode'
        .file     'setwind.asm'
;
;   Declare globals
;
        .globl    _set_windowing
        .globl    _dm_set_windowing
;
;   Include external defs
;
        .include  gspreg.inc
        .mlib     gspmac.lib   ;macros
;
;   Direct-mode entry point 
;
_dm_set_windowing:
        popc    A8              ;get dm-data area address
        move    *A8,A8,1        ;1st dword is mode
        jruc    common_ep
;
;   C-packet entry point
;
_set_windowing:
        popc    A8              ;pop mode
;
;   2 entry points join up here
;
common_ep:
        setf    2,0,0           ;move two bits
        move    A8,@CONTROL+6,0 ;update window mode bits in CONTROL reg
        rets    2
        .end

