        .width    132
;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;           Copyright (c) 1990  Texas Instruments Incorporated.           ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
; set_pmask function                                                      ;
;                                                                         ;
;   Set plane mask.  Loads GSP's PMASK register with specified plane      ;
;   mask.  Given a pixel size of N bits, the plane mask is contained	  ;
;   in the N LSBs of the pmask argument; the 32-N bits to the left of	  ;
;   the plane mask are ignored.  The pixel must be replicated 32/N	  ;
;   times before being written to the 32-bit PMASK register.		  ;
;-------------------------------------------------------------------------;
; Usage:  set_pmask(pmask);						  ;
;                                                                         ;
; Description of stack arguments:                                         ;
;   unsigned long pmask;    /* non-replicated plane mask */		  ;
;                                                                         ;
; Returned in register A8:  void (undefined).				  ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;   02/09/90...Original version written....................Jerry Van Aken ;
;   09/26/90...Modified to handle 32-bit pixels............Jerry Van Aken ;
;-------------------------------------------------------------------------;
;
        .title    'set pmask'
        .file     'setpmask.asm'
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .def      _set_pmask
        .def      _dm_set_pmask
;
;     DEFINE CONSTANTS
;
        .include  gspreg.inc
        .include  oem.inc
;
;    DIRECT-MODE ENTRY POINT
;
_dm_set_pmask:

        MMTM      SP,A0,A1            ;save registers
        MOVE      -*A14,A8,1          ;get dm-data area address
        MOVE      *A8,A8,1            ;get 32-bit pmask arg
        JR        common_ep
;
;
;    C-PACKET ENTRY POINT
;
_set_pmask:

        MMTM      SP,A0,A1            ;save registers
        MOVE      *-A14,A8,1          ;pop 32-bit pmask arg
;
;    2 ENTRY POINTS JOIN UP HERE
;
common_ep:

        .if     GSP_34010 ; Code used if the processor is a 34010
        MOVK      1,A0                ;x = 1, y = 0
        CVXYL     A0,A0               ;get pixel size + offset
	MOVE	  OFFSET,A1	      ;
	SUB	  A1,A0 	      ;remove offset
	MOVE	  A0,A1 	      ;copy pixel size
	EXGF	  A1,0		      ;field size = pixel size
        ZEXT      A8,0                ;zero bits to left of pmask
* Replicate pixel throughout 32-bit register.
	LMO	  A0,A1 	      ;log2(pixel size)
        SUBK      26,A1               ;initialize loop count
        JRZ       NOREP               ;jump if pixel size is 32 bits
LOOP:
        MOVE      A8,A14              ;copy n pixels
	SLL	  A0,A14	      ;make n more pixels
        OR        A14,A8              ;concatenate 2n pixels
        SLL       1,A0                ;double shift count
        DSJS      A1,LOOP             ;
NOREP:
        .endif
        .if     GSP_34020 ; Code used if the processor is a 34020
        RPIX      A8                  ;
        .endif
* Load PMASK register, restore A-file registers and return.
        MOVE      A8,@PMASK,1         ;load 32-bit PMASK register
        MMFM      SP,A0,A1            ;restore registers
        MOVE      *SP(32),A14,1       ;restore program stack pointer
	RETS	  2		      ;
        .end

