;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;                                                                         ;
; peek_breg function                                                      ;
;                                                                         ;
;   Returns the contents of the specified B-file register (32 bits).      ;
;   The legal range of register numbers is 0 to 15.                       ;
;-------------------------------------------------------------------------;
; Usage:  peek_breg(regno);                                               ;
;                                                                         ;
; Description of stack arguments:                                         ;
;   long regno;  /* B-file register number from 0 to 15 */                ;
;                                                                         ;
; Returned in register A8:  Value of specified 32-bit B-file register     ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;                                                                         ;
; Notes:                                                                  ;
;   -- This function ignores all but the 4 LSBs of the regno argument.    ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;   2/10/86...Original version written...................Gwyn Guidy       ;
;   5/16/86...Added TI copyright notice..................Jerry Van Aken   ;
;   3/02/87...Modified source file header................JV               ;
;-------------------------------------------------------------------------;
;
        .title    'peek at B file'
        .file     'peekbreg.asm'
;
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _peek_breg
        .globl    _dm_peek_breg
;
;
;     ENTRY POINT
;
_peek_breg:
        MOVE      A0,*-SP,1           ;Save A0
        MOVE      *-A14,A8,1          ;Get register number
        JRUC      COMMON_EP
_dm_peek_breg:
        MOVE      A0,*-SP,1           ;Save A0
        MOVE      *-A14,A8,1          ;Get pointer to data area
        MOVE      *A8,A8,1            ;Get regno 
COMMON_EP:
        ANDI      15,A8               ;Mask off all but 4 LSBs
        SLL       5,A8                ;Convert to offset address
        MOVI      SWITCH,A0           ;Switch table base address
        ADD       A8,A0               ;Base + offset
        JUMP      A0                  ;Jump into switch table
SWITCH:
        MOVE      B0,A8               ;
        JRUC      EXIT                ;
        MOVE      B1,A8               ;
        JRUC      EXIT                ;
        MOVE      B2,A8               ;
        JRUC      EXIT                ;
        MOVE      B3,A8               ;
        JRUC      EXIT                ;
        MOVE      B4,A8               ;
        JRUC      EXIT                ;
        MOVE      B5,A8               ;
        JRUC      EXIT                ;
        MOVE      B6,A8               ;
        JRUC      EXIT                ;
        MOVE      B7,A8               ;
        JRUC      EXIT                ;
        MOVE      B8,A8               ;
        JRUC      EXIT                ;
        MOVE      B9,A8               ;
        JRUC      EXIT                ;
        MOVE      B10,A8              ;
        JRUC      EXIT                ;
        MOVE      B11,A8              ;
        JRUC      EXIT                ;
        MOVE      B12,A8              ;
        JRUC      EXIT                ;
        MOVE      B13,A8              ;
        JRUC      EXIT                ;
        MOVE      B14,A8              ;
        JRUC      EXIT                ;
        MOVE      SP,A8               ;
EXIT:
        MOVE      *SP+,A0,1           ;Restore A0
        RETS      2
        .end


