/*-----------------------------------------------------------------------*/
/*                                  TIGA                                 */
/*       Copyright (c) 1989-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*  void init_text();                                                    */
/*                                                                       */
/*  This function initializes the text drawing routines. This resets     */
/*  all text drawing attributes to their default state, and clears	 */
/*  the font table, leaving only the system font (ID=0).		 */
/*                                                                       */
/*-----------------------------------------------------------------------*/
/*   01/20/89...Original Version Written.................J.G. Littleton  */
/*   03/15/90...Statically allocated font table..........J.R. Van Aken	 */
/*-----------------------------------------------------------------------*/

#include <gsptypes.h>
#include <gspglobs.h>

#define MAX_FONTS  16	 /* maximum no. of fonts that can be installed */

static FONT *font_table[MAX_FONTS];

ENVTEXT envtext = { 0, MAX_FONTS, font_table, (FONT *)0, 0, 0, 0 };

init_text()
{
    int i;

    for (i = 0; i < MAX_FONTS; i++)
	font_table[i] = (FONT *)0;     /* initialize as nil pointer */

    envtext.installed = 0;	    /* no. of fonts actually installed */
    envtext.allocated = MAX_FONTS;
    envtext.font      = font_table;
    envtext.selected  = sysfont;
    envtext.align     = 0;
    envtext.charextra = 0;
    envtext.effects   = 0;
}

