;---------------------------------------------------------------------------;
;                                    TIGA                                   ;
;        Copyright (c) 1988-1990  Texas Instruments Incorporated.           ;
;                          All Rights Reserved                              ;
;---------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                            ;
;                                                                           ;
;   name            gsp2gsp                                                 ;
;                                                                           ;
;   synopsis        void gsp2gsp( SrcAddr, DstAddr, NumBytes )              ;
;		    char *SrcAddr;	pointer to source		    ;
;		    char *DstAddr;	pointer to destination		    ;
;                   long NumBytes;      number of bytes to move             ;
;                                                                           ;
;   description     This function moves data within GSP memory.  There are  ;
;                   no restrictions on source or destination alignment.     ;
;                   Overlapping regions are handled correctly.              ;
;                                                                           ;
;---------------------------------------------------------------------------;
; History:								    ;
;   11/22/88...Converted to assembler ............................W.S. Egr  ;
;   02/09/90...Fixed case of overlapping src and dst.........J.R. Van Aken  ;
;---------------------------------------------------------------------------;

;---------------------------------------------------------------------------;
;   Include files                                                           ;
;---------------------------------------------------------------------------;
	.copy	  gspreg.inc
        .mlib     gspmac.lib

;---------------------------------------------------------------------------;
;   Global symbols                                                          ;
;---------------------------------------------------------------------------;
        .def      _gsp2gsp, _dm_gsp2gsp

;---------------------------------------------------------------------------;
;   Register usage equates                                                  ;
;---------------------------------------------------------------------------;
SrcAddr .set      A0
DstAddr .set      A8
Length  .set      A14

;---------------------------------------------------------------------------;
;   Direct-mode entry point                                                 ;
;---------------------------------------------------------------------------;
_dm_gsp2gsp:
        move      A0,*-SP,1           ;save register
        Popc      A14                 ;get dm-data pointer
        move      *A14+,SrcAddr,1     ;get source address
        move      *A14+,DstAddr,1     ;get destination address
        move      *A14,Length,1       ;get number of bytes
        jr        CommonEp
;---------------------------------------------------------------------------;
;   C-packet entry point                                                    ;
;---------------------------------------------------------------------------;
_gsp2gsp:
        move      A0,*-SP,1           ;save register
        Popc      SrcAddr             ;get source address
        Popc      DstAddr             ;get destination address
        Popc      Length              ;get number of bytes
;---------------------------------------------------------------------------;
;   Common entry point                                                      ;
;---------------------------------------------------------------------------;
CommonEp:
        setf      8,0,0               ;move 8 bits at a time
;---------------------------------------------------------------------------;
;   Check for overlapping regions                                           ;
;---------------------------------------------------------------------------;
        cmp       SrcAddr,DstAddr
	jrle	  ForwardCopy
;---------------------------------------------------------------------------;
;   Copy data in reverse direction                                          ;
;---------------------------------------------------------------------------;
        sll       3,Length            ;convert to byte offset
        add       Length,SrcAddr      ;point to 1 byte past source data
        add       Length,DstAddr      ;point to 1 byte past dest data
        srl       3,Length            ;restore length
ReverseCopy:
        move      *-SrcAddr,*-DstAddr,0 ;copy next byte
        dsjs      Length,ReverseCopy  ;more bytes?
        jr        Done                ;
;---------------------------------------------------------------------------;
;   Copy data in forward direction                                          ;
;---------------------------------------------------------------------------;
ForwardCopy:
        move      *SrcAddr+,*DstAddr+,0 ;copy next byte
        dsjs      Length,ForwardCopy  ;more bytes?
;---------------------------------------------------------------------------;
;   Return to calling procedure                                             ;
;---------------------------------------------------------------------------;
Done:
        move      *SP+,A0,1           ;restore register
        move      *SP(32),A14,1       ;restore program stack pointer
        rets      2
        .end

