/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*          Copyright (c) 1990 Texas Instruments Incorporated.           */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  file            coredefs.c                                           */
/*                                                                       */
/*  description     This file contains global variable definitions used  */
/*                  in the core primitives of the Graphics Manager       */
/*                                                                       */
/*-----------------------------------------------------------------------*/
/*  history                                                              */
/*    03/21/90	 Added FONT *sysfont definition..............W.S.Egr	 */
/*    04/23/90	 Deleted globals not used in graphics lib....J. Van Aken */
/*-----------------------------------------------------------------------*/
#include <gsptypes.h>       /* type definitions     */

/*----------------------------------------------------------------------*/
/*  ENVIRONMENT structure						*/
/*                                                                      */
/*      This structure contains a number of global variables used       */
/*	throughout the TIGA Graphics Manager.  All structure members	*/
/*      are initialized in the set_config() function.                   */
/*----------------------------------------------------------------------*/
ENVIRONMENT env;

/*----------------------------------------------------------------------*/
/*  PATTERN structure							*/
/*                                                                      */
/*      This structure contains parameters describing the current       */
/*	pattern in use.  All structure members are initialized in	*/
/*	the set_config() function.					*/
/*----------------------------------------------------------------------*/
PATTERN pattern;

/*----------------------------------------------------------------------*/
/*  Pointer to system font                                              */
/*----------------------------------------------------------------------*/
FONT *sysfont;   

