
/*
Generate a simple C30 program that consists of six instructions.

Author: Chi Duong 
Version: @(#)indirect.cc	1.2	08/22/97
*/

#include <stdio.h>

#include "byteswap.cc"

#define LONGWORDS 30 

unsigned long info[LONGWORDS] = {
	0x10689c77L,
	0x10699c77L,
	0x106a9c77L,
	0x106b9c77L,
	0x106c9c77L,
	0x106d9c77L,
	0x106e9c77L,
	0x106f9c77L,
	0x08730007L,
	0x087600f4L,
	0x08710004L,
	0x08631000L,
	0x0860ffffL,
	0x01e0f000L,
	0x0864ffffL,
	0xd1359617L,
	0x25030303L,
	0x8e5cbbc7L,
	0x0c800000L,
	0x0c800000L,		/* NOP */
	0x6a00fff3L		/* B begin */
};

void main() {
	const char* filename = "indirect.c30";
	FILE* output = fopen(filename, "w");

        if (byteSwappedvsPC()) {
          int i;
          for (i = 0; i < LONGWORDS; i++) {
            info[i] = swapBytes(info[i]);
          }
        }

	if (output) {
	  fwrite(info, sizeof(unsigned long), LONGWORDS, output);
	  fclose(output);
	}
	else {
	  fprintf(stderr, "Could not open '%s' for writing.\n", filename);
	}
}
