/*

Freely Distributable C30 Simulator Package

Copyright (c) 1996-1998 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Authors: Chris Moy and Brian Evans
Version: @(#)simmisc.h	1.12	01/19/98

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

#ifndef _SIMMISC_H
#define _SIMMISC_H

#include "pipeline.h"
#include "state.h"

int C30SimGetCycle(pipeline *);
void C30SimInit(state *, pipeline *, c30ProcType);
int C30SimEnd(state *, pipeline *);
void C30SimReset(state *, pipeline *);

/* Address modes */
void C30SimPredisadd(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPredissub(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPredisaddmod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPredissubmod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostdisaddmod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostdissubmod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostdisaddcirc(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostdissubcirc(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPreir0add(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPreir0sub(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPreir0addmod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPreir0submod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostir0addmod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostir0submod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostir0addcirc(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostir0subcirc(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPreir1add(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPreir1sub(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPreir1addmod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPreir1submod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostir1addmod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostir1submod(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostir1addcirc(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimPostir1subcirc(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimIndirect(int, state *,unsigned char,unsigned char,uint32 **);
void C30SimBitrev(int, state *,unsigned char,unsigned char,uint32 **);
#endif
