/*

Freely Distributable C30 Simulator Package

Copyright (c) 1996-1998 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Authors: Brian Evans
Version: @(#)sim3x.h	1.6	01/19/98

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

#ifndef _SIM3X_H
#define _SIM3X_H

#include "state.h"
#include "pipeline.h"
#include "execute.h"

#define C30SIM_VERSION_NUMBER  1.06
#define C30SIM_VERSION_STRING  "1.0.6"

/*=====================================================*/
/* Function form defintion                             */
/*=====================================================*/
typedef void (*SFUNC)(pipeline *pipe, state *st);

/*=====================================================*/
/* A dummy definition to avoid not used warnings       */
/*=====================================================*/
#define dummy_code() pipe->dummy=0; st->dummy=0; if(pipe[0].inst==0) return;

#endif
