/*

Freely Distributable C30 Simulator Package

Copyright (c) 1996-1998 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Authors: Chi Duong, Brian Evans, and Chris Moy
Version: @(#)pipeline.h	1.18	01/19/98 

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

#ifndef _PIPELINE_H
#define _PIPELINE_H
#define C30_NUMBER_OF_REGISTERS 28
#include "state.h"

#define C30_NOP_INST   0x0c800000L

typedef struct pipeline {
  /* floating point operands */
  uint32 opfloat1, opfloat2, opfloat3, opfloat4; 
  uint32 opexp1, opexp2, opexp3, opexp4;  

  /* opcode function pointer */
  void (*finalOpcode1)(struct pipeline *, state *);

  /* opcode function pointer */
  void (*opcode1)(struct pipeline *,state *);

  /* instruction register */
  uint32 inst;

  /* pc intermediate and current values */
  uint32 pc;
  uint32 pci[2];

  /* rc intermediate and current values */
  uint32 rc;
  uint32 rci[2];

  /* distinguish between RC modified by user and repeat mode */
  int repeatModeModifyRC;

  /* operand source pointers */
  uint32 *source1, *source2, *source3, *source4; 

  /* write destination pointers */
  uint32 *dest1, *dest2, *finalDest1, *finalDest2; 

  /* integer operands */
  uint32 oprnd1, oprnd2, oprnd3, oprnd4; 

  /* immediate data operand locations*/
  uint32 hold, finalHold;

  /* interlock flag */
  int interlock;

  /* memory block access counters */
  int access0, access1, accessROM;

  /* instruction modify program counter flag */
  int modifyPC;

  /* count of how many cycles have been executed so far */
  int cycleCount;

  /* register access counters which are updated from tempAccessAR/DP/SP
     if no interlock occurs during opcode stage */
  int accessAR, accessDP, accessSP;

  /* temp register access counters which will be assigned in opcode stage */
  int tempAccessAR, tempAccessDP, tempAccessSP;

  /* pipeline flush flag */
  int flushed;

  /* new program counter value */
  uint32 newPC;

  /* register file pointers; used by decode stage */
  uint32* regs[C30_NUMBER_OF_REGISTERS]; 

  /* decode stage instruction printing flag */
  int dasmPrint;
} pipeline;

#endif
