//------------------------------------------------------------
// ERRORMSG.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//-------------------------------------------------------------------
// ERRORMSG.CPP contains the string definitions that go with
// each enumerated error or message used in the DSK tools and
// applications
//-------------------------------------------------------------------
// For proper operation any code needs a suitably large stack space.
// The assembler and debugger are especially important since they
// include an expression analyzer based on recursion.  As a result a
// considerably larger default stack size may be required beyond the
// value set by Borland (4K default).  By including the _stklen
// definition within this file it is unlikely that this will be a
// problem for any application since this code is linked with all
// DSK executables.
//
// Additionaly a #pragma option -N is used to force the inclusion of
// stack checking and error message print routine.  This was added
// since it is possible to turn this feature off inside Borland's
// Integrated environment
//-------------------------------------------------------------------
extern unsigned _stklen = 0x4000;
#pragma option -N
//-------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "errormsg.h"

char  nullstring[]="";
/*
char  XEMSG[]= "Use sprintf, strcat etc... to write a message to XEMSG[]\n"
              "By then using the EXT_MSG error, the caller function can\r"
              "be signaled to print the message stored in XEMSG[]\n"
              "Note: MSG length is limited to this string\n"
              "\n"
              "sprintf(EMSG,\"TM320C31 DSK\"); //create a message\n"
              "printf(Error_strg(EXT_MSG));    //prints the message\n";
*/
//----------------------------------------------------------
// Error_Strg() returns a string pointer associated with
// an enumerated error type.  The strings returned are used
// in the debugger, assembler and user applications.
//----------------------------------------------------------
char * Error_Strg(MSGS err)
{
  // Operand field type returns
  //
  switch(err)
  {
  // The next four return values are not associated with any error
  // These return values are used by the assembler to pass data type
  // information
  //
  case SRC_REG:
  case SRC_DIR:
  case SRC_IND:
  case SRC_IMM:   return NULL;
  case PATCH_ERR: return "PATCH is under contruction";
  case NO_LINE:   return "No valid characters in line";
  case NO_CODE:   return "No code found at this line";
  case DIR_NO_ERR:return NULL; // "directive: This is NOT an error";
  case NO_ERR:    return NULL; // "GP: This is NOT an error";
  case WARNING:   return "Unspecified WARNING - No message available";
  case ERROR  :   return "Unspecified ERROR - No message available";
  case FATAL:     return "FATAL ERROR has occured";
  case FATAL_OPC: return "FATAL ERROR opcode or operand convert failure";
  case WARN:      return "WARNING - converted value may not be correct";

  case W_SIZE8:   return "WARNING - Operand is not 8 bit immediate";
  case W_SIZE16:  return "WARNING - Operand is not 16 bit immediate";
  case W_SIZE24:  return "WARNING - Operand is not 24 bit immediate";

  case W_GLBL:
  return "CAUTION: .ref .def and .global are ignored by DSK3A";
  case W_IS_IMMED:return "WARNING - Immediate operand assumed";
  case W_IS_REG:  return "WARNING - Register operand assumed";
  case TIMEOUT:   return "Application timout has occured";
  case ABORT:     return "Application aborted";
  //
  // Assembler error returns
  //
  case TOO_MANY_ERR: return "FATAL: Too many errors";
  case NO_OPRND    : return "No operand found";
  case MISS_ARG    : return "Operand(s) are missing";
  case XTRA_ARG    : return "Extra operand(s)";
  case BAD_ARG     : return "Invalid, undefined or missing operand";
  case MISSING_EQ  : return "Missing \'=\'";
  case BAD_OPCD  : return "Unknown opcode";
  case REG_INT   : return "Improper use of Integer Register field";
  case USE_LDI   : return "Invalid operation - Use LDI";
  case NO_STIK   : return "Invalid operation - STIK (store immediate)";
  case NOT_IMMED : return "Operand should evaluate to immediate";
  case PAR_ERR   : return "Illegal parallel operation";
  case DISP_ERR  : return "Illegal displacement";
  case IND_ERR   : return "Illegal indirect operation";
  case IRX_ERR   : return "Illegal indirect IRX value";
  case INC_ERR   : return "Illegal indirect increment value";
  case CIR_ERR   : return "Illegal indirect circular addressing";
  case BAD_MOD   : return "Bad modifier";
  case INV_CMBN  : return "Invalid combination of operands";
  case CONV_ERR  : return "Operand referencing or conversion has failed";
  case LABEL_ERR : return "Label format is not correct";
  case SET_ERR   : return ".set directive not correctly specified";
  case MULT_REF  : return "Symbol is multiply defined";
  //
  // Debugger error returns
  //
  case IIF_ERR     : return "IF modification within DSK3D not allowed";
  case BP_FOUND    : return "Breakpoint found";
  case TOO_MANY_ARGS:return "Too many operands";
  case UNKN_ERR    : return "Unknown Error";
  case ACCESS_ERR  : return "File not found";
  case OPEN_ERR    : return "Can not open file";
  case DSK_FILE_ERR: return "DSK3A file format error";
  case FORMAT_ERR  : return "COFF file format error";
  case DATA_ERR    : return "COFF file data error";
  case SYS_ERR     : return "System Error (out of memory)";
  case TOO_MANY_BRKPT:return"Too many breakpoints";
  case OUT_MAP     : return "Memory access outside of mapped memory";
  case DELAYED_ERR :
  return "BP not allowed 3 cycles after a delayed instruction";
  case NO_BRKPT    : return "Breakpoint does not exist";
  case FLOAT_OVF   : return "Floating point overflow";
  case INT_VALUE   : return "Integer value expected";
  case RUN_ERR     : return "Target did not recognize HALT";
  case EXPR_ERR    : return "Bad expression";
  case UNKN_EXPR   : return "... is not defined";
  case EXPR_ANAL   : return "Expression Analysis Error";

  case BAD_ARGS    : return "Bad operand";
  case UNK_FUNC    : return "Unknown function - not implemented";
  case BP_ERR      : return "Can not set breakpoint";
  case USER_STOP   : return "User Halt before breakpoint found";
  case BAD_REGISTER: return "Register R0-R7 expected";
  case NOT_ALWD    :
  return "... is not allowed or invalid for this operation";
  //
  // COFF file handler errors
  //
  case INV_COFF_MGC:
  return "Not a COFF/DSK file, no Magic Number found";
  case BAD_OPTN_HDR: return "COFF file 'Option Header' is corrupt";
  case MAX_SECTN   :
    return "COFF file has too many sections for loader";
  //
  // General Purpose COMM Kernel errors
  //
  case HOST_PORT:return "HPI address is not valid memory";
  case XMIT_ERR: return "Host I/O xmit error, 0xC4 OR'd with IE?";
  case RECV_ERR: return "Host I/O recv error, 0xC4 OR'd with IE?";
  case COM_ERR : return "Communication error, 0xC4 OR'd with IE?";
  //
  // ERR returns for M4X (TMS320C4x Multiprocessor Comm & Debug Kernel)
  //
  case MAX_FLEN  :return "Caution Max File Length now exceeds 2048 words";
  case MAX_FLEN2 :
  return "Length > Max Length, Use MAXFLEN xxxx (do not use =)";
  case BAD_LENGTH:return "Packet length too long";

  case INIT_ERR : return "Initialization Error";
  case Recover1 :
  return "SSTEP failed, INT2 used to resynch, use SF8/SF10 to step code";
  case Recover2 :
  return "SSTEP failed, INT2 resynch failed, use SF8/SF10 to step code";
  case RPTB_ERR :
  return "WARNING: BP's set at RE and RS-1, RPTB will be corrupted";
  //
  // Enumerated directive search return values
  //
  case FATAL_SYM1: return "FATAL: Too many symbols defined";
  case FATAL_SYM2: return "FATAL: Symbol string table is too long";
  case range_warn: return "WARNING: Illegal numeric function input";
  case NO_REF    : return "Symbol is not defined";
  //
  case FIX_COFF  : return "Fixed Point COFF file";
  case FLOAT_COFF: return "Floating Point COFF file";
  case FATAL_OPEN: return ">>>>> FATAL ERROR: >> CAN NOT OPEN FILE";
  case FILE_HEX  :
  case DSK_HEX   :
  case COFF_HEX  :
  case MEM_HEX   : return "FILE/DSK/COFF/MEM to HEX convert failed";

  case HEX_COFF  :
  case MEM_COFF  :
  case DSK_COFF  : return "HEX/MEM/DSK to COFF convert failed";
  //
  case ENBL_WIN  : return "Windows detected, Timeslice = ON";
  case DSBL_WIN  : return "Windows not detected, Timeslice = OFF";
  //
  case d_disp    : return "Displacement greater than 16 bits";
  case d_sfloat  : return "use:  .sfloat  <expr>,... 4-1-11 format";
  case d_psfloat : return "use:  .psfloat <expr>,... 4-1-11 format";
  case d_float8  : return "use:  .float8  <expr>,... 4-1-3  format";
  case d_float16 : return "use:  .float8  <expr>,... 8-1-7  format";
  case d_pfloat8 : return "use:  .pfloat8 <expr>,... 4-1-3  format";
  case d_pfloat16: return "use:  .pfloat8 <expr>,... 8-1-7  format";
  //
  case d_start   : return "use:  .start \"sect_name\",start address";
  case d_entry   : return "use:  .entry <entry_point>";
  case d_data    : return "use:  .data   ; Be sure to .start before use";
  case d_text    : return "use:  .text   ; Be sure to .start before use";
  case d_sect    : return "use:  .sect \"sect_name\"";
  case d_sect_add: return "Too many sections declared";
  case d_err_sect1:return "section must have '.start' location before use";
  case d_err_sect2:return "multiple section start - use a new name";
  //
  case d_end   : return "use:   .end";
  case d_set   :
  return "  .set expressions must be pre-defined in pass1 or pass2";
  case d_word  : return "use:   .word <expr>,...";
  case d_float : return "use:   .float <expr>,...";
  case d_int   : return "use:   .int <expr>,...";
  case d_long  : return "use:   .long <expr>,...";
  case d_byte  : return "use:   .byte <expr>,...";
  case d_hword : return "use:   .hword <expr>,...";
  case d_space : return "use:   .space <size_in_words>";
  case d_fill  : return "use:   .fill <size_in_words>,<value>";
  case d_err   : return "unknown directive error";
  case d_if    : return "use:   .if <expression>";
  case d_ifdef : return "use:   .ifdef symbol";
  case d_ifndef: return "use:   .ifndef symbol";
  case d_define: return "use:   .define symbol";
  case d_else  : return "use:   .else";
  case d_endif : return "use:   .endif";
  case d_if_lvl: return "Nesting too deep, invalid or has no match";
  case d_nocode: return "(WARN?) d_nocode warning";
  case d_ieee  : return "use:   .ieee <expression>,...";
  case d_qxx   : return "use:   .qxx <expression>,...";
  case d_copy  : return "Copy (include) file error";
  case d_inc   : return "Include file error";
  case d_inc2  : return "FATAL: Include nesting is too deep";
  case d_rstring:
  case d_string: return "String conversion error";
  case d_double: return "Double float convert error";
  case d_align : return "use:  .align  ; align to next 32 word boundary";
  case d_bitrev:
  return "usage  .bitrev <size> ; align to valid address for 'size' table";
  case non_coff_math:
  return "CAUTION: DSK3A source code is not COFF compatible";
  case math_err:
  return "  math() input or output has generated an error";

  case d_loop:
  return "use: .loop  16  ; Repeat .loop/.endloop maximum is 1024";
  case d_eloop: return "use: .endloop   ; end .loop code";
  case DISABLED: return "Disabled function";
  //
  // Expression analyzer error
  //
  case  x_syntax  : return "Syntax error";
  case  x_ubalance: return "Unbalanced () parenthesis";
  case  x_noexp   : return "No expression present";
  case  RESET_ERR : return "Reset failure";
  case  FILE_LEN  : return "File name is too long";
  case  BOOT_RNG  : return "Cannot Boot 0x809800-0x809801";
  case  DOS_OS    : return "MSDOS file";
  case  UNIX_OS   : return "UNIX file";
  case  VERIFY_ERR: return "Write verify error";
//chi dsk3c30
  //case  C30SIM_MISMATCH: return "c30sim != dsk dsp";
  default         : break;
  };
  return "Unknown Error";
};

// Extended length message - written to by caller
//case EXT_MSG:   return "EXT_MSG removed in ver 1.20";
                //return XEMSG;
// General purpose NO_ERR returns
//  case CMDFILE:   return "CMD file, TAKE file";
//case MEM_ERR     : return "Dump window error";
//case DASM_ERR    : return "DASM window error";
//case CPU_ERR     : return "register window error";
//case MEMORY_ERR  : return "Memory allocation error";
//case RPTS_ERR    : return "Can not set a BP on RPTB or RPTS";
//case EXEC_ERR    : return "Execution error";
//case CALC_ERR    : return "Calculation error";
//case INSTR_ERR   : return "Can not execute this instruction";
//case TRAP_ERR    : return "A reserved TRAP has been encountered";
//case FIFO_OVF : return "Recv Err, FIFO overflow";
//case BAD_OSTEP: return "Can not set BP on RPTB block end after call";
//case RCRASH   : return "XMIT error";
//case XCRASH   : return "XMIT error";
//case SP_CONFLICT:
//return "The SP can not be located inside the kernel space";
//case d_tfloat: return "Triple float convert error";
//case d_loopn:
//return "A maximum of 256 lines are allowed to be looped 1024 times";

