/*

Freely Distributable C30 Simulator Package

Copyright (c) 1996-1998 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
  
The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Authors: Chi Duong, Brian Evans, and Chris Moy
Version: @(#)ut_cmds.cc	1.5	01/19/98

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

To add simulator commands for a debugger for a particular
board, add an entry to simulatorCommandTables.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "ut_cmds.h"
#include "loadc30.h"

C30SimCommandFunctions C30SimUTCommandFunctionsList[] = {
    { "assm",   4, C30SimAssembleCommand,
      "file [Eerr_limit] [Wwarn_limit] - assembles file up to default (5) or err/warn_limit. e.g: assm filename.asm e20 w20" },
    { "+break",   6, C30SimBreakAddCommand,
      "addr - adds a breakpoint at address addr." },
    { "-break",   6, C30SimBreakDelCommand,
      "[addr] - deletes breakpoint at address addr or all breakpoints if no addr given." },
    { "c30state", 8, C30SimC30StateCommand,
      "- displays the state of the C30 processor." },
    { "copyright", 9, C30SimCopyrightCommand,
      "- displays the copyright information for the simulator." },
    { "cycle",    5, C30SimCycleCommand,
      "- prints number of instruction cycles executed since the last reset." },
    { "+dasm",    5, C30SimDasmOnCommand,
      "- turns on printing of the instruction in the pipeline decode stage." },
    { "-dasm",    5, C30SimDasmOffCommand,
      "- turns off printing of the instruction in the pipeline decode stage." },
    { "exit",     4, C30SimExitCommand,
      "- exits the simulator." },
    { "help",     4, C30SimHelpCommand,
      "[command] - prints help on command or lists all commands if no command given." },
    { "load",     4, C30SimLoadCommand,
      "file [addr] - loads specified program at address addr if no address is specified in the file." },
    { "modify",   6, C30SimModifyCommand,
      "var val - stores the value val in a C30 register or memory address at var." },
    { "quit",     4, C30SimExitCommand,
      "- exits the simulator." },
    { "read",     4, C30SimReadCommand,
      "var - prints the contents of the C30 register or memory address given by var." },
    { "reset",    5, C30SimResetCommand,
      "- resets the C30 processor and clears the breakpoints." },
    { "reload",   6, C30SimReloadCommand,
      "- executes the last load command." },
    { "run",      3, C30SimRunCommand,
      "- executes the current program until a breakpoint is encountered." },
    { "runfree",  7, C30SimRunFreeCommand,
      "- executes the current program and ignores breakpoints." },
    { "rununtil", 8, C30SimRunUntilCommand,
      "addr - executes the current program until the address addr is reached." },
    { "simstate", 8, C30SimSimStateCommand,
      "- displays the state of the C30 simulator such as breakpoints." },
    { "step",     4, C30SimStepCommand,
      "[n] - executes n instructions (one by default)." },
    { "update",   6, C30SimUpdateCommand,
      "- displays changes in the registers since the last time update was used." },
    { "version",  7, C30SimVersionCommand,
      "- displays the version of the simulator." },
    { "",         0, 0, "" }
};
