/* MODULE NAME: SIM56800.C                                           */

/* MODULE DESCRIPTION:                                               */
/*   This module contains the main entry point for the DSP56800      */
/* simulator SIM56800.                                               */

/* FUNCTIONS:                                                        */
/* main(argc,argv) - SIM56800                                        */

/*
Modified by Anna Yuan and Brian L. Evans
The University of Texas at Austin

UT Version:	@(#)sim56800.c	1.10	07/01/98
*/

/* Must include our changes first */
#include "utsim.h"

#include "simcom.h"
#include "simdev.h"
#include "simusr.h"
#include "protocom.h"
#include "proto568.h"
extern struct dev_const dv_const;
extern struct sev_const sv_const;

/* main simulator entry point */
int main (int argc, char **argv)
{
    int i;
    struct sev_var *sv;
    struct dev_var *dv;
    char cmdstr[256];	/* Will hold command strings input from terminal */
    char* input = 0;

    dv_const.nodisplay = 1;  /* 1 means to inhibit display on the I/O device */
    dv_const.revnum = VersionIdentification;

#if (MSDOS)&(!WIN32)
    (void) _grow_handles( 100 ); /* attempt to increase file handles to 100 */
#endif
    dsp_startup ();		/* Initialize simulator windows and global structures */
    (void) dsp_new (0, "56800");
    simw_wscr (dv_const.revnum, 1);	/* Display the simulator version on device 0 window */
    /* Begin with execution of macros specified in command line */
    if (argc >= 2)
    {
	sim_docmd (0, argv[1]);	/* Execution of other macros <name>.cmd */
    }

#if macintosh
    simw_macstartup ();
#endif

    /* This is the main execution loop.  If the device is at a breakpoint, */
    /* the next command is requested from a macro file or from the terminal. */
    /* Commands that cause the device to begin executing will set the */
    /* "executing" flag in the hsp stat structure. */

    for (;;)
    {
	do
	{   /* get keyboard instructions until all devices are ready to go */
	    i = sv_const.viewdev;
	    sv = sv_const.sv[i];
	    if (sv && !sv->stat.executing); /* stay until device is executing */
	    else
	    {
		for (i = 0; i < dv_const.maxdevices; i++)
		{			      /* check all devices for break */
		    sv = sv_const.sv[i];
		    if (sv && !sv->stat.executing)
		    {
			sv_const.viewdev = sv_const.breakdev = i;
			simw_redo (i);
			break;
		    }
		}
	    }

	    if (i < dv_const.maxdevices)
	    {
		/* Flag to pass the command to the Motorola 56800 evaluator */
		int processCommand = TRUE;

		if (sv_const.in_macro)
		    sim_gmcmd (i, cmdstr);	/* get macro command */
		if (!sv_const.in_macro) 
		{
		  /* sim_gtcmd (i, cmdstr);	 get terminal command */
		  input = ut_get_command(cmdstr, &processCommand);
		  if (processCommand) {
		    siml_parse_cmd (input);
      		    siml_parse (input, TRUE); 
		  }
		}
		if (processCommand) {
		  sim_docmd (i, cmdstr);
		}
	    }
	}
	while (i < dv_const.maxdevices);

	for (i = 0; i < dv_const.maxdevices; i++)
	{
	    dv = dv_const.sv[i];
	    if (!dv || (dv->flg_stat & DSP_GOFF));	/* device not in use */
	    else
		dsp_exec (i);	/* execute until breakpoint is reached */
	}
    }
    return(0);
}				/* end of main */
