#ifndef	__protocom_h__
#define __protocom_h__

/* from coffload.c */
int dsp_ldcoff (int devindex, char *filename);
int dsp_svcoff (char *filename, int mode);
#if BLM
int dsp_svmem (int devindex, char *filename);
int dsp_svmem_lod (int devindex, char *filename);
int dsp_svmem_coff (int devindex, char *filename);
#endif
#if FULLSIM
/* from scrmgr.c */
#if macintosh
char *siml_macfile ();

#endif
void siml_winit (void);
void simw_redo (int devindex);
void simw_wscr (char *bufptr, int flag);
void simw_wscr_c (char *bufptr, int flag);
void simw_redraw (int count);
void simw_cursor (int line, int column);
void simw_putc (char c);
void simw_ceol (void);
void simw_puts (int line, int column, char *text, int flag);
int simw_gkey (void);
void simw_getch (void);
void simw_refresh (void);
void simw_scrnest (void);
void simw_unnest (void);
void simw_endwin (void);
int simw_ctrlbr (void);
void simw_paint_screen (char *bp);

/* from simcutil.c */
void sim_gtcmd (int devindex, char *csr);
void siml_errprint (char *str);
int  siml_getcmdi (char *csr, int cols, int colp, char *hlp);
void siml_macro (char *cs);
void sim_gmcmd (int devindex, char *cs);
void siml_frmac (void);
int siml_open_file (char *fn, int flag);
void siml_working (void);
void siml_mbset (int brkflag, int memindex, unsigned long address, int ioxref);
int siml_getcode (enum memory_map memtp, unsigned long address, char *str, int byte_wide);
void sim_docmd (int devindex, char *cmdstr);
void siml_iofree (struct sev_iolist **iopp, char *str, int allflg);
struct sev_iolist *siml_miofind (struct sev_iolist *iop, int ioxref);
struct sev_iolist *siml_iofind (struct sev_iolist *iop, int iot, int ioi, unsigned long iost);
void siml_dispput (struct sev_mtag **where, unsigned long stadd, unsigned long endadd, unsigned long maxadd, int enabtype);
int siml_mtest (struct sev_mtag **where, unsigned long address);
void siml_helpm (int flag);
void siml_help_prnt (char *hlpstr);
void siml_dispnowe (int show_watch_list);
void siml_dispshow (int show_watch_list);
void siml_dispmem (void);
char *siml_flt_to_str (char *fstrp, union sev_dubl *uv);
int siml_rstring (int periph, int r, int radix, char *retstr);
int siml_next_avail_watch_number(struct sev_watch_node *);
struct sev_watch_node *siml_find_watch_node_by_num(struct
                                                   sev_watch_node *, int);
void siml_add_to_watch_list(struct sev_watch_node *, struct
                            sev_watch_node *);
void siml_remove_watch_node_by_num(struct sev_watch_node *, int);
void siml_remove_all_watch_nodes(struct sev_watch_node *);
int siml_strncasecmp (const char *, const char *, size_t);
int siml_strcasecmp (const char *, const char *);
void siml_clrbuff (void);
char *siml_parse_cmd (char *);
int siml_pr_error (char *);
void siml_increg (int *regn, int *periph);
void siml_decreg (int *regn, int *periph);

#endif /* FULLSIM */

/* from simeval.c */
struct sev_evres *dspl_evad (unsigned long devattr);
struct sev_evres *dspl_evint (unsigned long devattr, unsigned long addrmask);
struct sev_evres *dspl_evwrd (unsigned long devattr);
struct sev_evres *dspl_eval (unsigned long devattr);
void dspl_frexp (struct sev_evres *ep);
void dspl_error (char *str);
void dspl_error2 (char *str1, char *str2);
int dspl_any (char c, char *str);
void dspl_sztfd (unsigned long devattr, struct sev_evres *p);
double dspl_stfd (unsigned long devattr, struct sev_evres *p);
void dspl_fdts (unsigned long devattr, struct sev_evres *ev);
void dspl_ltfd_96k (unsigned long tv, struct sev_evres *p);
void dspl_ltfd (unsigned long devattr, struct sev_evres *p);
unsigned long dspl_fdtl_96k (struct sev_evres *p);
long dspl_fdtl (unsigned long devattr, struct sev_evres *p);
void dspl_vtfd (unsigned long devattr, struct sev_evres *p);
void dspl_fdtv (unsigned long devattr, struct sev_evres *p);
void dspl_actd (unsigned long devattr, unsigned long *v, unsigned long *r);
void dspl_vltd (unsigned long devattr, unsigned long *v, unsigned long *r);

#if FULLSIM
/* from simparse.c */
int siml_is_portname (int field);
int siml_is_address_on_device (int field, int devindex);
int siml_is_address (int field);
int siml_is_devaddress (int field);
int siml_is_baction (int field);
int siml_is_bexpr (int field);
int siml_is_bmemory (int field);
int siml_is_bdmamemory (int field);
int siml_is_bnumber (int field);
int siml_is_brange (int field);
int siml_is_border (int field);
int siml_is_wnumber (int field);
int siml_is_blist (int field);
int siml_is_boccur (int field);
int siml_is_valid_c_expr (int field);
int siml_is_valid_c_bp_expr (int field);
int siml_is_valid_c_type_expr (int field);
int siml_is_valid_c_watch_expr (int field);
int siml_is_c_expr (int field);
int siml_is_command (int field);
int siml_is_devnum (int field);
int siml_is_winnum (int field);
int siml_is_devtype (int field);
int siml_is_doption (int field);
int siml_is_empty (int field);
int siml_is_eradix (int field);
int siml_is_expr (int field);
int siml_is_cexpr (int field);
int siml_is_gaddr (int field);
int siml_is_iexpr (int field);
int siml_is_ilist (int field);
int siml_is_filename (int field);
int siml_is_field (int field);
int siml_is_fnumber (int field);
int siml_is_iolist (int field);
int siml_is_lint (int field);
int siml_is_logical (int field);
int siml_is_mblock (int field);
int siml_is_mode (int field);
int siml_is_mnemonic (int field);
int siml_is_mspace (int field);
int siml_is_piexpr (int field);
int siml_is_pin (int field, int devindex);
int siml_is_devpin (int field);
int siml_is_pinrange (int field);
int siml_is_periph (int field);
int siml_is_ioperiph (int field);
int siml_is_rmmb (int field);
int siml_is_rlmmbs (int field);
int siml_is_rbmmbs (int field);
int siml_is_register (int field);
int siml_is_radix (int field);
int siml_is_ioradix (int field);
int siml_is_pullup (int field);
int siml_is_oradix (int field);
int siml_is_olist (int field);
int siml_is_iooption (int field);
int siml_is_rblock (int field);
int siml_is_reglist (int field);
int siml_is_cc_flag (int field);
int siml_is_cc_mblock (int field);
int siml_is_cc_address (int field);
int siml_is_cc_flmmbs (int field);
int siml_is_hwbp (int field);
int siml_is_swbp (int field);
int siml_is_texpr (int field);
int siml_is_short (int field, unsigned long addrmask);
int siml_is_string (int field, char *str);
int siml_p_search (int field, char **strlist, char tag, int arrsize);
int siml_chpos (char *str, char chr);
int siml_spos (char *str, char *find);
int siml_is_stdstream (int field);
struct st_cexec *siml_parse (char *str, int flag);

#if ADSx
int siml_is_devlist (int field);
int siml_is_ccnum (int field);
int siml_is_tmsnum (int field);
int siml_is_chainpos (int field);
int siml_is_long (int field);
#endif /* ADSx */


#endif /* FULLSIM */

/* from simutil.c */
void siml_csim (void);
void siml_switch_to_device (int);
int dsp_rreg (int dev, int p, int r, unsigned long *retv);
int dsp_findreg (int dev, char *regname, int *p, int *r);
int dsp_wreg (int dev, int p, int r, unsigned long *val);
int dspl_stolow (char *buf);
int dsp_ldmem (int devindex, char *loadfn);
int dsp_save (char *fn);
int dsp_saven (char *fn, int start_devnum, int end_devnum);
int dsp_new (int devindex, char *devtname);
void dsp_init (int devindex, int mode);
void dsp_free (int devindex);
int dspl_reset (int hardware, int mode);
int dsp_load (char *filename);
void dsp_exec (int devindex);
void dsp_path (char *pathp, char *base, char *sufx, char *retn);
int dsp_spath (char *base, char *sufx, char *retn);
void dsp_startup (void);
int dspl_mindx (enum memory_map memt, unsigned long addr);
int dsp_unlock(char *devname, char *dev_password);
#if ADSx
int dsp_ldmem_bw (int devindex, unsigned long offset, char *loadfn);
int dsp_cc_ldmem (int devindex, char *loadfn);
int ads_startup (char *devp, int devtype);
int ads_cache_registers (int devindex);
#endif /* ADSx */
#if BLM
int dsp_execp (int devindex);
void dsp_async (int devindex);
#endif

/* from simvmem.c */
void *dsp_alloc (unsigned int nbytes, int clearmem);
void  dsp_free_mem (char *free);
void *dsp_realloc (char *cp, unsigned int nbytes);
void dspl_xmfree (int devindex);
int dspl_xmsave (int devindex, FILE *fp);
void dspl_xminit (int devindex);
int dspl_xmnew (void);
int dspl_xmload (int devindex, FILE *fp);
int dspl_xmrd (int devindex, enum memory_map memt, unsigned long address, unsigned long *to_buf, int fetch);
void dspl_xmwr (int devindex, enum memory_map memt, unsigned long address, unsigned long value, int store);
void dspl_xmstart (int devindex, enum memory_map memt, unsigned long address);
void dspl_xmend (int devindex, enum memory_map memt, unsigned long address);
void *dsp_alloc (unsigned int nbytes, int clearmem);
void *dsp_realloc (char *cp, unsigned int nbytes);

/* from simxmem.c */
void dspl_xrefwr (unsigned long maddr, unsigned long regv, int se);
void dspl_xrefrd (unsigned long maddr, unsigned long *regv, int se);
void dspl_yrefwr (unsigned long maddr, unsigned long regv, int se);
void dspl_yrefrd (unsigned long maddr, unsigned long *regv, int se);
int dsp_wmem (int dev, enum memory_map memp, unsigned long add, unsigned long *value);
int dsp_rmem (int dev, enum memory_map memp, unsigned long add, unsigned long *value);
int dsp_fmem (int dev, enum memory_map memp, unsigned long add, unsigned long blocksize, unsigned long *value);
int dsp_findmem (int dev, char *memname, enum memory_map *m);
void siml_setmradix (int mem, unsigned long stadd, unsigned long spadd, int radix);
int siml_getmradix (int mem, unsigned long address);
void siml_astring (unsigned long address, char *addrs);
int siml_mstring (enum memory_map memtype, unsigned long address, int radix, char *retstr, char *formatstr);
int siml_mstring2 (enum memory_map memtype, unsigned long address, unsigned long* value, int radix, char *retstr, char *formatstr);
#if ADSx
int dsp_wmem_blk (int dev, enum memory_map memp, unsigned long add, unsigned long count, unsigned long *value);
int dsp_rmem_blk (int dev, enum memory_map memp, unsigned long add, unsigned long count, unsigned long *value);
#endif
void siml_iomstring (int memtype, unsigned long address, int radix, char *retstr, unsigned long memval);
void siml_memlog (enum memory_map memt, unsigned long addr, int readflag, unsigned long dmaflag);
void siml_xmemflag (unsigned long xaddr);

/* from simxutil.c */
int dsp_rpin (int devindex, int pin);
int dsp_rapin (int devindex, int pin, float *retvf);
int dsp_wpin (int devindex, int pin, int value);
int dsp_wapin (int devindex, int pin, float value);
int dsp_findpin (int devindex, char *pinname, int *pin);
int dsp_findport (int devindex, char *portname, int *port, unsigned long *mask);
void dsp_rport (int devindex, int port, unsigned long *data, unsigned long *force);
void dsp_wport (int devindex, int port, unsigned long mask, unsigned long data, unsigned long force);

#if FULLSIM
/* from sourcedb.c */
int siml_findsym (char *symname, struct sev_evres *p);
char *siml_sympc (enum memory_map pc_map, unsigned long pc);
int siml_ldsym (int dev, char *filename);
void siml_display_source (int direction);
int siml_gomode (int gomode);
void siml_test_sbp (int *brkshow, int *breakpt);
int siml_is_line (int field);
int siml_find_line (char *symname, struct sev_evres *p, int *real_line);
int siml_nextsym (int prev_symnum, char **cpp);


char *siml_symbol_name (SYMENT * se);
int siml_find_closest_symbol_for_pc (unsigned long addr,
                                     enum memory_map add_map, int *ret_ulocal);
int siml_find_file_for_pc (unsigned long pc, enum memory_map pc_map);
char *siml_find_filename_for_pc (unsigned long pc, enum memory_map pc_map);
char *siml_find_filename_for_file_index (int file_index);
int siml_find_line_rec_for_pc (unsigned long pc, enum memory_map pc_map);
int siml_alloc_screen (void);
char *siml_aux_symbol_name (AUXENT * ae);
int siml_find_section_for_pc (unsigned long pc, enum memory_map pc_map);
int siml_find_inner_bm_for_secnum (int secnum);

/* from xbreak.c */
void siml_frbrk (void);
int siml_break (void);

/* from xhelp.c */
void siml_help_all (void);
void siml_helpq (char *from);

/* from xinput.c */
void siml_scandecimal (char *buf, struct sev_evres *retv, unsigned long sz);
void siml_scanhex (char *buf, struct sev_evres *retv, unsigned long sz);
void siml_scanbin (char *buf, struct sev_evres *retv, unsigned long sz);
void siml_scanfloat (char *buf, struct sev_evres *retv, unsigned long sz);
void siml_scanradix (char *buf, struct sev_iolist *iop, unsigned long sz);
int siml_iorm (int mem, unsigned long address, unsigned long *memval);
int siml_iorport (int port, unsigned long *retval);
int siml_iorperiph (int port, struct sev_evres *retval);
int siml_iorreg (int periph, int regnum, unsigned long *retval);
int siml_iors (int port, struct sev_evres *retval);
void siml_ifile (void);

/* from xoutput.c */
void siml_iowrites (struct sev_iolist *iop, char *str);
void siml_ofile (void);
void siml_iowm (int mem, unsigned long address, unsigned long memval);
void siml_iowport (int port, unsigned long *val, long repcnt);
void siml_iowhistory (int j);
int siml_iowehistory (char *str);
void siml_iowperiph (int port, unsigned long *valp, long repcnt);
void siml_iowreg (int periph, int regn);
int siml_iowdhistory(char *str);

/* from xwatch.c */
void siml_list_all_watch_nodes (void);

/* from guiutil.c or guistub.c */
void gui_startup (int, char **, char *);
void siml_gui_quit (void);
void siml_update_windows (int, int);
int siml_gui_errprint (char *);
int siml_gui_help_prnt (char *);
void *siml_gui_alloc (unsigned int, int);
void siml_gui_free_mem (char *);
void *siml_gui_realloc (char *, unsigned int);
void siml_display_error (char *);
void siml_gui_logon (char *);
void siml_gui_outputf (char *);
void siml_gui_savestat (char *, int);
void siml_gui_savemem (char *);
void siml_gui_wait (void);
void siml_gui_waitb (void);
void siml_destroy_devices_windows (int);
char siml_ask_overwrite (void);
int siml_new_interactive_input_dialog (char *, int);
void siml_gui_update_command_prompt (void);
void siml_gui_set_pathwork (void);
#endif /* FULLSIM */

#if ADSx
/* From exec.c */

int dsp_go (int);
int dsp_go_address (int, unsigned long);
int dsp_go_reset (int);
int dsp_step (int, unsigned long);
int dsp_stop (int);
int dsp_reset (int);
int dsp_status (int, int *);
int dsp_working_mode (int, int *);
int dsp_check_service_request (int);

/* From once.c */
int siml_cache_once_registers (int, int);
/* From corexx.c */
int siml_cache_core_registers (int, int);

/* From xadsbrk.c */
int siml_break_install (int);
int siml_temp_break_install (int, unsigned long);
int siml_break_remove (int);
#if FULLSIM
int siml_fbrk (void);
int siml_brk (int);
#endif /* FULLSIM */

/* From cc.c */
int dsp_cc_rmem (int, enum memory_map, unsigned long, unsigned long *);
int dsp_cc_wmem (int, enum memory_map, unsigned long, unsigned long *);
int dsp_cc_fmem (int, enum memory_map, unsigned long, unsigned long,
                 unsigned long *);
int dsp_cc_rmem_blk (int, enum memory_map, unsigned long, unsigned long,
                     unsigned long *);
int dsp_cc_wmem_blk (int, enum memory_map, unsigned long, unsigned long,
                     unsigned long *);
int dsp_cc_go (int);
int dsp_cc_reset (int);
int dsp_cc_break (int);
int dsp_cc_service (int);
int dsp_cc_revision (int, char *);

void dsp_set_host_timeout (int timeout);
void dsp_set_host_address (int hostaddr);
void dsp_configure_device (int devindex, int ccnum, int tmsnum, int chainpos);
void dsp_set_tms_chain_length (int ccindex, int tmsnum, int chainlen);
int dsp_get_host_timeout (void);
int dsp_get_host_address (void);
void dsp_get_device_configuration (int devindex, int *ccnum, int *tmsnum,
                                   int *chainpos);
int dsp_get_cc_num (int devindex);
int dsp_get_tms_chain_length (int ccindex, int tmsnum);

/* From ccutil.c */
int siml_set_cc_bp (int, unsigned long *, unsigned long *, unsigned long *,
                    unsigned long *);
int siml_clear_cc_bp (int, unsigned long, unsigned long, unsigned long,
                      unsigned long);

/* From xadsin.c */
int siml_check_input (int, int *);

/* From xadsout.c */
int siml_check_output (int, int *);

#endif
#if FULLSIM
/* from profiler rg functions */

extern struct PROGRAM *siml_rg_program;		/* the program */
extern jmp_buf siml_rg_jumper;	/* error anchor */
extern char siml_rg_active_file[MAX_FULL_PATH_LEN];	/* last file opened */
extern time_t siml_rg_active_date;	/* date of file last opened for read */
extern struct sev_var *sv_var;
extern struct dev_var *dv_var;

extern char siml_ut_space_names[];
extern char *siml_rg_err_msg[];

/*
 * Function Prototypes
 */

/* RGUTIL */
struct TREE *siml_rg_tree_new (int);
void siml_rg_tree_delete (struct TREE *, REMOVE_mode);
void siml_rg_tree_visit (struct TREE *, void (*action) (KEY),
			 VISIT_order, VISIT_poles);
void siml_rg_tree_insert (struct TREE *, KEY, DUP_mode);
KEY siml_rg_tree_remove (struct TREE *, KEY, REMOVE_mode del, DUP_mode);
KEY siml_rg_tree_lookup (struct TREE *, KEY, COMPARE_answ);
struct TREE *siml_rg_tree_shuffle (struct TREE *, int, REMOVE_mode);
long siml_rg_tree_get_size (struct TREE *);
KEY siml_rg_tree_seg (struct TREE *, KEY, KEY);

COMPARE_answ siml_rg_cmp_data_by_addr (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_inst_by_addr (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_inst_by_src (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_inst_by_txt (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_symb_by_name (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_symb_by_addr (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_ptr_by_pos (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_sub_by_id (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_sub_by_self (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_sub_by_total (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_sub_by_name (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_kin_by_sub (const KEY, const KEY);
COMPARE_answ siml_rg_cmp_kin_by_name (const KEY, const KEY);

struct INSTRUCTION_NODE *siml_rg_create_inst_node 
(DSP_ADDR, ADDRESS_SPACE, DSP_ADDR, struct INST_STATUS *);
struct INSTRUCTION_NODE *
 siml_rg_get_inst (DSP_ADDR, struct INSTRUCTION_NODE *, GET_inst_mode);
struct DATA_NODE *siml_rg_create_data_node (ADDRESS_SPACE, DSP_ADDR);
struct DATA_NODE *siml_rg_get_data (ADDRESS_SPACE, DSP_ADDR);
struct SYMBOL *siml_rg_create_symbol_node (char *, SYMBOL_TYPE);
struct SYMBOL *siml_rg_get_symbol (char *, SYMBOL_TYPE);
struct SYMBOL *siml_rg_get_label (DSP_ADDR);
struct ROUTINE_INFO *
 siml_rg_create_routine_node (struct INSTRUCTION_NODE *, char *, SYMBOL_TYPE);
struct CALL_INFO *
 siml_rg_create_kin_node (struct TREE *, struct ROUTINE_INFO *);
struct CALL_INFO *siml_rg_get_kin (struct TREE *, struct ROUTINE_INFO *);
struct CALL_INFO *siml_rg_remove_kin (struct TREE *, struct ROUTINE_INFO *);

void siml_rg_notify (ERR_mode, char *,...);
void siml_rg_mem_err (void);
void *siml_rg_alloc (unsigned long);
int siml_rg_strncmpi (char *, char *, unsigned);
BOOL siml_rg_next_token (char **, char *);
void siml_rg_put_symbol(char *buffer, struct SYMBOL *sym, int length_limit);
#if !BIG_ENDIAN
void siml_rg_swapw (void *, unsigned long);
#endif

FILE *siml_rg_open_file (char *, char *, char *, ERR_mode);
time_t siml_rg_get_file_date (char *);
void siml_rg_save_blk (void *, int, int, FILE *, BOOL);
void *siml_rg_load_blk (void *, int, int, FILE *, BOOL);

#ifdef SAP_DEBUG
void siml_rg_dprintf (char *fmt,...);
void siml_rg_visit_symbol_node (KEY);
void siml_rg_visit_inst_node (KEY);
void siml_rg_visit_data_node (KEY);
void siml_rg_inst_psshow (void);
#endif

/* RGPROF */
void siml_rg_cleanup ();

/* RGCOFF */
void siml_rg_build_ir (void);

/* RGPRINT */
void siml_rg_report_init (char *, char *, char *);
void siml_rg_report_finish (void);
void siml_rg_post_title (void);
void siml_rgprintf (char *,...);
void siml_rg_post_font (FONT_OP,...);
void siml_rg_new_section (char *,...);

/* RGALLOC */
void siml_rg_allocator_new (struct CALLOC *, int);
void siml_rg_allocator_free (struct CALLOC *);
void *siml_rg_alloc_new_item (struct CALLOC *, int);
char *siml_rg_strdup (struct CALLOC *, char *);
void siml_rg_save_profile (char *, int, int);
void siml_rg_load_profile (char *, int, int);

/* RGSUBR */
void siml_rg_extract_routine_info (struct INSTRUCTION_NODE *, char *);
char *siml_rg_get_routine_name (struct ROUTINE_INFO *);
void siml_rg_update_routine_stack
 (struct INSTRUCTION_NODE *, BOOL, BOOL, unsigned long);
unsigned siml_rg_routine_sum_up ();
void siml_rg_report_routines ();

/* RGGRAPH */
void siml_rg_ascii_routine_tree ();
void siml_rg_ps_routine_tree ();
void siml_rg_ps_routine_graph ();

/* SIM (architecture dependent routines) */
void siml_rg_init_addrmode_table (char *add_mode_msg[]);
void siml_rg_update_addr_modes (struct INSTRUCTION_NODE *);
void siml_rg_update_move_info (struct INSTRUCTION_NODE *);

char *siml_rg_disassemble (struct INSTRUCTION_NODE *);
int siml_rg_get_ops_num (void);
int siml_rg_get_group_num (void);
ADDR_MODE siml_rg_map_mode (ADDR_MODE);
OPERATION siml_rg_map_op (struct INSTRUCTION_NODE *);
char *siml_rg_map_op_name (OPERATION);

BOOL siml_rg_is_callable (struct INSTRUCTION_NODE *);
BOOL siml_rg_is_jsr (struct INSTRUCTION_NODE *);
BOOL siml_rg_is_return (struct INSTRUCTION_NODE *);
BOOL siml_rg_is_cond (struct INSTRUCTION_NODE *);

RC siml_ut_is_move_l (struct INSTRUCTION_NODE *, REGISTER_NAME *, int *);

#endif /* FULLSIM */

#endif /* __protocom_h__*/

