#include "simcom.h"
#include "simusr.h"
#include "simdev.h"

#if ADSx
#define DSP_MAXDEVICES 32	/* Maximum number of DSP devices */
#else
#define DSP_MAXDEVICES 32	/* Maximum number of DSP devices */
#endif
#define DSP_CMDSZ    10		/* Stack size for previous commands */
#define DSP_HISTSZ   32		/* Execution history buffer size */
#define DSP_WINSZ     100	/* Number of display lines in window buffer */

#if FULLSIM
extern
struct st_command
 sx_assemble,
 sx_break,
#if ADSx
 sx_cchange,
 sx_cdisplay,
 sx_cforce,
 sx_cgo,
 sx_cload,
 sx_csave,
 sx_cstep,
 sx_ctrace,
#endif    
 sx_change,
 sx_copy,
 sx_device,
 sx_disassemble,
 sx_display,
 sx_down,
 sx_evaluate,
 sx_finish,
#if ADSx
 sx_force,
#endif 
 sx_frame,
 sx_go,
 sx_help,
#if ADSx
 sx_host,
#endif /* ADSx */    
#if !ADSx    
 sx_history,
#endif    
 sx_input,
 sx_list,
 sx_load,
#if ADSx
 sx_program,
 sx_erase,
#endif    
 sx_log,
 sx_more,
 sx_next,
 sx_output,
 sx_path,
 sx_quit,
 sx_radix,
 sx_redirect,
#if !ADSx    
 sx_reset,
#endif    
 sx_save,
 sx_step,
 sx_streams,
 sx_system,
 sx_trace,
 sx_type,
 sx_until,
 sx_up,
 sx_unlock,
 sx_view,
 sx_wait,
 sx_watch,
 sx_where
#if GUI
,
 sx_wasm,
 sx_wbreak,
 sx_wcalls,
 sx_wcommand,
 sx_winput,
 sx_wlist,
 sx_wmemory,
 sx_woutput,
 sx_wreg,
 sx_wsession,
 sx_wsource,
 sx_wstack,
 sx_wwatch
#endif
;

static
struct st_command *sim_commands[] =
{
    &sx_assemble,
    &sx_break,
#if ADSx
    &sx_cchange,
    &sx_cdisplay,
    &sx_cforce,
    &sx_cgo,
    &sx_cload,
    &sx_csave,
    &sx_cstep,
    &sx_ctrace,
#endif    
    &sx_change,
    &sx_copy,
    &sx_device,
    &sx_disassemble,
    &sx_display,
    &sx_down,
    &sx_evaluate,
    &sx_finish,
#if ADSx
    &sx_force,
#endif 
    &sx_frame,
    &sx_go,
    &sx_help,
#if ADSx
    &sx_host,
#endif /* ADSx */    
#if !ADSx    
    &sx_history,
#endif    
    &sx_input,
    &sx_list,
    &sx_load,
#if ADSx
    &sx_program,
    &sx_erase,
#endif
    &sx_log,
    &sx_more,
    &sx_next,
    &sx_output,
    &sx_path,
    &sx_quit,
    &sx_radix,
    &sx_redirect,
#if !ADSx    
    &sx_reset,
#endif    
    &sx_save,
    &sx_step,
    &sx_streams,
    &sx_system,
    &sx_trace,
    &sx_type,
    &sx_until,
    &sx_up,
    &sx_unlock,
    &sx_view,
    &sx_wait,
    &sx_watch,
    &sx_where
#if GUI
	,
    &sx_wasm,
    &sx_wbreak,
    &sx_wcalls,
    &sx_wcommand,
    &sx_winput,
    &sx_wlist,
    &sx_wmemory,
    &sx_woutput,
    &sx_wreg,
    &sx_wsession,
    &sx_wsource,
    &sx_wstack,
    &sx_wwatch
#endif
};

static
char *command_help[] =
{
#if GUI
#if ADSx
    "{a}sm      {b}reak     {cc}hange      {cd}isplay     {cf}orce     {cg}o     <{space}>=more",
    "{c}hange     {cl}oad      {cs}ave     {cst}ep     {ct}race     {co}py     {de}vice",
    "{di}sassemble    {d}isplay    {do}wn     {e}valuate    {fi}nish    {f}orce    {fr}ame",
    "{g}o       {h}elp       {ho}st       {i}nput       {li}st       {l}oad       {lo}g",
    "{m}ore      {n}ext      {o}utput      {p}ath      {pr}ogram      {q}uit      {r}adix",
    "{red}irect      {s}ave      {st}ep      {str}eams      {t}race      {ty}pe      {un}lock",
    "{u}ntil      {up}      {v}iew      {w}ait      {wa}sm      {wat}ch      {wb}reakpoint",
    "{wc}alls      {wco}mmand    {wh}ere    {wi}nput    {wl}ist    {wm}emory    {wo}utput",
    "{wr}egister      {wse}ssion     {ws}ource     {wst}ack     {ww}atch",
#else
    "{a}sm     {b}reak     {c}hange     {co}py     {de}vice     {di}sassemble     <{space}>=more",
    "{d}isplay      {do}wn      {e}valuate      {f}inish      {fr}ame      {g}o      {h}elp",
    "{hi}story       {i}nput       {li}st       {l}oad       {lo}g       {m}ore       {n}ext",
    "{o}utput      {p}ath      {q}uit      {r}adix      {red}irect      {re}set      {s}ave",
    "{st}ep      {str}eams      {t}race      {ty}pe      {un}lock      {u}ntil      {up}",
    "{v}iew     {w}ait     {wa}sm     {wat}ch     {wb}reakpoint     {wc}alls     {wco}mmand",
    "{wh}ere     {wi}nput     {wl}ist     {wm}emory     {wo}utput     {wr}egister     {wse}ssion",
    "{ws}ource     {wst}ack     {ww}atch",
#endif /* ADSx */
#else
#if ADSx
    "{a}sm     {b}reak     {cc}hange     {cd}isplay     {cf}orce     {cg}o     <{space}>=more",
    "{c}hange      {cl}oad      {cs}ave      {cst}ep      {ct}race      {co}py      {de}vice",
    "{di}sassemble     {d}isplay     {do}wn     {e}valuate     {fi}nish     {f}orce     {fr}ame",
    "{g}o       {h}elp       {ho}st       {i}nput       {li}st       {l}oad       {lo}g",
    "{m}ore      {n}ext      {o}utput      {p}ath      {pr}ogram      {q}uit      {r}adix",
    "{red}irect      {s}ave      {st}ep      {str}eams      {sy}stem      {t}race      {ty}pe",
    "{un}lock      {u}ntil      {up}      {v}iew      {w}ait      {wat}ch      {wh}ere",
#else
    "{a}sm    {b}reak    {c}hange    {co}py    {de}vice    {di}sassemble    <{space}>=more",
    "{d}isplay     {do}wn     {e}valuate     {f}inish     {fr}ame     {g}o     {h}elp",
    "{hi}story      {i}nput      {li}st      {l}oad      {lo}g      {m}ore      {n}ext",
    "{o}utput     {p}ath     {q}uit     {r}adix     {red}irect     {re}set     {s}ave",
    "{st}ep     {str}eams     {sy}stem     {t}race     {ty}pe     {un}lock     {u}ntil",
    "{up}      {v}iew      {w}ait     {wat}ch     {wh}ere",
#endif /* ADSx */
#endif /* GUI */    
    NULL
};


extern
struct st_var
#if !ADSx
  sx_56800,
#endif /* !ADSx */
  sx_56811,
  sx_56812,
  sx_56824
;

static
struct st_var *sx_all[] =
{
#if !ADSx    
    &sx_56800,
#endif /* !ADSx */    
    &sx_56811,
    &sx_56812,
    &sx_56824
};

static
struct sev_line prevcmds[DSP_CMDSZ];

static
struct sev_var *sim_const_sv[DSP_MAXDEVICES];	/* pointers to data structures for each device */

public
struct sev_const sv_const =
{
    &sim_const_sv[0],
    DSP_CMDSZ,			/* Stack size for previous commands */
    DSP_HISTSZ,			/* Execution history buffer size */
    DSP_WINSZ,			/* Number of display lines in window buffer */
    24,				/* default display size (numlines) */
    80,				/* default display size (numcols) */
    21,				/* default position of command line */
    sx_all,
    sizeof (sim_commands) / sizeof (struct st_command *),
    sim_commands,
    command_help,
    &prevcmds[0]		/* previous command list (for repeat of command) */
};


public
struct sev_var *sv_var;		/* global sim_variable array structure pointer */

public
struct st_var *sx_var;

#endif /* FULLSIM */

extern
struct dt_var
#if !ADSx
  dx_56800,
#endif /* !ADSx */  
  dx_56811,
  dx_56812,
  dx_56824;


static
struct dt_var *dx_all[] =
{
#if !ADSx    
    &dx_56800,
#endif /* !ADSx */    
    &dx_56811,
    &dx_56812,
    &dx_56824
};

static
struct dev_var *dev_const_sv[DSP_MAXDEVICES];	/* pointers to data structures for each device */

public
struct dev_const dv_const =
{
    /* char *revnum */
#if ADSx    
    "MOTOROLA DSP56800 ADS:  VERSION 6.2.2 03-30-1998",
#else    
    "MOTOROLA DSP56800 SIMULATOR:  VERSION 6.2.1 01-22-1998",
#endif
    sizeof (dx_all) / sizeof (struct dt_var *),
    dx_all,
    DSP_MAXDEVICES,
    &dev_const_sv[0],
    0,
    {				/* bitset */
	1l, 2l, 4l, 8l, 0x10l, 0x20l, 0x40l, 0x80l, 0x100l, 0x200l,
	0x400l, 0x800l,
 0x1000l, 0x2000l, 0x4000l, 0x8000l, 0x10000l, 0x20000l, 0x40000l, 0x80000l,
	0x100000l, 0x200000l, 0x400000l, 0x800000l,
	0x1000000l, 0x2000000l, 0x4000000l, 0x8000000l,
	0x10000000l, 0x20000000l, 0x40000000l, 0x80000000l
    }
};

public
struct dev_var *dv_var;

public
struct dt_var *dx_var;
