#ifndef _hostio_h_
#define _hostio_h_

/* we want to redefine these names for use in the simulator */
#if FULLSIM
#define alloc_host_io_buffer    siml_alloc_host_io_buffer
#define realloc_host_io_buffer  siml_realloc_host_io_buffer
#define free_host_io_buffer     siml_free_host_io_buffer
#define process_pending_host_io siml_process_pending_host_io
#endif

#if defined ( DSP96000 )
#define BYTES_PER_DSP_CHAR 4
#else
#if defined ( DSP56000 ) || defined( DSP56300 )
#define BYTES_PER_DSP_CHAR 3
#else
#if defined ( DSP56100 ) || defined( DSP56600 )
#define BYTES_PER_DSP_CHAR 2
#endif
#endif
#endif

#if ! defined ( FOPEN_MAX )
#define FOPEN_MAX 128
#endif

#define ELEMENT_TYPE unsigned long
typedef struct 
{
    int valid_p;
    unsigned long length, size;
    ELEMENT_TYPE *buffer;
}
hio_buffer;

enum states
{ 
    START,
    OPEN_PATH,
    READ_FINISH,
    WRITE_WAIT,
    UNLINK_WAIT,
    RENAME_WAIT_1,
    RENAME_WAIT_2,
    ACCESS_WAIT
};

union call_info
{
    struct { int flags; } open;
    struct { int retval, errno_value; } read;
    struct { int desc, count; } write;
    struct { char *old_name; } rename;
    struct { int mode; } access;
};

#ifdef __STDC__
extern void process_pending_host_io ( hio_buffer *, hio_buffer *,
                                      int *, enum states *, union
                                      call_info * );
extern void alloc_host_io_buffer ( hio_buffer *, unsigned long );
extern void free_host_io_buffer ( hio_buffer * );
extern void realloc_host_io_buffer ( hio_buffer *, unsigned long );
extern void siml_clear_host_io_buffer ( hio_buffer * );
#else
extern void process_pending_host_io ( );
extern void alloc_host_io_buffer ( );
extern void free_host_io_buffer ( );
extern void realloc_host_io_buffer ( );
extern void siml_clear_host_io_buffer ( );
#endif

#if ! defined ( TRUE )
#define TRUE 1
#endif

#if ! defined ( FALSE )
#define FALSE 0
#endif

#define CHECK_BUFFER_SIZE( HP, SIZE ) \
{ if (( SIZE ) > ( HP )->size ) realloc_host_io_buffer (( HP ), ( SIZE )); }

#endif
