#ifndef _cc_h_
#define _cc_h_

/* Definitions for command converter commands */
#define BPSET     0x0d  /* break write */
#define TRACIMED  0x0e  /* trace immediate */
#define TRACDLY   0x0f  /* trace delayed */
#define EXECIMED  0x10  /* go immediate */
#define EXECDLY   0x11  /* go multiple  */
#define PREAD     0x12  /* pmem read */
#define PWRITE    0x13  /* pmem write */
#define XREAD     0x14  /* xmem read */
#define XWRITE    0x15  /* xmem write */
#define YREAD     0x16  /* ymem read */
#define YWRITE    0x17  /* ymem write */
#define RREAD     0x18  /* reg read */
#define RWRITE    0x19  /* reg write */
#define PWRITES   0x1a  /* pmem multiple writes */
#define XWRITES   0x1b  /* xmem multiple writes */
#define YWRITES   0x1c  /* ymem multiple writes */

/* Definitions for command converter once commands */
#define OREG_RD      0x1d /* read OnCE registers */
#define OREG_WR      0x1e /* write OnCE registers */
#define SEQTRACE     0x1f /* trace OnCE sequence */
#define SEQEXEC      0x20 /* execute OnCE sequence */
#define PIPE_RD      0x21 /* read pipeline regs. */
#define SEQREAD      0x22 /* read OnCE sequence */
#define SEQWRITE     0x23 /* write OnCE sequence */
#define MISC_RD      0x24 /* misc. reg. read */
#define MISC_WR      0x25 /* misc. reg. write */
#define OFORCER      0x26 /* force reset on converter/DSP56 */
#define OFORCEB      0x27 /* force break on converter/DSP56 */
#define EXEC_OVERLAY 0x28 /* Execute overlay in p memory */

/* Reset jtag state machine. 0=Clocks, 1=Reset pin */
#define JTAG_RESET_STATE_MACHINE   0x29
 /* Force break on jtag device 0=Jtag command, 1=pin*/
#define JTAG_BREAK   0x2a
 /* Force reset on jtag device 0=user, 1=debug */
#define JTAG_RESET   0x2b
#define EXEC_FROM_ADDR 0x2c
/* Special command to read 56300 FIFO contents (no arguments in this command) */
#define READ_FIFO    0x2d
#define GET_STATUS 0x2e
#define JTAG_COUNT 0x2f
#define SET_ACTIVE_DEVICE 0x30
#define RESET_SINGLE_JTAG_DEVICE 0x31
#define RESUME_POLLING 0x32
#define DISABLE_POLLING 0x33
#define SET_JTAG_IR_LENGTH 0x34
#define GET_REQUESTING_DEVICE 0x35

#define INT_FIX_56811 0x36 /* For the 56811 only.  This is to work around a
                              bug that allows interrupts during debug mode */

#define EXEC_56811 0x37 /* For the 56811 only.  This is to work around a
                           bug that allows interrupts during debug mode */

#define ERASE_XFLASH     0x38 /* for 56812 only. used for erasing the x-flash */

#define ERASE_PFLASH     0x39 /* for 56812 only. used for erasing the p-flash */

#define PROGRAM_XFLASH   0x3a /* for 56812 only. programs a word of x-flash */

#define PROGRAM_PFLASH   0x3b /* for 56812 only. programs two words of p-flash */

#define MODIFY_COM_SPEED 0x3c /* changes the Command-Converter clock speed */

#define XIREAD 			 0x3d /* for 56812 only. reads from the internal x-flash memory */

#define READ_MODIFY_SR   0x3d /* for 56300 only. Reads status register and clears sc and sa bits, returns original value */

#define CC_MIN_ADDR 0l
#define CC_MAX_ADDR 0x7fffl
#define CC_MEM_SIZE (CC_MAX_ADDR - CC_MIN_ADDR + 1)

#define DEVICE_ADDRESS 0x7
#define DEVICE_ACTIVE 0xc
#define DEVICE_COUNT 0xb
#define DEVICE_FLAGS 0x1
#define CLK_RATE 0x9


/* Flags */
#define DSP_CC_FLAG   0l
#define DSP_CC_STATUS 1l
#define DSP_CC_YPTR   2l
#define DSP_CC_XPTR   4l

/* Memory location for revision */
#define DSP_CC_REV    8l
/* Memory location for clock scaling factor */
#define DSP_CC_FREQ   9l

/* Memory spaces */
#define DSP_CC_YMEM 0
#define DSP_CC_XMEM 1
#define DSP_CC_PMEM 2

#endif /* _cc_h_ */
