; $Id: adm.asm,v 1.50 1996/09/09 21:59:29 cgregg Exp $
;	SECTION		monitor
	include		"adm.h"
	include		"mutil.h"
;	include		"mutil.ref"
;*******************************************************************
	org	p:0
START	jmp		>START1		;reset vector
	
	bset		#STACKERR,FLAGS ;set stack error flag
	jmp		<MONITOR1	;restart from reset vector

	nop				;trace vector
	nop

	nop				;swi vector
	nop

	jsr	>HOSTBRK		;IRQA - Host computer service request

	nop				;IRQB - always ignored for JTAG
	nop				;       tied to DE pin, not used

	bsc	18,0			;init to nops

;**********************************************************************
	org	p:$1e
;**********************************************************************
;	The host computer service is now non-maskable to insure
;	reliable operation.
;**********************************************************************

	jsr	>HOSTBRK		;NMI-New Host computer service request
	bsc	30,0			;init to nops

;**********************************************************************
	org	p:$3e

	bset		#ILLEGERR,FLAGS ;set illegal opcode  error flag
	nop
;*********************************************************************
	include		"mutil.asm"
START1	move		#$7fff55,x1	;preset DEVICE ADDRESS
MONITOR1 move		#0,sp		;reset stack pointer
	move		#>REV,a1	;
	move		a1,MARKER	;save current rev num.
;***********************************************************************
;	Initialize local variables and peripheral ports.
;***********************************************************************
	move	x1,DEVICE		;preset for no device
	move	#>BCRDEFAULT,a1		;preset BCR for 
	move	a1,BCRVAL		;1 y mem and 1 p mem wait state

	move	#0,a
	move	a,USRLIST		;clear usrlist
	move	a,FLAG2			;clear flags2  - dave -
	move	#>1,a
	move	a,DEVACTIVE		;set DEVACTIVE to 1st device
	move	a,DEVCNT		;set DEVCNT to 1

	move	#JIRTABLEp,r0
;	move	r0,x:JIRTABLE		;init JTAG IR Length Table 
	move	r0,p:JIRTABLE		;init JTAG IR Length Table 
;	move	x:(r0)+,a1		;to all 4 (default for (M) DSP)
	move	p:(r0)+,a1		;to all 4 (default for (M) DSP)
	move	#$4,a1
	rep	#24
;	move	a1,x:(r0)+
	move	a1,p:(r0)+

	move	FLAGS,a1
	move	#>$1,x0			;clear status flags
	move	x0,CLKRATE		;preset manual clock rate
	and	x0,a1			;except DEBUGMODE
	move	a1,FLAGS

	move	#$2,omr			;set for normal expanded mode
	move	#$80,r2			;initialize xptr&yptr
	move	r2,XPTR
	move	r2,YPTR

	move	#>CRBVAL,a		;gated clk,no rx/tx irqs.
	move	a1,SSIMOD
	move	#>CRAVAL,a		;divide by 8 prescale (/32 total)
	move	a1,SSICLK
	move	#PLLIN,a
	move	a,PLLVAR 
	movep	#$a4,PCD		;deassert portc signals
	movep	#BOUT,PBD		;preset portb signals
	movep	#BDDRIN,PBDDR		;setup port b i/o
;***********************************************************************
;	Need to load Command Overlay Offset tables in X memory
;***********************************************************************
LGETCMD move	#JMPTABL,r2		;need to load offset table in x mem.
	move	#OVLYTABL,r0
	move	p:JTABLSZ,r1		;get table count
	do	r1,LGETCMD1		;get values from EPROM
	move	p:(r0)+,a		;get table ptr
	move	a1,p:(r2)+		;and put in xmem.

LGETCMD1 move	#>$aa,r0		;preset status
	move	r0,STATVAL		;as good command executed
	move	BCRVAL,a1		;get bcr value to use
	move	a1,BCR			;set for zero wait states

MLOOP	jsr	<GETCMD			;go do command
	cmp	x1,a	#0,n0		;chek if command not for target
	move	n0,sp
;***********************************************************************
;	Following code assumes that clock on universal command converter
;	is 20mhz and the pll will be used to accelerate code execution.
;	The pll will be programmed for 80mhz with 1 wait state external
;	accesses.
;***********************************************************************
DOCMD	move	PLLVAR,a1		;get pll value
	movep	a1,PCTL			;preset pll for 80mhz
	rep	#100
	nop

	jsr	(r0)			;get load count
	jsr	<HND_SHK		;end-of-command handshake

	jmp	<LGETCMD1		;go get next command

;*********************************************************************
;	This is the monitor getcmd entry point for executing commands
;	This routine is overlaid after execution of each command
;	so that a larger area is left for fixted routines.  Also,
;	initialization code used only once after reset is put in
;	this area.  It will be automatically overlaid on reset.
;******************************************************************
GETCMD	jsset	#POLLENABLE,FLAG2,POLLUSR	;poll devices if enabled
	move	SSIMOD,a1		;get ssi mode settings
	move	a1,CRB
	clr	a #0,b
	movep	a,PCC			;turn SSI off
	movep	#BOUT,PBD		;preset portb signals
	movep	#BDDRIN,PBDDR		;setup port b i/o
	movep	#CIO,PCDDR		;setup port c i/o
	jset	#SELECT,INPUTS,GETCMD	;wait to be selected
	jclr	#H_REQ,INPUTS,GETCMD	;and also to be requested
GOTCMD	jsr	<GETBYTE		;get command from host
	move	y0,a			;move it to accum a
	tst	a
	move	#>$10,x0		;offset subtract to command
	move	p:LASTCOMMAND,y1	;check if command > max.
	cmp	y1,a #>$21,x1		;check if command > OnCE commands
	.IF	<GT>			;if command # to high
	jmp	<GETCMD			;  try to start over
	.ENDI				;endif
	cmp	x0,a			;lower range
	.IF	<LT>			;if command # to low
	jmp	<GETCMD			;  try to start over
	.ENDI				;endif
	sub	x0,a	#JMPTABL,r1	;get offset for sequence
	move	a1,n1			;put offset into offset reg.
	nop
	move	p:(r1+n1),r0		;get command start address
	move	y0,a1
	rts


;*******************************************************************
;	HND_SHK
;	Handshake used when coming out of reset and at the
;	end of each command.  For now, the handshake sends
;	the no error code of $aa every time.  Future versions
;	of the monitor will send information about the success
;	of the execution of the command through this handshake.
;*******************************************************************
HND_SHK move	STATVAL,a1		;no error code = $aa
						;must be in lower byte
						;of a1 for PUTDATA
	jsr	<PUTDATA		;go put data to port
	clr	a			;clear a after PUTDATA
	bset	#ADM_INT,PBD		;set ADM_INT bit
CHK_AK	jclr	#INT_ACK,INPUTS,CHK_AK	;wait for INT_ACK
	jset	#SELECT,PCD,CHK_AK	;wait to be selected
	bclr	#ADM_INT,PBD		;clear ADM_INT bit
CHK_AK2 jset	#INT_ACK,INPUTS,CHK_AK2 ;wait for INT_ACK low
	jsr	<MKIN			;set port back to input
	rts
;*****************************************************************
;	REDUNDANT2
;	This is a subroutine used by WRITBLK and WRITEDATA
;*****************************************************************
REDUNDNT2 move	x:OFFSET,r7	;y mem address to write to
	jsr	<INITSEQ	;load seq. get addr, count
	move	x:WVOFFSET,r7
	jsr	<REDUNDNT3
;******************************************************************
;	REDUNDANT
;	This is a subroutine used by READDATA,WRITEBLK and WRITEDATA.
;******************************************************************
REDUNDANT jsr	<RUNSEQ		;run the sequence
REDUN1	move	LOOPCOUNT,b	;get count value
	move	#>1,x0		;decrement by 1
	sub	x0,b
	move	b1,x0		;save count
	rts
;*****************************************************************
;	REDUNDANT3
;	More redundant code put in a subroutine to save a few words
;*****************************************************************
REDUNDNT3 jsr	<GETLWORD		;get value to write
REDUNDN3 move	#$ffff,m7
	jset	#2,DEVICE,REDUN3	;check if 56lp16 or hawk
REDUN4	jset	#JTAGDEV,FLAGS,REDUN5	;if jtag device need to put
						; data in backwards
REDUN3	move	x0,y:(r7)
	rts
REDUN5	move	x0,y:(r7)+	    ;put lsbs in first	
	move	x1,y:(r7)	    ;followed by msbyte
	rts
;******************************************************************
;	INITSEQ
;	This routine loads the sequence pointed at by the
;	r0 register from the EPROM.  The start address
;	for reads is also placed in the Y memory
;	and the word transfer count is also placed in LOOPCOUNT.
;******************************************************************
INITSEQ jsr	<LOADSEQ	;load sequence
	jsr	<GETARG		;get start address
	jsr	<REDUNDN3
	jsr	<GETARG		;get word count
	move	a1,LOOPCOUNT	;save lower count value
	rts
;******************************************************************
;	GETARG
;	This routine determines how many bytes to get based on
;	the architecture.  The 16 and 24 bit devices should get 16 bit
;	arguments while the 32 bit devices get 32 bit arguments.
;	Note: 0=96k, 1=56k2, 2=56100, 3=56301, 4=56lp16, 5=56800
;******************************************************************
GETARG	btst	#1,DEVICE		;check if Onyx
	jcs	<CHK24BIT		;check if 56100 or Onyx
	jset	#2,DEVICE,GET16		;must be lp16 or hawk
	jset	#0,DEVICE,GET16		;must be 56k2
	jmp	<GETLWORD		;must be 96k
CHK24BIT jset	#0,DEVICE,GETLWORD	;must be Onyx
	jmp	<GET16			;must be 56100
;*******************************************************************
;	LOADSEQ
;	This routine loads the OnCE command sequence from the
;	external EPROM to the Y memory space.
;	R0 must point to the EPROM address where the sequence is
;	to be loaded from.
;*******************************************************************
LOADSEQ move	#0,r2		;clear y pointer
	move	#>1,b		;set for eos
LOADSEQ1 move	p:(r0)+,a	;get a value from EPROM
	cmp	b,a a1,y:(r2)+	;test for eos
	jne	<LOADSEQ1	;go get next word if not eos
	rts
;*******************************************************************
;	HOSTBRK - IRQA Service Routine
;	This is an interrupt driven routine used to service
;	host computer breaks.
;*******************************************************************
HOSTBRK jclr	#JTAGFLAG,FLAGS,HSTBRK0 ;make sure you mask trst on pal
HSTBRK0 bset	#ADM_INT,PBD		;assert ADM_INT
HSTBRK1 jclr	#INT_ACK,INPUTS,HSTBRK1	;wait for INT_ACK=1
	jset	#SELECT,PCD,HSTBRK1	;wait to be selected
	bclr	#ADM_INT,PBD		;deassert ADM_INT
HSTBRK2 jset	#INT_ACK,INPUTS,HSTBRK2	;wait for INT_ACK=0
	move	#0,sp			;reset sp
	jclr	#CLEANUP,FLAGS,BRKDONE	;return if no clean up required
	jsr	<REGBACK		;restore regs used thru OnCE
BRKDONE jmp	<LGETCMD1
;****************************************************************************
;	OnCEBRK
;	This routine services pending OnCE interface requests
;	for service.  The host computer must be informed of these
;	requests.
;	The command converter program will only request service from
;	the host when the OnCE port is requesting service.
;	The host computer will acknowledge the request and will later
;	poll the OnCE registers to determine what type of request needs
;	to be serviced.
;****************************************************************************
OnCEBRK bset	#DEBUGMODE,FLAGS	;set debug mode flag
	bset	#H_BRK,PCD		;set HOST_BRK bit
	jsr	<HND_SHK		;handshake with host
	bclr	#H_BRK,PCD		;clear HOST_BRK bit
	bclr	#OnCEREQ,FLAGS		;clear ack flag
	rts
;*******************************************************************
;	REGBACK
;	This routine restores the transfer registers (R0,X0,M0)
;	on the target in the event of a host interrupt.
;*******************************************************************
REGBACK1 move	x:RESTOR56,r0	;need to restore bpmrl,bpmrh
	move	#5,r7		;preset count to 5
	move	#SAVEREG,r3
	jmp	REGBACK2
REGBACK move	#SAVEREG,r3
	move	#3,r7		;restore 3 for all but 56800
	jclr	#2,DEVICE,REGBACK4
	move	#2,r7		;only need to restore 2 for 56800	
REGBACK4 move	x:RESTORE,r0	;need to restore regs. after read
REGBACK2 jsr	 <LOADSEQ	;load sequence
	move	#4,r4
	move	r4,n4
	jclr	#2,DEVICE,REGBAK7
	move	#3,r4
	move	r4,n4
REGBAK7	do	r7,SKIP3
	move	x:(r3)+,a	;get value to restore
	move	a1,y:(r4)+	;restore r1 upper

	jset	#2,DEVICE,SKIP1		;check if lp16 or hawk
	jclr	#1,DEVICE,NOSKIP	;check if 96k or 56k
	jset	#0,DEVICE,NOSKIP	;check if onyx
	jmp	<SKIP1			;must be 16 bit device

NOSKIP	move	x:(r3)+,a		;get value to restore
	move	a1,y:(r4)+		;restore r1 lower
SKIP1	move	(r4)+n4			;increment r4
	nop

SKIP3	jsr	<RUNSEQ
	bclr	#CLEANUP,FLAGS
	move	#SAVEREG,r3		;restore storage ptr
	rts
;********************************************************************
;	GETOCMD routine gets a command from y sequence ram to xmit
;	to the target.
;********************************************************************
GETOCMD clr		a #>1,b		;end of sequence = 1
	move		y:(r2),a1	;get a command from Y RAM
	cmp		b,a		;check if end of sequence
	rts
;****************************************************************************
;	GETLWORD
;	Get a 32 bit long word from host port and return with value in X
;	Upper 16 bits of word are in upper 16 bits of X1 and lower 16
;	bits of word are in upper 16 bits of X0.
;	Registers X0,X1,Y0,B0,R2 and A are used.
;****************************************************************************
GETLWORD jset		#2,DEVICE,GET16		;check if 56l6 or hawk
	jset		#0,DEVICE,CHEK32	;check if 56300
	jset		#1,DEVICE,GET16		;check if 5616 
	jmp		<GET32			;must be 96k
CHEK32	jclr		#1,DEVICE,GET24		;must be 96k
GET32	jsr		<GET16			;get upper 16 bits
GETREST move		x0,x1
	jsr		<GET16			;get lower 16 bits
	rts
GET24	move		#0,x0			;clear x0  
	jsr		<GET8			;must be 24 bit
	jmp		GETREST
;***************************************************************************
;	Get 16 bits of data and return in X0 register
;***************************************************************************
GET16	move		#>$8000,y1		;shift data left 16 bits
	jsr		<GETBYTE		;get bits 15-8
	mpy		y0,y1,a			;shift data left 16 bits
	move		a0,x0
GET8	jsr		<GETBYTE
	move		#>$80,y1
	mpy		y0,y1,a			;shift data left 8 bits
	move		a0,a1
	or		x0,a
	move		a1,x0
SHIFTR8 rep		#8			;lower 16 bits into a
	lsr		a
	rts					;return
;****************************************************************************
;	GETBYTE
;	Get a byte from PDB and put it in Y0.
;	Registers Y0,B are used.
;****************************************************************************
GETBYTE jclr		#H_REQ,INPUTS,GETBYTE	;wait for H_REQ=1
	movep		PBD,y0			;get data on PDB
	bset		#ADM_ACK,PBD		;assert ADM_ACK
	move		#$ff,b1			;remove upper bytes
	and		y0,b
	move		b1,y0
GBYTE1	jset		#H_REQ,INPUTS,GBYTE1	;wait for H_REQ=0
	bclr		#ADM_ACK,PBD		;deassert ADM_ACK
	rts					;return
;****************************************************************************
;	PUTLWORD
;	Put long word in X on host port
;	The 32 bit value resides in the upper 16 bits of X1 and X0.
;	This routine uses registers X,A,and B0
;****************************************************************************
PUTLWORD jset		 #2,DEVICE,PUT16	;check if 56lp16 or hawk
	;jset		#0,DEVICE,CHK32		;check if 56300
	;jset		 #1,DEVICE,PUT16	;check if 5616 bit device
	;jmp		<PUT32			;check if 96k
CHK32	;jclr		 #1,DEVICE,PUT24	;check if 24 bit device
	;debug
PUT32	move		x1,a
	jsr		<UPPERBYTE
	jsr		<PUTBYTE		;send bits 31-24
PUT24	move		x1,a
	jsr		<LOWERBYTE
	jsr		<PUTBYTE		;send bits 23-16
PUT16	move		x0,a
	jsr		<UPPERBYTE
	jsr		<PUTBYTE		;send bits 15-8
	move		x0,a
	jsr		<LOWERBYTE
	jsr		<PUTBYTE		;send bits 7-0
	rts
UPPERBYTE rep		#<16			;move bits 16-8 of x1 to 7-0
	asr		a
	jmp		<LOWERBYTE1
LOWERBYTE rep		#<8			;move bits 7-0 of x1 to 7-0
	asr		a
LOWERBYTE1 move		#>$ff,y0		;masking value
	and		y0,a
	rts					;of the a1 accumulator
;****************************************************************************
;	PUTBYTE
;	Put low order byte in A1 to host port
;	This routine uses Y0,Y1 and B registers
;****************************************************************************
PUTBYTE jsr		<PUTDATA		;go put data to port
	bset		#ADM_REQ,PBD		;assert ADM_REQ
PB1	jclr		#H_ACK,INPUTS,PB1	;wait for H_ACK to assert
	bclr		#ADM_REQ,PBD		;deassert ADM_REQ
PB2	jset		#H_ACK,INPUTS,PB2	;wait for H_ACK to deassert
MKIN	movep		#>BDDRIN,PBDDR		;make pb0-7 inputs
	bclr		#DIR,PBD		;set data direction as input
	rts
;*******************************************************************
;	PUTDATA
;	This routine insures that the data direction of the
;	lower 8 bits of port b are outputs so that the value
;	read will be correct.  The user must insure to make
;	data direction inputs after using this subroutine.
;	The lower 8 bit value in A1 register is what gets transmitted.
;*******************************************************************
PUTDATA move		#>$ff00,y0
	bset		#DIR,PBD	;set data direction as out
	movep		PBD,b		;get current PBD value
	and		y0,b		;save only control bits
	move		b1,y0
	or		y0,a
	movep		a1,PBD		;store new value with control bits
	movep		#>BDDROUT,PBDDR	;make port b0-7 outputs
	rts

;*******************************************************************
;	The routine sets up the TMS signal for Scan-DR path
;	and will also send out the proper number of bypasses for the
;	number of devices in the system.
;	Assumptions:
;	All presets for device setups for JTAG bypass mode are already issued.
;	TMS starts from IDLE state.
;	If more than one device is to be addressed,
;	the sequence in Y memory will contain the commands/data for each
;	device, ie, only 1 y mem. ptr and only 1 x mem. ptr.
;	DEVCNT contains the number of devices in the system,
;	DEVACTIVE contains the active device in the system.
;***************************************************************************
RUNSEQ	move		#0,r2			;preset y memory pointer
RUNSEQ1	bset		#CMDFLAG,FLAGS		;set command flag
	move		y:(r2)+,a		;get command
	move		a,TEMPAREA		;save for later use
	jclr		#0,TEMPAREA,JTAGCOM1	;check if end of sequence
	ori		#$2,mr			;enable interrupts
	andi		#$f2,mr
	rts

JTAGCOM1 clr		a		;need to clear jtag data register
	move		a,JTAGDATA
	move		DEVACTIVE,b1	;get active device list
	move		b1,DEVTMP	;save in temp space
	jsr	SENDDATA

	nop
JTAGCOM2 nop
JTAGCOM3 jclr	#POLLSTATUS,FLAGS,RUNSEQ2	;go poll for status if needed
	jsr	JREADSB
JTAGCOM9 jset	#STATUSBUSY,FLAGS,JTAGCOM3	;return if status error
RUNSEQ2	jmp	<RUNSEQ1			;go get next command
;*********************************************************************
;	This routine sends the 8 bit command to the target
;*********************************************************************
SENDDATA jclr       #CMDFLAG,FLAGS,SENDDATA2	;check if time to send
						;  command or data
	jsr	<SENDCMD			;send command

;*********************************************************************
;	This routine sends/receives the data to/from the target
;	It returns via the rts in the function it calls
;*********************************************************************
SENDDATA2 clr	a #>$ff,y1		;need to clear jtag data register
	move	a,JTAGDATA
	jset	#2,TEMPAREA,SENDIT	;cmd=4, write data and wait for ack
	jset	#1,TEMPAREA,GETIT	;cmd=2, read data and wait for ack
	jsset	#4,TEMPAREA,SENDITX	;cmd=10, write data, dont wait for ack
	bclr	#POLLSTATUS,FLAGS	;cmd=8, don't do anything
	rts

;*******************************************************************
;	XFERDATA routine toggles data in/out, then increments state
;	machine to exit1 so that last bit of data is retrieved/sent.
;
;	This is necessary since the jtag state machine will contine
;	transferring data until the state machine decoder is not decoding
;	a shift-data or shift-ir command.
;
;	This routine assumes the data is in the A accumulator for sending
;	and that data received is in the B accumulator.
;
;******************************************************************
XFERDAT move		a1,a2			;set up clock count
;*****************************************************************
;	SHIFT DATA RIGHT 8 BITS AND SEND/RECEIVE IT
;	IN LINE CODE TO REDUCE NUMBER OF SUBROUTINE CALLS.
;	THIS USED TO BE SHIFTTOG
;*****************************************************************
XFERDAT1 rep		#8			;need to shift data in A
	lsr		a
	move		CLKRATE,n5		;preset clock rate
	do		a2,XFERDAT2
	jsr		<SHIFTDATA		;go preset data to port pin
	jsr		<CLKTOGGLE		;go toggle clock
	move		JTAGDATA,b		;get current value
	btst		#DATAFLG,FLAGS		;chek if next bit is 0 or 1
	ror		b			;get bit
	move		b1,JTAGDATA		;save value
XFERDAT2 nop
;**********************END OF IN-LINE SHIFTTOG********************
	jsr		<SHIFTDATA		;shift last bit onto port

	move		#SHIFT_EXIT,b1		;preset for shift to exit
	jsr		<TMSTOGGLE		;toggle tms pin and
	jsr		<DATATOGL6		;shift last bit into buffer

	rts					;return

;*****************************************************************
;	SHIFT DATA RIGHT 8 BITS AND SEND/RECEIVE IT
;*****************************************************************
SHIFTTOG rep		#8			;need to shift data in A
	lsr		a
	move		CLKRATE,n5		;preset clock rate
	do		a2,DATATOG4
	jsr		<SHIFTDATA		;go preset data to port pin
	jsr		<CLKTOGGLE		;go toggle clock
	move		JTAGDATA,b		;get current value
	btst		#DATAFLG,FLAGS		;chek if next bit is 0 or 1
	ror		b			;get bit
	move		b1,JTAGDATA		;save value
DATATOG4 nop
	rts
;***************************************************************************
;	CHKACTIVE routine checks if the current device being addressed
;	is in bypass mode or in enable_once mode.
;***************************************************************************
;CHKACTIVE move		 DEVTMP,b1		;or if active
;	 lsr		 b			;
;	 move		 b1,DEVTMP		;save last device tested
;	rts
;***************************************************************************
;	BYPASS1 routine sends a bypass dummy data bit
;	Assumes that PC8 is general purpose output pin.
;***************************************************************************
BYPASS1 bclr		#DSI,PCD		;send bypass=0
	jsr		<CLKTOGGLE		;send clock
	rts 
;***************************************************************************
;	SDR routine shifts the target tms signal to the shift DR state
;***************************************************************************
SDR	move		#IDLE_SDR,b1		;prepare to shift dr
	jsr		<TMSTOGGLE		;go toggle tms
	rts
;***************************************************************************
;	DATATOGLE routine sends the proper bit values through the TDO
;	pin for an n bit data stream.  It will be used for boundary scan
;	registers and loading instructions of various lengths.
;	Data to be sent is in A accum. and data received is in B accum.
;	R4 contains the number of bits to xmit.
;***************************************************************************
DATATOGLE move		JTAGDATA,a1		;get data to send
DATATOGLE1 move		CLKRATE,n5		;preset clock rate
	do		a2,DATATOGL4
	lsr		a			;check if data is 1 or 0
	jcs		<DATATGL2		;if carry clear send 0
	bclr		#DSI,PCD		;else need to send 1
	jmp		<DATATOG5
DATATGL2 bset		#DSI,PCD		;send 1 if carry set

;********IN-LINE CLOCK TOGGLE******
DATATOG5 movep		 #0,PCC			;turn off ssi, turn on portc io
	bclr		#DATAFLG,FLAGS		;clear data flag
	bset		#DSCK,PCD		;set clock high
	rep		#2
	nop					;kill some time
	btst		#DSO,PCD		;get data bit value
	jcc		CLKTG			;if data is 0 keep going
	bset		#DATAFLG,FLAGS		;else set it to 1
CLKTG  bset		#DSCK,PCD		;set clock high
	rep		n5
	nop					;set clock high
	bclr		#DSCK,PCD		;set clock low
	rep		n5
	nop					;set clock low
;*******END OF IN_LINE CLICK TOGGLE*****
DATATOGL6 move		JTAGDATA,b		;get current value
	btst		#DATAFLG,FLAGS		;chek if next bit is 0 or 1
	ror		b			;get bit
	move		b1,JTAGDATA		;save value
DATATOGL4 rts
;***************************************************************************
;	SHIFTDATA presents the data at the port pin so it may be sent
;	to the target.	The last bit of data must be present when exiting
;	so that when the jtag state machine transitions to the exit1 state
;	it will capture the last bit of data.
;	Assumption is that the data going out is in A and data coming in is
;	in B.
;**************************************************************************
;SHIFTDATA lsr		   a		   ;check if data is 1 or 0
;SHIFTDATA1 jcs		    <DATATOGL2	    ;if carry clear send 0
;	 bclr		 #DSI,PCD	;else need to send 1
;	 jmp		 <DATATOGL5
;DATATOGL2 bset		 #DSI,PCD	;send 1 if carry set
;DATATOGL5 rts

;*************************************************************************
;	SENDCMD will send an 8 bit cmd via the ssi
;	WL1,WL0=00 for 8 bit xfer
;	WL1,WL0=01 for 12 bit xfer
;	WL1,WL0=10 for 16 bit xfer
;	WL1,WL0=11 for 24 bit xfer
;*************************************************************************
SENDCMD ;jsr	JXFER8			;go set up ssi: 8bit,LSB first
	move	TEMPAREA,a1		;get cmd to send
	rep	#8
	lsl	a1
	move	a1,ACTIVECMD
	jmp	OISSUE8
;*******************************************************************
;	SENDIT
;	This routine transmits a value by calling the DATATOGLE1 routine.
;	It transmits either 8 or 16 bits at a time depending
;	where this routine is entered.
;	The value to transmit is in the A accumulator upper byte or
;	upper 16 bits.
;*******************************************************************
SENDIT	clr	b			;this is for command type 4
SENDITX move	a1,y1			;save command temporarily
	jset	#5,TEMPAREA,SENDIT1	;check if 24 bits to be sent
	move	y:(r2)+,b1	;get value to send
	jclr	#2,DEVICE,SENDNXT
	move	b1,a1
	jmp	SEND2
SENDNXT	rep	#8		;need to shift it right 8 bits
	lsr	b1
	move	b1,y1		;save new lower 16 bits to reconstruct word
	move	y:(r2)+,a1
	rep	#8			;get upper 8 bits of work
	lsl	a1
	or	y1,a1			;need to send 24 bits
SEND2	move	a1,ACTIVECMD
	jset	#2,DEVICE,OISSUE16
	jclr	#2,DEVICE,OISSUE24		;  send 24 bits

SENDIT1 move	y:(r2)+,a1
	move	(r2)+
	move	a1,ACTIVECMD
	jmp	OISSUE16

GOIDLE	move		#EXIT_IDLE,b1		;need to finish jtag xfer states
	jsr		<TMSTOGGLE
	bset		#POLLSTATUS,FLAGS	;need to poll for status
	rts					;must be 16 bit device
 
;*******************************************************************
;	GETIT routine toggles data in by sending dummy data and
;	receiving it through the port bit pin.	The value is received
;	in the B accummulator upper byte or upper 16 bits.
;	
;*******************************************************************
GETIT	ori		#$3,mr			;disable interrupts
	movep		#$0,IPR			;turn off IRQA,IRQB
	jset	#2,DEVICE,OREAD16
	jclr	#5,TEMPAREA,OREAD24
	jmp	OREAD16

;************************************************************************
RECEIVE clr	b			;clear data buffer
	move	b1,JTAGDATA
	jsr	<XFERDAT		;go get data by sending dummy data
	move	JTAGDATA,a1		;get stored value
	jset	#2,DEVICE,GET16B2
	jsr	<SHIFTR8		;shift data right 8 bits
GET16B2 move	a1,x:(r3)+		;save upper 8 bits
	movep	#$3e,IPR		;turn on IRQA,IRQB
	rts
;******************************************************************
;	Following are the parsed commands sent from the host computer.
;	Each command retrieves the number of arguments
;	required to execute that command.
;******************************************************************
;	GO COMMAND (10)
;******************************************************************
GOCMD	move		x:GOSEQ,r0		;preset sequence load ptr.
	move		#1,r7			;preset address write ptr.
	jsr		<LOADSEQ		;load sequence
	jsr		<GETLWORD		;get PILR value

	jset		#2,DEVICE,GO1		;check if 56lp16 or hawk
	jclr		#1,DEVICE,GO4		;check if 96k or 56k
	jset		#0,DEVICE,GO3		;check if onyx
	jmp		<GO1			;must be 56100

GO4	move		x1,y:(r7)+		;save PILR high
GO1	move		x0,y:(r7)+		;save PILR low
GOO1	move		(r7)+
	jsr		<GETLWORD		;get PDBR value

	jset		#2,DEVICE,GO2		;check if lp16 or hawk
	jclr		#1,DEVICE,GO6		;check if 96k or 56k
	jset		#0,DEVICE,GO5		;check if onyx
	jmp		<GO2			;must be 56100

GO6	move		x1,y:(r7)+		;save PDBR high
GO2	move		x0,y:(r7)		;save PDBR low
GOO2	jsr		<RUNSEQ			;run sequence
	bclr		#DEBUGMODE,FLAGS	;clear debug mode status flag
	jsr	USRADD
	rts					;return to monitor
;*******************************************************************
;	Need to check for onyx byte reversal
;*******************************************************************
GO3	move		x0,y:(r7)+		;save PILR LOW
	move		x1,y:(r7)+		;save PILR HI
	jmp		<GOO1			;must be 56300
;*******************************************************************
GO5	move		x0,y:(r7)+		;save PDBR low
	move		x1,y:(r7)		;save PDBR hi
	jmp		<GOO2			;must be 56300
;******************************************************************
;	GO DELAY COMMAND (11)
;	This command is not currently implemented.
;******************************************************************
GODELAY move		x:GOSEQ,r0		;preset sequence load ptr
	move		#1,r7			;preset address write pTr
	jsr		<LOADSEQ		;load seq.
	jsr		<GETLWORD		;get PILR value

	jset		#2,DEVICE,GO21		;check if 56lp16 or hawk
	jclr		#1,DEVICE,GO11		;check if 96k or 56k
	jset		#0,DEVICE,GO71		;check if onyx
	jmp		<GO21

GO11	move		x1,y:(r7)+		;put PILR high
GO21	move		x0,y:(r7)+		;put PILR low
GO31	move		(r7)+
	jsr		<GETLWORD		;get PDBR value

	jset		#2,DEVICE,GO51		;check if 56lp16 or hawk
	jclr		#1,DEVICE,GO41		;check if 96k or 56k
	jset		#0,DEVICE,GO81		;check if onyx
	jmp		<GO51

GO41	move		x1,y:(r7)+		;put PDBR high
GO51	move		x0,y:(r7)+		;put PDBR low
GO61	move		#>$55,y0		;setup trig byte
	move		#>$aa,y1		;setup abort byte
	move		#>$ff,x0		;setup mask value
TRIG1	movep		PBD,a1			;wait for trigger
	and		x0,a
	cmp		y0,a
	jeq		<GODELAY1		;if trigger byte go
	cmp		y1,a
	jeq		<GORETRN		;return if abort
	jmp		<TRIG1			;else go get new value
GODELAY1 jsr		<RUNSEQ			;run sequence
	bclr		#DEBUGMODE,FLAGS	;clear debug mode status flag
GORETRN ;jsr	USRADD
	rts					;else return to monitor
;*******************************************************************
;	Need to check for onyx byte reversal
;*******************************************************************
GO71	move		x0,y:(r7)+		;save PILR LOW
	move		x1,y:(r7)+		;save PILR HI
	jmp		<GO31			;must be 56300

GO81	move		x0,y:(r7)+		;save PDBR low
	move		x1,y:(r7)		;save PDBR hi
	jmp		<GO61			;must be 56300
;*******************************************************************
;	PREAD COMMAND (12)
;	This command services P memory reads. All memory
;	reads/writes return to the monitor from PREADDATA subroutine
;	via an rts.
;*******************************************************************
PREAD	move	x:RSAVE,r0		;need to save regs. before read
	move	#SAVEREG,r3		;point to x memory for reg. storage
	jclr	#3,DEVICE,PREAD11
	move	x:SAVE566,r0
PREAD11 jsr	<LOADSEQ		;load the sequence
	jsr	<RUNSEQ			;run the sequence
	bset	#CLEANUP,FLAGS		;set clean up flag
	move	x:PREADSEQ,r0		;point to pread seq.
	move	x:RPLOOP,r1		;get pread loop address
	jsr	<PREADDATA
	jclr	#3,DEVICE,PREAD22
	jsr	REGBACK1
	rts
PREAD22	 jsr		 <REGBACK	;need to restore regs. used
	rts
;*******************************************************************
;	PREADDATA
;	This routine is called by all memory read commands
;	R7 is used to point to the y memory location where
;	the start address in user memory is to be placed.
;	R3 will contain the value of the user memory location
;	read.
;*******************************************************************
PREADDATA move	x:OFFSET,r7	;y memory address to write to
	jsr	<INITSEQ
	jsr	<PREADVAL	;run sequence once
	jsr	<REDUN1
	jeq	<PREADDONE	;if zero return
	move	r1,r0		;get loop sequence address
	jsr	<LOADSEQ
	do	x0,PREADDONE
PREADVAL jsr	<RUNSEQ		;run sequence
	jclr	#1,DEVICE,PREAD4 ;check if other than onyx
	jset	#0,DEVICE,PREAD3 ;check if onyx
PREAD4	move	x:-(r3),x0	;get value to return
	jset	#1,DEVICE,PREAD1 ;check if 16 bit device
	jset	#2,DEVICE,PREAD1   ;check if 56lp16 or hawk
PREAD2	move	x:-(r3),x1
PREAD1	jsr	<PUTLWORD	;send value to host
	nop
PREADDONE rts
 
PREAD3	move	x:-(r3),x1		;save reg LOW
	jclr	#3,DEVICE,NOT566	;need to increment double for 56600
	move	x:-(r3),x1		;dummy decrement of ptr
	move	x:-(r3),x0		;get upper 8 bits of word
	move	x:-(r3),x0		;dummy decrement of ptr
	jmp	PREAD1
NOT566	move	x:-(r3),x0		;save reg HI
	jmp	PREAD1			;must be 56300

;*******************************************************************
;	XREAD COMMAND (14)
;*******************************************************************

XREAD	move		x:RSAVE,r0	;need to save regs. before read
	move		#SAVEREG,r3	;point to x memory for reg. storage
	jsr		<LOADSEQ	;load the sequence
	jsr		<RUNSEQ		;run the sequence
	bset		#CLEANUP,FLAGS	;set clean up flag
	move		x:XREADSEQ,r0	;point to xread seq.
	move		x:RXLOOP,r1	;get pread loop address
XREADX	jsr		<XREADDATA
	jsr		<REGBACK	;need to restore regs. used
	rts
;*******************************************************************
;	XREADDATA
;	This routine is called by all memory read commands
;	R7 is used to point to the y memory location where
;	the start address in user memory is to be placed.
;	R3 will contain the value of the user memory location
;	read.
;*******************************************************************
XREADDATA move		 x:OFFSET,r7	;y memory address to write to
	jsr		<INITSEQ
	jsr		<XREADVAL	;run sequence once
	jsr		<REDUN1
	jeq		<XREADDONE	;if zero return
	move		r1,r0		;get loop sequence address
	jsr		<LOADSEQ
	do		x0,XREADDONE
XREADVAL jsr		 <RUNSEQ	;run sequence
	jclr		#1,DEVICE,XREAD4 ;check if other than onyx
	jset		#0,DEVICE,XREAD3 ;check if onyx
XREAD4	move		x:-(r3),x0	;get value to return
	jset		#1,DEVICE,XREAD1 ;check if 16 bit device
	jset		#2,DEVICE,XREAD1   ;check if 56lp16 or hawk
XREAD2	move		x:-(r3),x1
XREAD1	jsr		<PUTLWORD	;send value to host
	nop
XREADDONE rts

XREAD3	move		x:-(r3),x1		;save mem LOW
	move		x:-(r3),x0		;save mem HI
	jmp		<XREAD1			  ;must be 56300
 
;*******************************************************************
;	YREAD COMMAND (16)
;*******************************************************************

YREAD	move		x:RSAVE,r0	;need to save regs. before read
	move		#SAVEREG,r3	;point to x memory for reg. storage
	jsr		<LOADSEQ	;load the sequence
	jsr		<RUNSEQ		;run the sequence
	bset		#CLEANUP,FLAGS	;set clean up flag
	move		x:YREADSEQ,r0	;point to yread seq.
	move		x:RYLOOP,r1	;get pread loop address
	jsr		<YREADDATA
	jsr		<REGBACK	;need to restore regs. used
	rts
;*******************************************************************
;	YREADDATA
;	This routine is called by all memory read commands
;	R7 is used to point to the y memory location where
;	the start address in user memory is to be placed.
;	R3 will contain the value of the user memory location
;	read.
;*******************************************************************
YREADDATA move		x:OFFSET,r7	;y memory address to write to
	jsr		<INITSEQ
	jsr		<YREADVAL	;run sequence once
	jsr		<REDUN1
	jeq		<YREADDONE	;if zero return
	move		r1,r0		;get loop sequence address
	jsr		<LOADSEQ
	do		x0,YREADDONE
YREADVAL jsr		<RUNSEQ		;run sequence
	jclr		#1,DEVICE,YREAD4 ;check if other than onyx
	jset		#0,DEVICE,YREAD3 ;check if onyx
YREAD4	move		x:-(r3),x0	;get value to return
	jset		#1,DEVICE,YREAD1 ;check if 16 bit device
	jset		#2,DEVICE,YREAD1   ;check if 56lp16 or hawk
YREAD2	move		x:-(r3),x1
YREAD1	jsr		<PUTLWORD	;send value to host
	nop
YREADDONE rts

YREAD3	move		x:-(r3),x1		;save mem LOW
	move		x:-(r3),x0		;save mem HI
	jmp		<YREAD1			;must be 56300

;*******************************************************************
;	PWRITE Block Fill COMMAND (13)
;*******************************************************************

PWRITE	move		x:RSAVE,r0	;need to save regs. before read
	move		#SAVEREG,r3	;point to x memory for reg. storage
	jclr		#3,DEVICE,PWRITE1
	move		x:SAVE566,r0
PWRITE1 jsr		<LOADSEQ	;load the sequence
	jsr		<RUNSEQ		;run the sequence
	bset		#CLEANUP,FLAGS	;set clean up flag
	move		x:PWRITSEQ,r0	;point to pwrite seq.
;*******************************************************************
	jsclr	#3,DEVICE,REDUNDNT2	;if not 56600 then do normal way
	jsset	#3,DEVICE,PWRIT5660	;else write vals to different locs
	jeq	<PWBLKDONE
	do	x0,PWBLKDONE
	move	x:PWWLOOP1,r2	  ;point r1 to short seq.
	jsr	<RUNSEQ1
	nop
PWBLKDONE jclr	#3,DEVICE,PWBLKDONE1
	jsr	<REGBACK1
	rts
PWBLKDONE1 jsr	<REGBACK	;need to restore regs. used
DONE1	rts
;*******************************************************************
;	PWRITE Block to DSP56600
;*******************************************************************
PWRIT5660 move		x:OFFSET,r7	;y mem address to write to
	jsr		INITSEQ		;load seq. get addr, count
PWRIT5661 jsr		  <GETLWORD	  ;get value to write
	move		#$ffff,m7
	move		x0,y:$A		;put lower 16 bits
	move		x1,y:$10	;put upper 8 bits
	jsr		<RUNSEQ		;run the sequence
	move		LOOPCOUNT,b	;get count value
	move		#>1,x0		;decrement by 1
	sub		x0,b
	move		b1,x0		;save count
	rts

;*******************************************************************
;	XWRITE Block Fill COMMAND (15)
;*******************************************************************
 
XWRITE	move		x:RSAVE,r0	;need to save regs. before read
	move		#SAVEREG,r3	;point to x memory for reg. storage
	jsr		<LOADSEQ	;load the sequence
	jsr		<RUNSEQ		;run the sequence
	bset		#CLEANUP,FLAGS	;set clean up flag
	move		x:XWRITSEQ,r0	;point to xwrite seq.
	move		x:WLOOP1,r1	;point r1 to short seq.
;******************************************************************
XWRITEBLK jsr		 <REDUNDNT2 
	jeq		<XWBLKDONE 
	do		x0,XWBLKDONE 
	move		x:XWWLOOP1,r2	  ;point r1 to short seq. 
	jsr		<RUNSEQ1 
	nop 
XWBLKDONE jsr		  <REGBACK	  ;need to restore regs. used
	rts
;*******************************************************************
;	YWRITE Block Fill COMMAND (17)
;*******************************************************************

YWRITE	move		x:RSAVE,r0	;need to save regs. before read
	move		#SAVEREG,r3	;point to x memory for reg. storage
	jsr		<LOADSEQ	;load the sequence
	jsr		<RUNSEQ		;run the sequence
	bset		#CLEANUP,FLAGS	;set clean up flag
	move		x:YWRITSEQ,r0	;point to ywrite seq.
	move		x:WLOOP1,r1	;point r1 to short seq.
;****************************************************************** 
YWRITEBLK jsr		 <REDUNDNT2 
	jeq		<YWBLKDONE 
	do		x0,YWBLKDONE 
	move		x:YWWLOOP1,r2	  ;point r1 to short seq. 
	jsr		<RUNSEQ1 
	nop 
YWBLKDONE jsr		  <REGBACK	  ;need to restore regs. used
	rts
;*******************************************************************
;	REG_RD COMMAND (18)
;	This command should receive a 4 byte offset value
;	and a 4 byte count of how many registers to read.
;	R0 contains offset to EPROM where sequence is to be
;	retrieved.  R6 contains offset to EPROM where opcode to
;	write to register is retrieved.
;*******************************************************************
REG_RD  jclr		#2,DEVICE,NOSAVE ;do not save if not 56800
	move		x:RSAVE,r0	;need to save regs. before read
	move		#SAVEREG,r3	;point to x memory for reg. storage
	jsr		<LOADSEQ	;load the sequence
	jsr		<RUNSEQ		;run the sequence

NOSAVE	move		x:REGRDSEQ,r0	;point to regread seq.
	move		x:GETREG,r6	;get reg. opcode in EPROM
	jsr		<REGSETUP	;go setup sequence RAM

	do		a1,REG_RDONE
	move		#>1,r1		;init r1 to point to y opcode
	jset		#0,DEVICE,REG_RD3 ;check if onxy or 56k
	jset		#1,DEVICE,REG_RD1 ;if 16 bit device only write one
REG_RD3 jset		#2,DEVICE,REG_RD1   ;check if 56lp16 or hawk
	nop
	do		#2,REG_RD2	;load opcode
REG_RD1 move		p:(r0)+,a	;get reg opcode
	move		a1,y:(r1)+	;put in y memory
	nop
REG_RD2 nop
RREADVAL jsr		 <RUNSEQ	;run sequence
	jclr		#1,DEVICE,REG_RD0 ;if 56k don't byte reverse
	jset		#0,DEVICE,RREAD3 ;if onyx need to swap bytes
REG_RD0 move		x:-(r3),x0	;get value to return
	jset		#1,DEVICE,RREAD1 ;check if 16 bit device
	jset		#2,DEVICE,RREAD1   ;check if 56lp16 or hawk
RREAD2	move		x:-(r3),x1
RREAD1	jsr	       <PUTLWORD       ;send value to host
	nop
REG_RDONE	nop
	jclr		#2,DEVICE,NOREST1
	jsr		<REGBACK	;need to restore regs. used
NOREST1	rts				;end of reg_rd
;******************************************************************
;	Need to byte swap for onyx
;*****************************************************************
RREAD3	move		x:-(r3),x1	;get hi value first
	move		x:-(r3),x0	;get low value next
	jmp		<RREAD1
;*******************************************************************
;	REGSETUP
;	This routine is called by the reg read/write commands
;	to initialize the sequence RAM before execution.
;*******************************************************************
REGSETUP jsr		<LOADSEQ	;load sequence
	clr		a
	jsr		<GETARG		;get start reg. value
REG_RDX move		r6,b		;get reg. start address in RAM
	add		b,a		;add to start offset
	move		a1,r0		;put in ptr.
	jsr		<GETARG		;get reg. count
	rts
;*******************************************************************
;	REG_WR COMMAND (19)
;	This command receives a 4 byte offset and a 4 byte
;	count of how many registers to write to.  The values
;	to write are then received as each register is written.
;*******************************************************************

REG_WR	move		x:REGWRSEQ,r0	;point to regwrite seq.
	move		x:PUTREG,r6	;get reg. opcode in EPROM
	jsr		<WREGSETUP	;go setup sequence RAM
	move		x:LOCREGVAL,r6	;pnt r6 to seq mem loc for val to write
	do		a1,REG_WDONE
	move		#>1,r1		;init r1 to point to y opcode
	jset		#2,DEVICE,OPWRL6   ;check if 56lp16 or hawk
	jset		#0,DEVICE,OPWRL5 ;check if onyx
	jset		#1,DEVICE,OPWRL6 ;if 16 bit device only write one
OPWRL5	do		#2,OPWRL4	;load opcode
OPWRL6	move		p:(r0)+,a	;get reg opcode
	move		a1,y:(r1)+	;put in y memory
OPWRL4	move		r6,r7
	jsr		<REDUNDNT3
	jsr		<RUNSEQ
	nop
REG_WDONE rts
;*******************************************************************
;	REGSETUP
;	This routine is called by the reg read/write commands
;	to initialize the sequence RAM before execution.
;*******************************************************************
WREGSETUP jsr		 <LOADSEQ	;load sequence
	jsr		<GETARG		;get start reg. value
	move		r6,b		;get reg. start address in RAM
	add		b,a		;add to start offset
	move		a1,r0		;put in ptr.
	jsr		<GETARG		;get reg. count
	rts
;*******************************************************************
;	Program memory WRITE values COMMAND (1A)
;*******************************************************************

P1WRITE move		x:RSAVE,r0	;need to save regs. before read
	move		#SAVEREG,r3	;point to x memory for reg. storage
	jclr		#3,DEVICE,PWRITE11
	move		x:SAVE566,r0
PWRITE11 jsr		<LOADSEQ	;load the sequence
	jsr		<RUNSEQ		;run the sequence
	bset		#CLEANUP,FLAGS	;set clean up flag
	move		x:PWRITSEQ,r0	;point to pread seq.
	move		x:WPLOOP,r1	;get write loop address
	jsclr		#3,DEVICE,REDUNDNT2
	jsset		#3,DEVICE,PWRIT5660
	jeq		<PWRITEDONE
	move		r1,r0		;get loop sequence address
	jsr		<LOADSEQ	;reload loop sequence
	move		x:WLOOPVAL,r6	;setup ptr for value
	do		x0,PWRITEDONE
	move		r6,r7
	jsclr		#3,DEVICE,REDUNDNT3
	jsset		#3,DEVICE,PWRIT5662	;do differently if 56600
	jsr		<RUNSEQ
	nop
PWRITEDONE jclr		#3,DEVICE,P2WRITE
	jsr		REGBACK1
	rts
P2WRITE jsr		<REGBACK	;need to restore regs. used
	rts

PWRIT5662 jsr		  <GETLWORD	  ;get value to write
	move		#$ffff,m7
	move		x0,y:$4		;put lower 16 bits
	move		x1,y:$A		;put upper 8 bits
	rts
;*******************************************************************
;	X memory WRITE values COMMAND (1B)
;*******************************************************************

X1WRITE move		x:RSAVE,r0	;need to save regs. before read
	move		#SAVEREG,r3	;point to x memory for reg. storage
	jsr		<LOADSEQ	;load the sequence
	jsr		<RUNSEQ		;run the sequence
	bset		#CLEANUP,FLAGS	;set clean up flag
	move		x:XWRITSEQ,r0	;point to xread seq.
	move		x:WXLOOP,r1	;get write loop address
	jsr		<REDUNDNT2
	jeq		<XWRITEDONE
	move		r1,r0		;get loop sequence address
	jsr		<LOADSEQ	;reload loop sequence
	move		x:WLOOPVAL,r6	;setup ptr for value
	do		x0,XWRITEDONE
	move		r6,r7
	jsr		<REDUNDNT3
	jsr		<RUNSEQ
	nop
XWRITEDONE jsr		<REGBACK	;need to restore regs. used
	rts
;*******************************************************************
;	Y memory WRITE values COMMAND (1C)
;*******************************************************************

Y1WRITE move		x:RSAVE,r0	;need to save regs. before read
	move		#SAVEREG,r3	;point to x memory for reg. storage
	jsr		<LOADSEQ	;load the sequence
	jsr		<RUNSEQ		;run the sequence
	bset		#CLEANUP,FLAGS	;set clean up flag
	move		x:YWRITSEQ,r0	;point to yread seq.
	move		x:WYLOOP,r1	;get write loop address
	jsr		<REDUNDNT2
	jeq		<YWRITEDONE
	move		r1,r0		;get loop sequence address
	jsr		<LOADSEQ	;reload loop sequence
	move		x:WLOOPVAL,r6	;setup ptr for value
	do		x0,YWRITEDONE
	move		r6,r7
	jsr		<REDUNDNT3
	jsr		<RUNSEQ
	nop
YWRITEDONE jsr		<REGBACK	;need to restore regs. used
	rts
;*******************************************************************
;	READ OnCE REGISTER COMMAND (1D)
;	The command will read the OnCE registers and return the results
;	to the host computer after each read.  There are
;	a total of N OnCE registers. This command has a 3 byte packet.
;*******************************************************************

OREG_RD move		x:OGETREG,r0	;point to OnCE reg read seq.
	jsr		<LOADSEQ	;load sequence into Y RAM
	jsr		<GETBYTE	;get start location.
	move		y0,r2		;and put in ptr.
	move		y0,n3		;save offset value
	jsr		<GETBYTE	;get stop location.
	move		y0,r3		;need to write eos at this location
	move		#1,r4		;need to set up eos.
	move		r4,y:(r3+n3)
	move		#0,n3		;clear offset to r3
	move		#SAVEREG,r3
	jsr		<RUNSEQ1	;run sequence
	move		#>SAVEREG,y0	    ;need to calculate loop count
	move		r3,a
	sub		y0,a
	jsset		#2,DEVICE,GETOSR ;go check if OSR needs to be read
	jset		#0,DEVICE,OREG_RD4   ;check if onyx or 56k
	jset		#1,DEVICE,OREG_RD3   ;chek if 5616 bit device
OREG_RD4 jset		#2,DEVICE,OREG_RD3   ;check if 56lp16 or hawk
	asr		a		;divide count by 2
OREG_RD3 do		a1,OREG_RD1	;need to do r2 times
	jclr		#1,DEVICE,OREG_RD7 ;if 56k, don't byte reverse
	jset		#0,DEVICE,OREG_RD6 ;if onyx need to byte reverse
OREG_RD7 move		x:-(r3),x0	;get value to return
	jset		#1,DEVICE,OREG_RD2   ;chek if 16 bit device
	jset		#2,DEVICE,OREG_RD2   ;check if 56lp16 or hawk
OREG_RD5 move		x:-(r3),x1
OREG_RD2 jsr		<PUTLWORD	;send to host
	nop
OREG_RD1 rts
;*********************************************************************
;	Need to send data byte reversed on onyx
;*********************************************************************
OREG_RD6 move		x:-(r3),x1	;get high byte
	move		x:-(r3),x0	;get low byte
	jmp		<OREG_RD2	;go send data

;*********************************************************************
;	This code is specifically for the LP16
;*********************************************************************
GETOSR	move		#>13,b		;need to check if getting osr
	cmp		b,a
	jne		GETOSR1		;if not then return
	move		a1,DEVTMP	;save A temporarily
	jsr		<SDR		;put jtag in shift-dr state
	move		#DUMB_CMD,a	;load dumb OnCE command
	jsr		<RECEIVE	;send it and get osr value
	jsr		<GOIDLE		;be sure to end up in jtag idle
	move		DEVTMP,a1	;restore A
	move		a1,r7		;need to increment count
	move		x:-(r3),b1	;need to shift 8 bit data right
	rep		#8
	lsr		b
	move		b1,x:(r3)+	;and return to its place
	move		(r7)+
	nop
	move		r7,a1		;now count is correct
GETOSR1 rts

;*******************************************************************
;	WRITE OnCE REGISTER COMMAND (1E)
;	This command writes values to OnCE registers.
;	It must receive a 1 byte offset and a 1 byte count
;	to the registers to write to.
;*******************************************************************

OREG_WR jsr		<GETBYTE	;get offset value
	move		x:OPUTREG,b	;point to OnCE reg. write seq.
	add		y0,b		;add offset to ptr.
	move		b1,r0
	jsr		<GETBYTE	;get count value
	do		y0,OWRITE	;do count times
	move		p:(r0)+,a	;get register write command
	move		a1,y:0		;put in sequence RAM
	move		#1,r6		;r6 points to seq.ram where value to write is put
	jset		#2,DEVICE,OWRIT0 ;check if lp16 or hawk
	jclr		#1,DEVICE,OWRIT1 ;check if 96k or 56k device
	jset		#0,DEVICE,OWRIT1 ;check if onyx
OWRIT0	move		r6,y:2		;put eos in Y RAM for 16 bit device
	jmp		<OWRIT2
OWRIT1	move		r6,y:3		;put eos in Y RAM for 24,32 bit device
OWRIT2	move		r6,r7
	jsr		<REDUNDNT3
	jsr		<RUNSEQ
	nop
OWRITE	rts
;*******************************************************************
;	This routine compensates for the 16 bit registers on 
;	the 56600.  The 16 bits must reside in the upper 16 bits
;	of a 24 bit word.
;******************************************************************
DATAFIX move		y:0,a		;need to get the once command
	move		#>$20,y0	;ned to test if 16 bit
	and		y0,a
	tst		a
	jeq		NOT16BIT	;if result is 0 then return
	eor		y0,a		;need to make a 24 bit write
	move		a,y:0		;and put it back in y mem
	move		y:1,a
	move		a,b
	rep		#8		;move bits 7-0 to 15-8
	lsl		a
	move		a,y:1		;and save it back
	rep		#8
	lsr		b		;move bits 15-8 to 23-16
	move		b,y:2
NOT16BIT rts
;*******************************************************************
;	TRACE OnCE SEQUENCE COMMAND (1F)
;	This command executes one sequence step in Y memory.
;	The sequence ptr is retrieved and used to step through the
;	Y memory OnCE commands. A one byte trace count is also sent.
;*******************************************************************

SEQTRACE jsr		<GETBYTE	;get count value
	move		YPTR,r2		;preset y mem. ptr.
	move		XPTR,r3		;preset x mem. ptr.
	do		y0,TRAC_END	;do count times
	clr		a #1,n2		;preset offset for 1
	move		y:(r2),y0	;get current value
	move		#>4,a1		;only write commands are
	and		y0,a		;greater than 1 word
	jne		<TRAC_CONT	;must be 1 word command
	move		#2,n2		;preset for 16 bit
	jset		#2,DEVICE,TRAC_CONT   ;check if 56lp16 or hawk
	jset		#0,DEVICE,TRAC_1	;check if onyx
	jset		#1,DEVICE,TRAC_CONT	;keep going if 5616 bit
TRAC_1	move		#3,n2		;else its 3 word command
	nop
TRAC_CONT move		y:(r2+n2),y0	;get value to savea
	move		#>1,a		;make acc.a =1
	move		a1,y:(r2+n2)	;put eos after command/opcode
	move		y0,YTEMP	;save value
	jsr		<RUNSEQ1	;go do sequence step
	move		YTEMP,y0	;get old value
	move		YPTR,r4		;get original ptr
	move		n2,n4		;get offset to ptr
	nop
	move		y0,y:(r4+n4)	;restore value
	move		#0,n2		;clear n2
	move		#0,n4		;clear n4
TRAC_END move		r2,YPTR		;save new pointer value
	rts
;*******************************************************************
;	RUN OnCE SEQUENCE COMMAND (20)
;	This command executes a complete sequence in Y memory.
;	The R2 register is loaded with a Y memory pointer which
;	is used to execute the sequence.
;
;*******************************************************************

SEQEXEC move		YPTR,r2		;get saved ptr value
	move		XPTR,r3		;preset x mem. ptr.
	jsr		<RUNSEQ1	;run sequence
	rts
;*******************************************************************
;	Save OnCE Pipeline COMMAND (21)
;	This command loads a sequence which reads all the
;	registers associated with the pipeline and sends
;	them to the host computer.
;*******************************************************************

SAV_PIPE move		x:OPIPE,r0	;point to pipe read sequence
	jsr		<LOADSEQ	;load sequence into Y RAM
	move		#SAVEREG,r3
	jsr		<RUNSEQ	       ;run sequence
	move		#9,r4		;preset for once
	jclr		#JTAGDEV,FLAGS,SAV_PIP4
	move		#18,r4		;preset for onyx
	jset		#0,DEVICE,SAV_PIP5
	move		#8,r4		;preset for lp16
	nop
SAV_PIP4 do		r4,SAV_PIP1	;send values to host
	move		x:-(r3),x0	;get value for host
	jset		#1,DEVICE,SAV_PIP2   ;chek if 5616 bit device
	jset		#2,DEVICE,SAV_PIP2   ;check if 56lp16 or hawk
SAV_PIP3 move		x:-(r3),x1
SAV_PIP2 jsr		<PUTLWORD	;send it
	nop
SAV_PIP1 rts
;*******************************************************************
;	SAV_PIP5 is for xfering data in byte reversal
;	for onyx
;*******************************************************************
SAV_PIP5 do		r4,SAV_PIP6
	move		x:-(r3),x1
	move		x:-(r3),x0
	jsr		<PUTLWORD	;send data
	nop
SAV_PIP6 rts
;*******************************************************************
;	READ OnCE SEQUENCE COMMAND (22)
;	This command reads a Command sequence from Y memory for saving.
;	It requires a 2 byte address start location and a 2 byte
;	count of words to read.
;*******************************************************************

SEQREAD jsr		<GET16		;get address start
	move		x0,r0		;save for later
	move	x0,a
	rep	#8
	lsr	a
	move	a,r0
SEQREAD1 jsr		<GET16  	;get count value
	move		x0,r1		;init y memory pointer
	move	x0,a
	rep	#8
	lsr	a
	move	a,r1
	jsr		<GETBYTE	;get memtype
	move		#>$ff,b		;preset mask value
	and		y0,b
	move		b,r7		;save for later
	do		r1,ENDREAD	;loop till sequence sent
	move		x:(r0),x1	;get a value
	move		r7,y0		;restore memtype
	move		#>1,b
	cmp		y0,b		;check if x memory read
	jeq		<RDONE
	move		y:(r0),x1
	jgt		RDONE		;check if y memory read
	move		p:(r0),x1
RDONE	move		x1,a1		;need to put 8 bits in x1
	rep		#8		;and 16 in x0
	asl		a
	move		a1,x0
	rep		#8
	asr		a
	move		#0,a2		;make sure no extra bits set
	rep		#8
	asr		a		;get upper 8 bits
	move		a1,x1
	jsr		<PUT24		;send word
	move		(r0)+		;increment ptr.
ENDREAD rts				;return to monitor
;*******************************************************************
;	WRITE OnCE SEQUENCE COMMAND (23)
;	This command writes a command sequence to the Y memory.
;	It requires a 2 byte address start and a 2 byte
;	count of values which it will write. 
;*******************************************************************

SEQWRITE jsr		<GET16		;get address start
	move		x0,r0		;save for later
	move	x0,a
	rep	#8
	lsr	a
	move	a,r0
SEQWRITE1 jsr		<GET16  	;get count value into X0 reg.
	move		x0,r1		;init y memory pointer
	move	x0,a
	rep	#8
	lsr	a
	move	a,r1
	jsr		<GETBYTE	;get memtype
	move		#>$ff,b		;preset mask value
	and		y0,b
	move		b1,r7		;save for later
	do		r1,ENDWRITE
	jsr		<GET24		;get 24 bit value to write
	move		x0,a1
	rep		#8
	lsr		a
	move		x1,b1		;make value 24 bits
	rep		#8
	lsl		b
	move		b1,x1
	or		x1,a
	move		#>1,b		;restore memory type
	move		r7,y0
	cmp		y0,b
	jeq		<WRITEX
	jgt		<WRITEY		;check if write to x or y
	move		a1,p:(r0)+
	jmp		<SEQWREND
WRITEY	move		a1,y:(r0)+
	jmp		<SEQWREND
WRITEX	move		a1,x:(r0)+
SEQWREND nop
	nop
ENDWRITE rts
;*********************************************************************
;	Read_Misc command (24)
;	This command reads OnCE status and current
;	scratch pad registers such as the Y memory ptr.
;	and flags register.
;	This command receives a 1 byte offset value and sends a
;	one byte result.
;	Offset values are as follows:
;	0=OnCE port status pins (DS0,DS1)
;	1=command converter flag bits
;	2=command converter Y memory pointer
;	3=command converter revision number
;*********************************************************************

MISC_RD jsr		<GETBYTE	;get offset value
	move		#>2,a		;need to check what to read
	cmp		y0,a
	jlt		<READREV	;Command converter rev. num?
	jeq		<READPTR	;Command Converter Y ptr?
	move		y0,a
	tst		a
	jeq		<READSTAT	;OnCE status pins?
	;READ COMMAND CONVERTOR STATUS
	move		FLAGS,a1	;read converter flags
	jmp		<SENDVAL	;send result to host and return
	;READ SOFTWARE REVISION
READREV move		#>REV,a1		;read software rev. number
	jmp		<SENDVAL	;send result to host and return
	;READ OnCE STATUS PINS
READSTAT movep		PCD,a1		;get port C value
	rep		#6
	lsr		a		;put into lower byte
	jmp		<SENDVAL	;send result to host and return
	;READ COMMAND CONVERTOR OnCE Y PTR.
READPTR move		YPTR,a1		;read OnCE y ptr
;************************************************************************
;	SUPER KLUDGE so new monitor works with old revs of 
;	24 and 32 bit user interfaces.	It always will send 
;	2 bytes so it will be compatible with 16 bit systems.
;************************************************************************
SENDVAL move		a1,x1
	rep		#8
	lsl		a
	move		a1,x0		;send info in x0
	jset		#3,DEVICE,PUT32		;if 56600 send 32 bits
	jsr		<PUT16
	jset		#2,DEVICE,DONOTDO   ;check if 56lp16 or hawk
	jset		#0,DEVICE,DOMORE  ;check if onyx
	jset		#1,DEVICE,DONOTDO ; if 16 bit you're done
DOMORE	jsr		<PUTBYTE	;else send another byte
	jclr		#1,DEVICE,DONOTDO ; if 24 bit you're done
	jsr		<PUTBYTE	;else send another byte
DONOTDO rts
;*********************************************************************
;	Write_Misc command (25)
;	This command writes to scratch pad registers
;	such as the Y memory ptr. and flags register.
;	This command receives a 1 byte offset and a
;	value to write to the register.
;*********************************************************************

MISC_WR jsr		<GETBYTE	;get register offset to read
	move		y0,r0		;put into ptr reg.
	jsr		<GETBYTE	;get value to write
	move		y0,x:(r0)	;put value in x memory
;*********************************************************************
;	This is a kludge place to put this code but I needed to do
;	this for exit of reset.	 First thing host does is a misc_wr
;	and I need to make sure the proper flag is set before the
;	first hand_shake.
;
;	Need to set jtagflag if device type is jtag
;********************************************************************* 
	bclr		#JTAGFLAG,FLAGS ;preset for once type
	move		DEVICE,a	;get register address
	move		#>3,b
	cmp		b,a
	jlt		MISC_WR1	;if not jtag, keep going
	bset		#JTAGFLAG,FLAGS ;preset for jtag type
MISC_WR1 rts
;*******************************************************************
;	FORCE RESET COMMAND (26)
;	This command forces a reset on the target 
;	for approximately 500ms.
;	The reset output to the target will remain asserted until
;	the host computer sends a "terminate reset" byte.
;	command packet is as follows
;	command, (reset type)
;	if reset type = 0 then reset to user mode and wait for deassert byte.
;	if reset type = 1 then reset to debug mode and wait for deassert byte.
;	if reset type = 2 then get architecture type in next byte and
;	reset sequence tables only. 0=32bit,1=24bit,2=16bit,3=onyx,4=lp16,5=hawk.
;
;	The target reset pin is driven by an NPN transistor.
;*******************************************************************

FORCER	movep		#$0,IPR			;clear all interrupts
	bclr		#OnCEREQ,FLAGS		;clear OnCE flag
	jsr		<GETBYTE		;get reset type
	move		#>1,a			;check if init tables only
	move		y0,y1
	cmp		y1,a	
	jlt		<GETARC			;if byte=2 then set dsp type
	jne		<FORCER1
	bclr		#DEBUGREQ,PCD		;if byte=1 assert debug pin
FORCER1 bset		#ORESET,PCD		;if byte = 0 only assert reset pin
	jsr		<GETBYTE		;assert till byte received
	movep		#$3e,IPR		;enable interrupts
	bclr		#ORESET,PCD		;deassert reset pin
	cmp		y1,a			;if a=0 then we're done
	jeq		<WAITAK			;else handle debug stuff
	bclr		#DEBUGMODE,FLAGS	;take monitor out of debug mode
	rts
;*****************************************************************
WAITAK	jclr		#OnCEREQ,FLAGS,WAITAK	;wait for ack. from OnCE
	bset		#DEBUGREQ,PCD		;deassert debug request.
	bclr		#OnCEREQ,FLAGS		;clear OnCE ack. flag
	bset		#DEBUGMODE,FLAGS	;set debug mode flag
	jsr	USRDEL
	rts					;return from byte = 1
;*****************************************************************
;	Determine which table to load
;	lc=0=32 bit, lc=1=24bit, lc=2=16bit, lc=3=onyx,
;       lc=4=lp16, lc=5=hawk, lc=8=ultra-lite
;	Acc A should = 1 at this point.
;	This routine creates a table of pointers to a group of 
;	tables to pointers in ROM.  The ROM table for a given architecture
;	is loaded into the RAM area for sequence execution.
;*****************************************************************
GETARC	jsr	<GETBYTE		;get arch type.
	move	y0,TEMPAREA		;save device type temporarily
ARCDONE move	#SAVETEMP,r1		;preset to load to temp x space
	move	#TABLE8,r0		;preset table pointers
	move	r1,r3			;preset to load to temp x space
	move	y0,n3		;preset offset for getting ptr to tbl of ptrs.
	move	#ENDROM-TABLE8,r2	;preset loop count
	move	x:(r3)+n3,a		;add offset to r3 with dummy move
	jsr	<LOADTAB		;go load tables

	move	x:(r3),r0		;get pointer to table of pointers
	jsr	<TABLESET		;go load pointers to x mem.
;******************************************************************
;	The following code is for loading the 56300 or lp16
;	polling routine.  They are different at this time due
;	to the 56300 status values not being correct in the jtag
;	i-r path on first pass silicon.
;******************************************************************
	move	#>3,a			;setup to check for onyx
	cmp	y0,a			;preset for 56300
	jgt	<ONCETYPE		;load and return if true
	bset	#JTAGPORT,PBD		;preset pal for dack via dez(pb12=1)
	bset	#JTAGFLAG,FLAGS		;set flag for later use
	move	#>8,a			;check if 56600
	cmp	y0,a			;and if true, need to add 3
	jne	ENDARC
	move	#>3,a
	add	y0,a
	move	a,DEVICE		;save new device number
ENDARC	rts					;return to getcmd
;*****************************************************************
;	Part must have OnCE protocol
;*****************************************************************
ONCETYPE bclr	#JTAGPORT,PBD		;preset pal for dack via dso(pb12=0)
	bclr	#JTAGFLAG,FLAGS		;clear flag for later use
	move	#>PLLDEFAULT,a1
	move	a1,PLLVAR		;slow clock down for OnCE based products
	rts					;return to getcmd
;******************************************************************
;	Load DSP sequence Table of pointers from EPROM
;******************************************************************
TABLESET move	p:TABLESIZ,r2		;preset loop count
	move	#TABLE,r1		;preset table address
LOADTAB do	r2,FORCER4		;and put in x memory
	move	p:(r0)+,a
	move	a1,x:(r1)+
FORCER4 move	y0,DEVICE		;save device type
	rts
;*******************************************************************
;	FORCE BREAK COMMAND (27)
;	This command forces the target into debug mode of
;	operation.
;	The break output to the target is a debug request assertion
;	to bring the target into the debug mode.  The command converter
;	will wait for the acknowledge from the OnCE port.
;	When an ack is received it will report this to the host computer
;	and return to the monitor.
;*******************************************************************

FORCEB	bclr	#DEBUGREQ,PCD		;assert DE
WAITFRC jclr	#OnCEREQ,FLAGS,WAITFRC	;wait for acknowledge from once
	bset	#DEBUGREQ,PCD		;deassert DE
	bclr	#OnCEREQ,FLAGS		;clear OnCE ack. flag
	bset	#DEBUGMODE,FLAGS	;set monitor to debug mode
	rts
;******************************************************************
;	XFER YMEM TO PMEM AND EXECUTE (28)
;	This command will overlay a program into pmem
;	and execute it then return to the monitor.
;	First word sent will be the start pmem address
;	and the second word sent will be the count of
;	24 bit values to receive.
;*****************************************************************

EXOVERLAY jsr	GET16			;get start pmem address
	move	x0,r0			;and store in r0
	move	x0,r1			;also save for later
	jsr	GET16			;get count
	move	x0,a			;need to shift right 8
	rep	#8
	asr	a
	do	a,EXOVERLAY2		;go load code
	jsr	<GET24			;get 24 bit value to write
	move	x0,a1
	rep	#8
	lsr	a
	move	x1,b1			;make value 24 bits
	rep	#8
	lsl	b
	move	b1,x1
	or	x1,a
	move	a,p:(r0)+		;save in p mem.
	nop
EXOVERLAY2 jmp	(r1)			;done, return to monitor

;*******************************************************************
;	JTAG RESET (29)
;	This command forces the jtag machine to its reset state either
;	via 8 clocks with the TMS pin high or by asserting the TRESET
;	line.  An argument of 0 means to send 5 clocks while an argument
;	of 1 means to toggle the jtag reset pin.
;*******************************************************************

JRESET	jsr		<GETBYTE		;get argument on how to reset
	move		y0,b			;check if toggle clock
	tst		b
	jne		<TOGTRST			;go toggle trst pin
	move		#JRESET_IDL,b1		;with tms at 1
	jsr		<TMSTOGGLE		;go toggle tms 5 clocks
	rts

TOGTRST
	bclr		#DEBUGREQ,PCD		;pull DEBUG REQ low
	rep		#$fff			;wait
	tst		b			;do something
	bset		#DEBUGREQ,PCD		;pull DEBUG REQ high
	move		#RESET_IDLE,b1		;go from reset to idle state
	jsr		<TMSTOGGLE		;go toggle tms 1 clock
	rts					;return

;*******************************************************************
;	JTAG BREAK (2A)
;	This command forces the target to the debug mode of operation.
;	If it receives an argument of 0 it will force the jtag command
;	DEBUG_REQUEST, send the ENABLE_ONCE, then reads the status of the target
;	and returns this value in the handshake.
;	
;*******************************************************************

JBREAK	bclr		#DEBUGMODE,FLAGS 
	jsr		<GETBYTE	;get argument on how to force break
					;  we throw it away. (not used)
;*********************************************************************
;	This code will send the debug request via the jtag command
;*********************************************************************
	
	move	#JRESET_IDL,b
	jsr	TMSTOGGLE		;reset JTAG state to RTI
	move	#DEBUG_R,a1
	move	a1,ACTIVECMD
JBREAK1	jsr	JISSUE			;issue DEBUG_REQ
	jset	#STATUSBUSY,FLAGS,JBREAK1

	jsr	JREADSB			;issue ENABLE_ONCE
;JBREAK1 jsset		#2,DEVICE,JREADSB	;go check lp16 polling
;	jsclr		#2,DEVICE,JREADSB     ;go check onyx polling
;	jset		#STATUSBUSY,FLAGS,JBREAK1 ;return if status error

	
	bset		#DEBUGMODE,FLAGS
	bclr		#OnCEREQ,FLAGS
	jsr	USRDEL
	rts

;*********************************************************************
;	This code will toggle the DE pin
;*********************************************************************
TOGLDE	bclr		#JTAGPORT,PBD
	bclr		#DEBUGREQ,PCD		;assert DE pin
	rep		#$fff			;wait
	tst		b			;do something
	bset		#DEBUGREQ,PCD		;pull DE pin high
	bset		#JTAGPORT,PBD
JBREAKWAIT2 jclr	#OnCEREQ,FLAGS,JBREAKWAIT2 
	bset		#DEBUGMODE,FLAGS
	bclr		#OnCEREQ,FLAGS
	jsr	USRDEL
	rts 
;*******************************************************************
;	JTAG FORCE RESET TO DEBUG MODE (2B)
;	This command forces the target to the debug mode of operation
;	after asserting the reset pin.	
;
;	If it receives an argument of 0 it will force the
;	target to the user mode from reset.
;
;	If it receives an argument of 1 it will force the reset pin,
;	then assert the DE pin, wait for a deassert byte, then
;	deassert the DE pin, followed by a reset of the jtag state
;	machine into the idle state.  It will also turn power on to the
;	part prior to exiting the reset state.
;
;	A byte must be sent by host to deassert the pins.
;******************************************************************
TARGET_R jclr	#2,DEVICE,JFORCER
	jsr	<GETBYTE		;get argument 
	bset	#JTAGPORT,PBD		;insure the pal is ready for trst
	move	y0,b			;check if toggle to user mode
;*******ASSERT RESET ON TARGET******************
	bset	#ORESET,PCD		;assert reset pin
	tst	b
	jeq	<WAITBYTE
	jset	#2,DEVICE,HAWK_R	;hawk needs special handling
	move	#JRESET_IDL,b1
	jsr	TMSTOGGLE
	move	#DEBUG_R,a
	move	a,ACTIVECMD
	move	#DEBUG_R,a
	move	a,INACTIVECMD
	jsr	JISSUE
;*******WAIT FOR SIGNAL TO DEASSERT RESET PIN ***********
	jsr	<GETBYTE		;wait for deassert signal
	bclr	#ORESET,PCD		;deassert reset pin
;*******SEND ENABLE_ONCE JTAG COMMAND ***************
	move	#E_ONCE,a
	move	a,ACTIVECMD
	jsr	JISSUE

;	 jclr		 #3,DEVICE,WAITACK	;check if 56300
POLL566 jsr	JREADSB
	jset		#STATUSBUSY,FLAGS,POLL566 ;return if status error
	jmp		SETFLAGS		;don't wait for DE from 56600

WAITACK jclr		#OnCEREQ,FLAGS,WAITACK ;wait for ack from targe
	jset		#2,DEVICE,LP16R
SETFLAGS bset		#DEBUGMODE,FLAGS	;set debug mode flag
	bclr		#OnCEREQ,FLAGS
	jsr	USRDEL
	rts
;******TURN POWER ON TO LP16 ONCE CIRCUITS************************
LP16R	move       #>$4,a
	move	a,y:0		       ;need to run a sequence for 16 bit
	clr	a
	move	a,y:1
	move	#>$1,a
	move	a,y:2
	jsr	<RUNSEQ		       ;go execute sequence
	rep	#20
	lsr	b
	move	b,STATVAL		;put status in memory
	jmp	<SETFLAGS
	

WAITBYTE
	jsr	JREADSB
	jsr	<GETBYTE		;wait for deassert signal
	bclr	#ORESET,PCD		;deassert reset pin
	bclr	#DEBUGMODE,FLAGS	;clear debug mode flag
	move	#BYPASS,a1
	move	a1,ACTIVECMD
	jsr	JISSUE
	jsr	JREADSB
	jsr	USRADD
	rts
;*******RESET JTAG STATE MACHINE AND PUT IN IDLE STATE *******************
HAWK_R	bclr		#DEBUGREQ,PCD		   ;assert treset pin
	rep		#$100
	nop
	bset		#DEBUGREQ,PCD		   ;deassert treset pin
	jsr		<GETBYTE		;wait for deassert signal
	move		#JRESET_SIR,b1		;reset jtag state machine to shift-ir state.
	jsr		<TMSTOGGLE
;*******SEND ENABLE_ONCE JTAG COMMAND******************
	move	#DEBUG_R,a
	jsr	<XFERDAT       ;go send command
	jsr	<GOIDLE
	bclr	#ORESET,PCD	;deassert reset pin
	move	#IDLE_SIR,b1	;reset jtag state machine to shift-ir state.
	jsr	<TMSTOGGLE
	move	#E_ONCE,a
	jsr	<XFERDAT	;go send DEBUG_REQUEST command
	jsr	<GOIDLE
;******TURN POWER ON TO HAWK ONCE CIRCUITS************************
	move	#>$204,a		;if not set up for hawk
PWRUP	move	a,y:0			;need to run a sequence for 16 bit
	move	#>$800000,a		;set bits for cop-dis,de-enab,pw-up
PWRUP1	move	a,y:1
	move	#>$1,a
	move	a,y:2
	jsr	<RUNSEQ			;go execute sequence
;*******SEND DEBUG_REQUEST JTAG COMMAND******************
	bclr	#ORESET,PCD		;deassert reset pin
	jmp	<SETFLAGS		;reset flags

;******************************************************************
;	Following are the parsed commands
;	Each command retrieves the number of arguments
;	required to execute that command.
;	GO COMMAND (2C)
;******************************************************************

JGOCMD	move	x:GOSEQ2,r0		;preset sequence load ptr.
	move	#1,r7			;preset address write ptr.
	jsr	<LOADSEQ		;load sequence
	jsr	<GETLWORD		;get PILR value
	jset	#2,DEVICE,JGO1		;check if 56lp16 or hawk
	jset	#0,DEVICE,JGO3		;need to check if onxy
	jset	#1,DEVICE,JGO1		;chek if 5616 bit device
JGO4	move	x1,y:(r7)+		;save PILR high
JGO1	move	x0,y:(r7)+		;save PILR low
JGOO1	move	(r7)+
	jsr	<GETLWORD		;get PDBR value
	jset	#2,DEVICE,JGO2		;check if 56lp16 or hawk
	jset	#0,DEVICE,JGO5		;need to check if onyx
	jset	#1,DEVICE,JGO2		;chek if 16 bit device
JGO6	move	x1,y:(r7)+		;save PDBR high
JGO2	move	x0,y:(r7)		;save PDBR low
JGOO2	jsr	<RUNSEQ			;run sequence
	bclr	#DEBUGMODE,FLAGS	;clear debug mode status flag
	jsr	USRADD
	rts					;return to monitor
;*******************************************************************
;	Need to check for onyx byte reversal
;*******************************************************************
JGO3	jset	#2,DEVICE,JGO1		;check if 56800
	jclr	#1,DEVICE,JGO4		;check if 56002
	move	x0,y:(r7)+		;save PILR LOW
	move	x1,y:(r7)+		;save PILR HI
	jmp	<JGOO1			;must be 56300
JGO5	jset	#2,DEVICE,JGO2		;check if 56800
	jclr	#1,DEVICE,JGO6		;check if 56002
	move	x0,y:(r7)+		;save PDBR low
	move	x1,y:(r7)		;save PDBR hi
	move	#>$6c10,x0		;change once command to pdb-go-to
	move	x0,y:3
	jmp	<JGOO2			;must be 56800
;******************************************************************
;	56300/56600 READ FIFO Command (2D)
;	This command is special for the 56300/56600 since the 
;	onyx/onyx-ul has 25/17 bit fifo registers and require special
;	calls to insure the correct bit xfer count.
;	It will always read the entire fifo (12/8 registers)
;******************************************************************
RFIFOCMD jset	#3,DEVICE,R6FIFO

;*********** 56300 RFIFO ***********
R3FIFO	move	#SAVEREG,r3		;point to x memory storage area
	move	CLKRATE,n5		;preset clock rate
	move	#12,r0			;preset for 56300
	do	r0,R3FIFOEND		;need to read all of fifo
	move	#$920000,a1		;FIFO READ command
	move	a1,ACTIVECMD
	jsr	OISSUE8			;send command
	jsr	SDR			;JTAG <- Shift Data Register
	jsr	FILLTDO
	clr	a
	move	a,JTAGDATA		;clear jtag data buffer
	move	a,DEVTMP
	jsr	<CLKTOGGLE		;go get invalid bit first
	jclr	#DATAFLG,FLAGS,R3FIFO2
	move	#1,a2
	move	a2,DEVTMP		;save invalid bit temporarily
R3FIFO2	move	#16,a2			;preset for 16 bits
	jsr	<DATATOGLE1		;go toggle data
	move	JTAGDATA,b1
	move	b1,x:(r3)+		;save data lower 16 bits
	clr	a
	move	a,JTAGDATA		;clear jtag data buffer
	move	#7,a2			;preset for last 8 bits
	jsr	<XFERDAT1		;go get rest of data
	move	JTAGDATA,a1		;get data from buffer
	rep	#8
	lsr	a
	move	DEVTMP,b	       ;get first 16 bits
	lsr	b
	jcc	R3FIFO5			;check if invalid bit set
	move	#>$010000,y0
	or	y0,a
R3FIFO5	move	a1,x:(r3)+		;save data upper 9 bits
	jsr	<GOIDLE			;return jtag to idle
	nop
R3FIFOEND move	#12,r0			;56300: 12 deep trace buffer.
	do	r0,R3FIFOSND		;now need to send to host
	move	x:-(r3),x1		;read reg HIGH
	move	x:-(r3),x0		;read reg LO
	jsr	<PUTLWORD		;send data
	nop
R3FIFOSND rts

;***********  56600 RFIFO ***********
R6FIFO	move	#SAVEREG,r3		;point to x memory storage area
	move	CLKRATE,n5		;preset clock rate
	move	#8,r0
	do	r0,R6FIFOEND		;do 8 ;need to read all of fifo
	move	#$920000,a1		;  FIFO READ command
	move	a1,ACTIVECMD
	jsr	OISSUE8			;  send command
	jsr	SDR			;  JTAG <- Shift Data Register
	jsr	FILLTDO
	clr	a
	move	a,JTAGDATA		;  clear jtag data buffer
	move	a,DEVTMP
	jsr	<CLKTOGGLE		;  go get invalid bit first
	jclr	#DATAFLG,FLAGS,R6FIFO1
	move	#1,a2
	move	a2,DEVTMP		;  save invalid bit temporarily
R6FIFO1	move	#15,a2			;  preset for 56600 - 17 bits
;	jsr	<DATATOGLE1		;  get 15 bits, do not move to exit
	jsr	<XFERDAT1		;  get 15 bits, move to exit
	move	JTAGDATA,b1
	move	b1,x:(r3)+		;  save data lower 16 bits
	clr	a
	move	a,JTAGDATA		;  clear jtag data buffer
	move	DEVTMP,b		;  get first 16 bits
	lsr	b
	jcc	R6FIFO5			;  check if invalid bit set
	move	#>$010000,y0
	or	y0,a
R6FIFO5	move	a1,x:(r3)+		;  save data upper 9 bits
	jsr	<GOIDLE			;  return jtag to idle
	nop
R6FIFOEND				;enddo
	move	#8,r0			;56600 has 8 deep trace buffer.
	do	r0,R6FIFOSND		;do 8 ;now need to send to host
	move	x:-(r3),x1		;  read reg HIGH
	move	x:-(r3),x0		;  read reg LO
	jsr	<PUTLWORD		;  send data
	nop				;enddo
R6FIFOSND 
	rts

;****************************************************************
;	POLLSTATUS COMMAND (2E)
;	This function will poll the status of the device and
;	returns a 4 byte value.
;****************************************************************
POLLCMD	;move	#JRESET_IDL,b
	;jsr	TMSTOGGLE
	bclr		#DEBUGMODE,FLAGS	;clear debug mode flag
	move		#SAVEREG,r3		;preset save pointer
	jsr	JREADSB
	clr		b
	move		JTAGDATA,b1
	move		#>$f000,y1
	move		#>$d000,y0
	rep		#8
	lsr		b
	and		y1,b		;mask out garbage
	move		b1,x0
	move		#0,x1
 
	cmp		y0,b		;if in debug mode set debugmode flag
	.IF	<EQ>
	bset	#DEBUGMODE,FLAGS
	jsr	PUTLWORD
;	jsr	USRDEL
	.ELSE
	bclr	#DEBUGMODE,FLAGS
	jsr	PUTLWORD
;	jsr	USRADD
	.ENDI
	rts
;	ENDSEC
;****************************************************************	
; JTAGCOUNT COMMAND (2F) 
;   Returns the number of devices on a JTAG chain
;****************************************************************	
JTAGCNT jsr	GETBYTE			;get TMS #
	bset	#TMS0FLAG,FLAGS
	move	#JRESET_SIR,b1		;Reset JTAG State, go to SIR
	jsr	<TMSTOGGLE		;toggle tms pin
	jsr	JXFER8			;turn on SSI
	move	#$ffffff,a1		;set a1 with bypass command
	do	#20,ENDBP		;do 20
	jclr	#TDE,SSISR,*		;  wait to send more
	move	a1,TX			;  put all devices in bypass
	nop
ENDBP					;enddo
	bset	#JTAGTDI,JTAGBDAT	;set bit to send
	bset	#JTAGTDIV,JTAGBDAT	;set TDI bit valid
	jsr	BANGBIT			;bang the bit in
	move	#IDLE_SDR,b1
	jsr	TMSTOGGLE		;move to SHIFT_DR

	jsr	JXFER8			;turn on SSI
	clr	a			;clear a
	do	#20,ENDZO		;do 20
	jclr	#TDE,SSISR,*		;  wait to send more
	move	a1,TX			;  clear out bypass register
	nop
ENDZO					;enddo
	movep	#0,PCC			;turn off SSI
	clr	a			;clear a
	move	a,DEVCNT
	move	#>1,x0			;set x0 to 1

JTAGCN1 bset	#JTAGTDI,JTAGBDAT	;send 1
	jsr	BANGCLK			;
	btst	#JTAGTDO,JTAGBDAT	;test TDO
	.IF	<CC>			;if TDO=0 then
	move	DEVCNT,a		;
	add	x0,a			;  increment a
	move	a,DEVCNT		;
	jmp	JTAGCN1			;  send another 1
	.ENDI				;endi
	jsr	BANGBIT
	move	#0,x1
	move	DEVCNT,a
	rep	#8
	lsl	a
	move	a,x0
	jsr	PUTLWORD		;return # devices

;	rts
MKUSRLST move	DEVACTIVE,a		;fetch DEVACTIVE
	move	a,SAVEACTIV		;save DEVACTIVE
	move	#>1,a			;make 1st device active
	move	a,DEVACTIVE		;set active
	do	DEVCNT,DOSTAT		;do DEVCNT
	jsr	JREADSB			;  read status
	btst	#DEBUGMODE,FLAGS	;  test status
	.IF	<CC>			;  if device not in DEBUGMODE
	jsr	USRADD			;    add it to USERLST
	.ELSE				;  else
	jsr	USRDEL			;    remove it from USERLST
	.ENDI				;  endif
	move	DEVACTIVE,a		;  fetch last device
	lsl	a			;  advance to next device
	move	a,DEVACTIVE		;  store current device
DOSTAT					;enddo
	move	SAVEACTIV,a		;get true current device
	move	a,DEVACTIVE		;restore DEVACTIVE
	jsr	JREADSB			;read status of DEVACTIVE
	bset	#POLLENABLE,FLAG2	;enable polling
	
	rts				;return
;****************************************************************	
; SETACTV COMMAND (30) 
;****************************************************************	
SETACTV jsr	GETBYTE			;get DEV # into y0
	move	y0,DEVNUMA
	move	#>1,a1			;set a1=1
	lsr	a			;set carry bit
	rep	y0			;repeat DEV # times
	rol	a1			;  shift a left
	jsr	GETBYTE			;get TMS # (discard)
	move	a1,DEVACTIVE		;save DEVACTIVE
	move	#E_ONCE,a1		;will xmit enable_once
	move	a1,ACTIVECMD		;save active command
	jsr	JISSUE			;issue ENABLE_ONCE to DEVACTIVE
;	rts				;return
					;* need to determine if device
					;* currently selected is in
					;* debug or user mode.
SETPOLL bclr	#DEBUGMODE,FLAGS	;clear debug mode flag
;	move	#SAVEREG,r3		;preset save pointer
	jsr	JREADSB
	clr	b
	move	JTAGDATA,b1
	move	#>$f000,y1
	move	#>$d000,y0
	rep	#8
	lsr	b
	and	y1,b			;mask out garbage
	move	b1,x0
	move	#0,x1
 
	cmp	y0,b			;if in debug mode set debugmode flag
	.IF	<EQ>
	bset	#DEBUGMODE,FLAGS
;	jsr	USRDEL
	.ELSE
	bclr	#DEBUGMODE,FLAGS
;	jsr	USRADD
	.ENDI
	
SETPOL1 rts

;*******************************************************************
;	JTAG FORCE RESET SINGLE DEVICE TO DEBUG MODE (31)
;	This command forces the target to the debug mode of operation
;	after asserting the reset pin.	
;
;	If it receives an argument of 0 it will force the
;	target to the user mode from reset.
;
;	If it receives an argument of 1 it will force the reset pin,
;	then assert the DE pin, wait for a deassert byte, then
;	deassert the DE pin, followed by a reset of the jtag state
;	machine into the idle state.  It will also turn power on to the
;	part prior to exiting the reset state.
;
;	A byte must be sent by host to deassert the pins.
;******************************************************************
JFORCER jsr		<GETBYTE		;get argument 
	bset		#JTAGPORT,PBD		;insure pal is ready for trst
	move		y0,b			;check if toggle to user mode
;*******ASSERT RESET ON TARGET******************
	bset	#ORESET,PCD
	bclr		#DEBUGREQ,PCD		;pull DEBUG REQ low
	rep		#$ff			;wait
	tst		b			;do something
	bset		#DEBUGREQ,PCD		;pull DEBUG REQ high
	tst	b
	jeq	WAITBNJR
	jset		#2,DEVICE,HAWK_NJR	  ;hawk needs special handling
	move	#JRESET_IDL,b1
	jsr	TMSTOGGLE
	move	#DEBUG_R,a
	move	a,ACTIVECMD
	move	a,INACTIVECMD
	jsr	JISSUE2
	jsr		<GETBYTE		;wait for deassert signal
	bclr	#ORESET,PCD
	move	#E_ONCE,a
	move	a,ACTIVECMD
	jsr	JISSUE

POLLNJR jsr	JREADSB
SETFNJR bset		#DEBUGMODE,FLAGS	;set debug mode flag
	bclr		#OnCEREQ,FLAGS
	move	#0,b
	move	b,USRLIST
	jsr	USRDEL
	rts
;******TURN POWER ON TO LP16 ONCE CIRCUITS************************
LP16NJR move	#>$4,a
	move	a,y:0		       ;need to run a sequence for 16 bit
	clr	a
	move	a,y:1
	move	#>$1,a
	move	a,y:2
	jsr	<RUNSEQ		       ;go execute sequence
	rep	#20
	lsr	b
	move	b,STATVAL		;put status in memory
	jmp	<SETFNJR
	

WAITBNJR jsr	<GETBYTE		;wait for deassert signal
	move	#JRESET_IDL,b1
	jsr	TMSTOGGLE
	bclr	#ORESET,PCD
	move	#E_ONCE,a1
	move	a1,ACTIVECMD
	jsr	JISSUE
	jsr	JREADSB
	bclr	#DEBUGMODE,FLAGS	;clear debug mode flag
	jsr	USRADD
	rts
;*******RESET JTAG STATE MACHINE AND PUT IN IDLE STATE *******************
HAWK_NJR  bclr	#DEBUGREQ,PCD		     ;assert treset pin
	rep	#$100
	nop
	bset	#DEBUGREQ,PCD		   ;deassert treset pin
	jsr	<GETBYTE		;wait for deassert signal
	move	#E_ONCE,a1
	move	a1,ACTIVECMD
	jsr	JISSUE
;	 bclr	 #ORESET,PCD		;deassert reset pin
	move	#JRESET_SIR,b1		;reset jtag to shift-ir state.
	jsr	<TMSTOGGLE
;*******SEND DEBUG_REQUEST JTAG COMMAND******************
	move	#DEBUG_R,a
	jsr	<XFERDAT		;go send DEBUG_REQUEST command
	jsr	<GOIDLE
;*******SEND ENABLE_ONCE JTAG COMMAND******************
	move	#IDLE_SIR,b1	      ; machine to shift-ir state.
	jsr	<TMSTOGGLE
	move	#E_ONCE,a
	jsr	<XFERDAT	       ;go send command
	jsr	<GOIDLE
;******TURN POWER ON TO HAWK ONCE CIRCUITS************************
	move	#>$204,a		;if not set up for hawk
PWRNJR	 move	a,y:0			;need to run a sequence for 16 bit
	move	#>$C00000,a		;set bits for cop-dis,de-enab,pw-up
PWRNJR1	 move	a,y:1
	move	#>$1,a
	move	a,y:2
	jsr	<RUNSEQ			;go execute sequence
	jmp	<SETFNJR	       ;reset flags

; POLLON (32)
POLLON	bclr	#H_BRK,PCD		;clear HOST_BRK bit
	bclr	#OnCEREQ,FLAGS		;clear ack flag
	bset	#POLLENABLE,FLAG2	;set polling enable flag
	rts

; POLLOFF (33)
POLLOFF bset	#H_BRK,PCD		;set HOST_BRK bit
	bclr	#POLLENABLE,FLAG2	;clear polling enable flag
	rts

;****************************************************************
; JIRLEN (34) - Set JTAG Instruction Register Length
;   arguments: TMS# (0 or 1)
;              CHAIN_POS (1 to 24)
;              LENGTH (2 to 255)
;              NOT_DSP 0=MOTOROLA_DSP 1=OTHER
;****************************************************************
JIRLEN	jsr	GETBYTE			;fetch TMS# (discard)
	jsr	GETBYTE			;fetch CHAIN_POS
	move	y0,n5			;Save offset in n5
;	move	x:JIRTABLE,r5		;get table pointer
	move	p:JIRTABLE,r5		;get table pointer
	jsr	GETBYTE			;fetch LENGTH
	move	y0,x0			;x0 <- JIRLEN
	jsr	GETBYTE			;fetch NOT_DSP
	btst	#0,y0			;test NOT_DSP
	.IF	<CS>			;if NOT_DSP (carry set)
	bset	#23,x0			;  set high bit of x0
	.ENDI				;endif
;	move	x0,x:(r5+n5)		;save length in table
	move	x0,p:(r5+n5)		;save length in table
	rts
;****************************************************************
; CHKSERVICE (35) - Tell the host who is requesting service
;   returns:  TMS # of device
;             CHAIN_POS (1 to 24)
;****************************************************************
CHKSERVICE move	#0,x0
	move	#0,x1
	jsr	PUTLWORD		;tell host what TMS LINE (0)
	move	DEVSERVICE,a		;DEVSERVICE holds CHAIN_POS of device
	rep	#8
	lsl	a
	move	a,x0
	jsr	PUTLWORD		;tell host CHAIN_POS
	rts


;****************************************************************	
RDOS	;jsr	TOGTRST			;toggle trst pin
	move	#JRESET_IDL,b
	jsr	TMSTOGGLE
	move	#BYPASS,a
	move	a,ACTIVECMD
	jsr	JISSUE
	move	#EXIT_IDLE,b
	jsr	TMSTOGGLE
	jmp	START1

TRTST	jsr	TOGTRST
	move	#JRESET_IDL,b
	jsr	TMSTOGGLE
	jsr	JREADSB
	move	#DEBUG_R,a
	move	a,ACTIVECMD
	jsr	JISSUE
	jmp	RDOS
	
ENDCMD	equ		*
;****************************************************************
;	OnCE Instruction Sequences
;
;	Instruction sequences are defined as commands to the
;	OnCE controller as well as target opcodes and operands
;	used to transfer data.	All commands and opcodes/operands
;	are stored in the upper 16 bits of y memory.  The lower
;	8 bits are used to control the flow of the sequence.
;
;	The lower byte is defined as follows:
;	Data Value	Action
;
;	 0	No Action
;	 1	End of sequence
;	 2	send command, wait for ack, clock in data
;	 4	send command, wait for ack, clock out data, wait for ack.
;	 8	send command, wait for ack.
;	10	send command, wait for ack, clock out data
;
;	X memory is the result storage area for command sequences.
;	All read results from the OnCE port are stored sequentially
;	with the upper 16 bits stored first in the upper 16 bits of
;	the memory location and the lower 16 bits stored in the
;	upper 16 bits of the next memory location.  All results are
;	32 bits long.
;
;	Only commands to the OnCE controller have non-zero values in the
;	lower byte in the sequence RAM and is always tested to know if
;	8 bits are to be sent to the OnCE port.
;**************************************************************************
	nolist
	include "56300.seq" 
	include "56800.seq" 
	include "56600.seq"
	list

TABLE1		equ	*
	bsc	38,0		;room for future expansion
TABLE2		equ	*
	bsc	38,0		;room for future expansion
TABLE3		equ	*
	bsc	38,0		;room for future expansion
TABLE4		equ	*
	section sec56k3
;**********************************************************************
;	56300 TABLE OFFSETS TO OnCE SEQUENCES
;	Added additional entries to table for 56300 OnCE register reads/writes
;**********************************************************************
RPLOOP	   dc	PRDLOOP	;offset to execute read p opcode
RXLOOP	   dc	XRDLOOP	;offset to execute read x opcode
RYLOOP	   dc	YRDLOOP	;offset to execute read y opcode
WLOOP1	   dc	PWDLOOP ;offset to execute write opcode
WPLOOP	   dc	PWRLOOP ;offset to execute pmem write opcode
WXLOOP	   dc	XWRLOOP ;offset to execute xmem write opcode
WYLOOP	   dc	YWRLOOP ;offset to execute ymem write opcode
GETREG	   dc	SEC56K3			;offset to read program register opcode
PUTREG	   dc	PUTPREG	;offset to write program register opcode
OGETREG	   dc	GETOREG	;offset to read OnCE registers
OPIPE	   dc	PIPE	     ;offset to read OnCE Pipe regs.
OPUTREG	   dc	PUTOREG	;offset to write OnCE registers
REGRDSEQ   dc	REGREAD	;offset to reg read command
REGWRSEQ   dc	REGWRITE ;offset to reg write command
PREADSEQ   dc	OPREAD	    ;offset to p read command
XREADSEQ   dc	OXREAD	      ;offset to x read command
YREADSEQ   dc	OYREAD	      ;offset to y read command
PWRITSEQ   dc	OPWRITE	;offset to p write command
XWRITSEQ   dc	OXWRITE	;offset to x write command
YWRITSEQ   dc	OYWRITE	   ;offset to y write command
GOSEQ	   dc	USERMODE  ;offset to go command sequence
REPSEQ	   dc	PWDLOOP	;offset to repeat loop for block writes
RESTORE	   dc	RESTOREX0 ;offset to restore x0,r0,m0
RSAVE	   dc	SAVEX0	      ;offset to save r0,m0 regs.
RESTORBPMR	dc	0		;offset to restore x0,r0,m0,bpmrl,bpmrh
RSAVEBPMR	dc	0		;offset to save x0,r0,m0,bpmrl,bpmrh
GOSEQ2	   dc	USERMODE

;*******************************************************************
;	OFFSETS FOR 24 bit OnCE SEQUENCES
;*******************************************************************
OFFSET		dc     PREADPTR-OPREAD	;offset in y mem for mem read/write addr
WVOFFSET	dc     PWRITVAL-OPWRITE	;offset in y mem for mem write value
WLOOP		dc     PWRLOOP-OPWRITE	;offset in y mem for write loop
WLOOPVAL	dc     PWRITVAL-PWRLOOP	;offset in y mem for write loop value
LOCREGVAL	dc     REGVAL-REGWRITE	;offset in y mem for reg. write value
X0VAL1		dc     X0VAL-RESTOREX0	;offset in y mem for return r1 value
R0VAL1		dc     R0VAL-RESTOREX0	;offset in y mem for return r0 value
M0VAL1		dc     M0VAL-RESTOREX0	;offset in y mem for return m0 value
PWWLOOP1	dc	PWLOOP-OPWRITE	;offset in y mem for p block write loop
XWWLOOP1	dc	XWLOOP-OXWRITE	;offset in y mem for x block write loop
YWWLOOP1	dc	YWLOOP-OYWRITE	;offset in y mem for y block write loop 
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
	endsec			;end of sec56k3
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

TABLE5		equ	*
	bsc	38,0		;room for future expansion
TABLE6		equ	*
	section sec56800
;**********************************************************************
;	56800 TABLE OFFSETS TO OnCE SEQUENCES
;**********************************************************************
RPLOOP	   dc  PRDLOOP	 ;offset to execute pmem read opcode
RXLOOP	   dc  XRDLOOP ;offset to execute xmem read opcode
RYLOOP	   dc  0  ;dummy location to keep all tables the same
WLOOP1	   dc  0  ;dummy location to keep all tables the same
WPLOOP	   dc  PWRLOOP ;offset to execute pmem write opcode
WXLOOP	   dc  XWRLOOP ;offset to execute xmem write opcode
WYLOOP	   dc  0  ;dummy location to keep all tables the same
GETREG	   dc	SEC56800       ;offset to read program register opcode
PUTREG	   dc  PUTPREG	;offset to write program register opcode
OGETREG	   dc  GETOREG	;offset to read OnCE registers
OPIPE	   dc  PIPE	;offset to read OnCE Pipe regs.
OPUTREG	   dc  PUTOREG	;offset to write OnCE registers
REGRDSEQ   dc  REGREAD	;offset to reg read command
REGWRSEQ   dc  REGWRITE ;offset to reg write command
PREADSEQ   dc  OPREAD	;offset to p read command
XREADSEQ   dc  OXREAD	;offset to x read command
YREADSEQ   dc	0	;dummy location to keep all tables the same
PWRITSEQ   dc  OPWRITE	;offset to p write command
XWRITSEQ   dc  OXWRITE	;offset to x write command
YWRITSEQ   dc	0	;dummy location to keep all tables the same
GOSEQ	   dc  USERMODE1	;offset to go command sequence
REPSEQ	   dc  MWRLOOP	;offset to repeat loop for block writes
RESTORE	   dc  RESTOREX0 ;offset to restore x0,r0,m0
RSAVE	   dc  SAVEX0	;offset to save x0,r0,m0 regs.
RESTORBPMR	dc	0	;offset to restore x0,r0,m0,bpmrl,bpmrh
RSAVEBPMR	dc	0	;offset to save x0,r0,m0,bpmrl,bpmrh
GOSEQ2	   dc	USERMODE2

;*******************************************************************
;	OFFSETS FOR 16 bit OnCE SEQUENCES
;*******************************************************************
OFFSET		dc     PREADPTR-OPREAD	;offset in y mem for mem read/write addr
WVOFFSET	dc     PWRITVAL-OPWRITE	;offset in y mem for mem write value
WLOOP		dc     PWRLOOP-OPWRITE	;offset in y mem for write loop
WLOOPVAL	dc     PWRITVAL-PWRLOOP	;offset in y mem for write loop value
LOCREGVAL	dc     REGVAL-REGWRITE	;offset in y mem for reg. write value
X0VAL1		dc     X0VAL-RESTOREX0	;offset in y mem for return r1 value
R0VAL1		dc     R0VAL-RESTOREX0	;offset in y mem for return r0 value
M0VAL1		dc     0		;offset in y mem for return m0 value
PWWLOOP1	dc	PWLOOP-OPWRITE	;offset in y mem for p block write loop
XWWLOOP1	dc	XWLOOP-OXWRITE	;offset in y mem for x block write loop
YWWLOOP1	dc	XWLOOP-OXWRITE	;note: no y mem on this part
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
	endsec		;end of sec56800
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

TABLE7		equ	*
	section sec56k6
;**********************************************************************
;	56600 TABLE OFFSETS TO OnCE SEQUENCES
;**********************************************************************
RPLOOP		dc	PRDLOOP		;offset to execute pmem read opcode
RXLOOP		dc	XRDLOOP		;offset to execute xmem read opcode
RYLOOP		dc	YRDLOOP		;dummy to keep all tables the same
WLOOP1		dc	PWDLOOP		;dummy to keep all tables the same
WPLOOP		dc	PWRLOOP		;offset to execute pmem write opcode
WXLOOP		dc	XWRLOOP		;offset to execute xmem write opcode
WYLOOP		dc	YWRLOOP		;dummy, to keep all tables the same
GETREG		dc	SEC56K6		;offset to read program register opcode
PUTREG		dc	PUTPREG		;offset to write program register opcode
OGETREG		dc	GETOREG		;offset to read OnCE registers
OPIPE		dc	PIPE		;offset to read OnCE Pipe regs.
OPUTREG		dc	PUTOREG		;offset to write OnCE registers
REGRDSEQ	dc	REGREAD		;offset to reg read command
REGWRSEQ	dc	REGWRITE	;offset to reg write command
PREADSEQ	dc	OPREAD		;offset to p read command
XREADSEQ	dc	OXREAD		;offset to x read command
YREADSEQ	dc	OYREAD		;dummy, to keep all tables the same
PWRITSEQ	dc	OPWRITE		;offset to p write command
XWRITSEQ	dc	OXWRITE		;offset to x write command
YWRITSEQ	dc	OYWRITE		;dummy, to keep all tables the same
GOSEQ		dc	USERMODE	;offset to go command sequence
REPSEQ		dc	PWDLOOP		;offset to repeat loop for block writes
RESTORE		dc	RESTOREX0	;offset to restore x0,r0,m0
RSAVE		dc	SAVEX0		;offset to save x0,r0,m0 regs.
RESTORBPMR	dc	RESTOR566	;offset to restore x0,r0,m0,bpmrl,bpmrh
RSAVEBPMR	dc	SAVE5660	;offset to save x0,r0,m0,bpmrl,bpmrh
GOSEQ2	   dc	USERMODE
;*******************************************************************
;	OFFSETS FOR 24 bit OnCE SEQUENCES
;*******************************************************************
OFFSET		dc     PREADPTR-OPREAD	;offset in y mem for mem read/write addr
WVOFFSET	dc     PWRITVAL-OPWRITE	;offset in y mem for mem write value
WLOOP		dc     PWRLOOP-OPWRITE	;offset in y mem for write loop
WLOOPVAL	dc     PWRITVAL-PWRLOOP	;offset in y mem for write loop value
LOCREGVAL	dc     REGVAL-REGWRITE	;offset in y mem for reg. write value
X0VAL1		dc     X0VAL-RESTOREX0	;offset in y mem for return r1 value
R0VAL1		dc     R0VAL-RESTOREX0	;offset in y mem for return r0 value
M0VAL1		dc     M0VAL-RESTOREX0	;offset in y mem for return m0 value
PWWLOOP1	dc     PWLOOP-OPWRITE	;offset in y mem for p block write loop
XWWLOOP1	dc     XWLOOP-OXWRITE	;offset in y mem for x block write loop
YWWLOOP1	dc     YWLOOP-OYWRITE	;note: no y mem on this part
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
	endsec		;end of sec56k6
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;********************************************************************
;	FOLLOWING ARE THE TABLE ADDRESSES FOR THE ADM COMMANDS
;********************************************************************
OVLYTABL	equ	*
	dc		GOCMD		;command 10
	dc		GODELAY		;command 11
	dc		PREAD		;command 12
	dc		PWRITE		;command 13
	dc		XREAD		;command 14
	dc		XWRITE		;command 15
	dc		YREAD		;command 16
	dc		YWRITE		;command 17
	dc		REG_RD		;command 18
	dc		REG_WR		;command 19
	dc		P1WRITE		;command 1a
	dc		X1WRITE		;command 1b
	dc		Y1WRITE		;command 1c
	dc		OREG_RD		;command 1d
	dc		OREG_WR		;command 1e
	dc		SEQTRACE	;command 1f
	dc		SEQEXEC		;command 20
	dc		SAV_PIPE	;command 21
	dc		SEQREAD		;command 22
	dc		SEQWRITE	;command 23
	dc		MISC_RD		;command 24
	dc		MISC_WR		;command 25
	dc		FORCER		;command 26
	dc		FORCEB		;command 27
	dc		EXOVERLAY	;command 28
	dc		JRESET		;command 29
	dc		JBREAK		;command 2a
	dc		TARGET_R	;command 2b
	dc		JGOCMD		;command 2c
	dc		RFIFOCMD	;command 2d
	dc		POLLCMD		;command 2e
	dc		JTAGCNT		;command 2f
	dc		SETACTV		;command 30
	dc		TARGET_R	;command 31 (possible single target)
	dc		POLLON		;command 32
	dc		POLLOFF		;command 33
	dc		JIRLEN		;command 34
	dc		CHKSERVICE	;command 35
;******************************************************************

OVLYTABL1	equ	*
LASTCOMMAND	dc	OVLYTABL1-OVLYTABL+$10
TABLESIZ	dc	(TABLE2-TABLE1)		;all jump tables are same size
JTABLSZ		dc	OVLYTABL1-OVLYTABL	;command jump table size

TABLE8		equ	*

	dc		TABLE1		;future expansion
	dc		TABLE2		;future expansion
	dc		TABLE3		;future expansion
	dc		TABLE4		;56300
	dc		TABLE5		;future expansion
	dc		TABLE6		;56800
	dc		0		;future expansion
	dc		0		;future expansion
	dc		TABLE7		;56600
	dc		OVLYTABL

ENDROM		equ	*

	end				;end of program
;**********************************************************************
;	COPYRIGHT MOTOROLA 1990,1991,1992,1993,1994,1995,1996
;**********************************************************************
