/*

Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler, Saleem Marwat, and Brian Evans
Version: @(#)StateButtons.java	1.9  04/17/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

package utexas.espl.weds.ui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// Provides a set of buttons to display various states
public class StateButtons extends JPanel implements ActionListener {
    private JButton regButton;
    //private Button simRegButton;
    private MainWindow mainWindow;
    private RegisterWindow prevRegWindow;
    private RegisterWindow currRegWindow;
    private Simulator simulator;
    private String oldRegisterValues;

    // Constructor
    public StateButtons(MainWindow f, RegisterWindow prw,
                        RegisterWindow crw, Simulator sim) {
        mainWindow = f;
        prevRegWindow = prw;
        currRegWindow = crw;
        simulator = sim;
        oldRegisterValues = new String( simulator.processorState() );
        setLayout( new FlowLayout() );
        regButton = new JButton( "Register Values" );
        regButton.setActionCommand("values");
        regButton.addActionListener(this);
        add( regButton );
    }

    // Handle events
    public void actionPerformed( ActionEvent e ) {
        if ( e.getActionCommand().equals("values") ) {
            prevRegWindow.setText( currRegWindow.getText() );
            String result = new String( simulator.processorState() );
            currRegWindow.setAndFormatText(oldRegisterValues, result);
            oldRegisterValues = new String(result);
        }
    }
}
