/*

Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler, Saleem Marwat, and Brian Evans
Version: @(#)StarterApplet.java	1.11  04/17/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

/* Starter Applet */

package utexas.espl.weds.ui;

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import javax.swing.*;

// Applet to launch the Main Window of the user-interface
public class StarterApplet extends JApplet implements ActionListener {

    private SimButtons frame;
    private JButton showFrame;

    public void init() {
      Container contentPane = getContentPane();
      String title = "Web Enabled Simulators";
      showFrame = new JButton(title);
      showFrame.setActionCommand("start");
      showFrame.addActionListener( this );
      contentPane.add( showFrame, BorderLayout.CENTER );
    }

    public void actionPerformed( ActionEvent e ) {
      if (e.getActionCommand().equals("start")) {
        String title = "Web Enabled Simulators";
        frame = new SimButtons(title, showFrame, getBaseURL());
        frame.setResizable( false );
        //frame.show();
        disableButton();
      }
    }

    public boolean disableButton() {
        showFrame.setEnabled( false );
        return true;
    }

    public boolean enableButton() {
        showFrame.setEnabled( true );
        return true;
    }

    public void destroy () {
        if (frame != null) {
            frame.destroy();
        }
    }

    public String getBaseURL() {
      URL base = getCodeBase();
      // FIXME: JDK 1.3 has a method getPath()
      String szBase = base.toString();
      int last = szBase.lastIndexOf('/');
      String szPath = szBase.substring(0, last);
      return szPath;
    }
}
