/*

Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler, Saleem Marwat, and Brian Evans
Version: @(#)SimStateButtons.java	1.6  04/17/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

package utexas.espl.weds.ui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// Provides a set of buttons to display various states
public class SimStateButtons extends JPanel implements ActionListener {
    private JButton simRegButton;
    private Simulator simulator;
    private MainWindow mainWindow;
    private StateWindow frame;

    // Constructor
    public SimStateButtons(MainWindow f, Simulator sim) {
        mainWindow = f;
        simulator = sim;
        simRegButton = new JButton( "Simulator State" );
        simRegButton.setActionCommand("state");
        simRegButton.addActionListener(this);
        add( simRegButton );
    }

    // Handle events
    public void actionPerformed( ActionEvent e ) {
        if ( e.getActionCommand().equals("state")) {
            frame = new StateWindow(mainWindow, "Simulator State", simulator);
        }
    }
}
