/*

Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler, Brian L. Evans, Jun Huang, and Saleem K. Marwat
Version: @(#)SimButtons.java	1.20  05/03/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

This code is derived from StarterApplet.java.

*/

package utexas.espl.weds.ui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// This frame contains buttons for all the simulators
public class SimButtons extends JFrame implements ActionListener {
  final boolean _DEBUG = false;
  private JButton appletButton;
  private JRadioButton[] simChoice;
  private ButtonGroup group;
  private JButton next;
  private String[] simulatorDescriptions;
  private String[] simulatorNames;
  private int numSimulators = -1;
  Simulator dummySim;
  String serverURL = null;
  String ipAddress = null;

  final int MAIN_WINDOW_HEIGHT = 800;
  final int MAIN_WINDOW_WIDTH =  700;

  String id, password;

  public SimButtons(String windowTitle, JButton button, String baseURL) {
    super(windowTitle);
    appletButton = button;
    WedsConfig config = new WedsConfig(baseURL);
    serverURL = config.getURL();
    ipAddress = config.getServer();

    // Find the actual number of simulators from the Simulator server
    dummySim = new Simulator(ipAddress, baseURL);
    numSimulators = dummySim.numberOfSimulators();
    if (_DEBUG) {
      System.out.println(numSimulators);
    }
    Container contentPane = getContentPane();
    contentPane.setLayout(new BorderLayout());
    JPanel top = new JPanel();
    top.setBorder(
      BorderFactory.createTitledBorder("Please select to start"));
    JPanel bottom = new JPanel();
    next = new JButton("Next >>");
    bottom.add(next);
    next.setActionCommand("next");
    next.addActionListener(this);

    top.setLayout(new GridLayout(numSimulators,1));

    // Build the menu of available simulators
    group = new ButtonGroup();
    simChoice = new JRadioButton[numSimulators];
    simulatorDescriptions = new String[numSimulators];
    simulatorNames = new String[numSimulators];
    int simId;
    for (simId = 0; simId < numSimulators; simId++) {
      String simName = new String(dummySim.name(simId));
      System.out.println("simName="+simName);
      simulatorNames[simId] = simName;
      String simDesc = new String(dummySim.description(simId));
      simulatorDescriptions[simId] = simDesc;
      String label = simDesc;
      simChoice[simId] = new JRadioButton(label);
      top.add( simChoice[simId] );
      group.add( simChoice[simId] );
      simChoice[simId].setActionCommand(String.valueOf(simId));
    }
    simChoice[0].setSelected(true);
    contentPane.add("North", top);
    contentPane.add("South", bottom);

    addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
              appletButton.setEnabled( true );
              destroy();
            }
        });

    pack();
    show();

    dummySim.terminate();
  }

  private int eventToSimulatorId( ActionEvent e ) {
    int simId;
    for (simId = 0; simId < numSimulators; simId++) {
      if (group.getSelection().getActionCommand().equals( String.valueOf(simId) ))
        return simId;
    }
    return -1;
  }

  public void actionPerformed( ActionEvent e ) {
    if (e.getActionCommand().equals("next")) {
      int simId = eventToSimulatorId( e );
      if ( simId < 0 ) return;

      String name = new String(simulatorNames[simId]);
      String desc = new String(simulatorDescriptions[simId]);
      String s = new String("UT Austin Web-Enabled " + desc);
      MainWindow mainWindow = new MainWindow( name, s, serverURL, ipAddress );
      mainWindow.setSize( MAIN_WINDOW_HEIGHT, MAIN_WINDOW_WIDTH );
      mainWindow.setResizable( false );
      if (mainWindow.connectFlag()) {
        mainWindow.show();
      }
      else {
        System.out.println("Boards are all in use");
        JOptionPane.showMessageDialog(this, "All boards are in use", "Warning",
                  JOptionPane.WARNING_MESSAGE);
      }
    }
  }

  public boolean destroy () {
    hide();
    dispose();
    return true;
  }
}
