/*
Freely Distributable Java Applets

Copyright (c) 1996-2001 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Author: Dogu Arifler, Brian L. Evans, Jun Huang and Saleem K. Marwat
Version: @(#)MainWindow.java	1.26  05/05/01

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084
*/

/* Frame containing the GUI */

package utexas.espl.weds.ui;

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;

public class MainWindow extends JFrame implements ActionListener {
    private Menu fileMenu;
    private Menu helpMenu;
    private Menu indexMenu;
    private MenuBar menuBar;
    private MenuItem fileLoad;
    private MenuItem fileInfo;
    private MenuItem fileExit;
    private MenuItem helpAboutSimulator;
    private MenuItem[] indexMenuItem;

    private CommandMenu commandMenu;
    private CommandWindow commandWindow;
    private ImButtons iButtons;
    private LoadFile loadFileWindow;
    private RegisterWindow prevRegWindow;
    private RegisterWindow currRegWindow;
    private ResponseWindow responseWindow;
    private SimStateButtons simStateButtons;
    private Simulator simulator = null;
    private StateButtons stateButtons;

    private String url;
    private String simulatorInformation;
    private boolean DEBUG = false;

    final String DEBUG_MENU_ITEM_NAME = "Debug";
    final String EXIT_MENU_ITEM_NAME =  "Exit";
    final String INFO_MENU_ITEM_NAME =  "About WEDS";
    final String LOAD_MENU_ITEM_NAME =  "Load";
    final String STEP_MENU_ITEM_NAME =  "Step";

    final int GAP = 10;       // gap between components
    final String WEDS_INFO = "The University of Texas at Austin Web-Enabled " +
      "Simulation Version 1.3.0\nCopyright (c) 1996-2001 " +
      "The University of Texas.  All Rights Reserved.\n" +
      "Released as freely distributable software under the GNU license.\n" +
      "Authored by Dogu Arifler, Brian Evans, Jun Huang, and Saleem Marwat.";

    // Constructor
    public MainWindow( String simulatorName, String windowTitle,
                       String serverURL, String ipAddr ){
        super( windowTitle );
        url = new String(serverURL);

        // Arrange components in the window
        Container contentPane = getContentPane();
        contentPane.setLayout( new BorderLayout( GAP, GAP ) );
        placeMenus();

        commandWindow = new CommandWindow( 10, 32 );  // Allocate windows

        responseWindow = new ResponseWindow( 10, 32 );

        currRegWindow = new RegisterWindow( "Current Registers" );

        prevRegWindow = new RegisterWindow( "Previous Registers" );

        JPanel lowerLeft = new JPanel();                // Allocate subwindows
        lowerLeft.setLayout( new BorderLayout( GAP, GAP ) );
        lowerLeft.add( "Center", currRegWindow );
        JPanel lowerRight = new JPanel();
        lowerRight.setLayout( new BorderLayout( GAP, GAP ) );
        lowerRight.add( "Center", prevRegWindow );

        JPanel upperLeft = new JPanel();
        upperLeft.setLayout( new BorderLayout( GAP, GAP ) );
        upperLeft.add( "Center", commandWindow );
        // HACK: (Cosmetic) To prevent the component from taking up all available space
        upperLeft.add( "North", new JLabel(" "));
        JPanel upperRight = new JPanel();
        upperRight.setLayout( new BorderLayout( GAP, GAP ) );
        upperRight.add( "Center", responseWindow );
        // HACK: (Cosmetic) To prevent the component from taking up all available space
        upperRight.add( "North", new JLabel(" "));

        JPanel comResWins = new JPanel();   // Place windows
        comResWins.setLayout( new GridLayout( 2, 2, GAP, GAP) );
        comResWins.add( upperLeft );
        comResWins.add( upperRight );
        comResWins.add( lowerLeft );
        comResWins.add( lowerRight );

        String listOfCommands = null;
        String gifURL = url + "/gif";

        // Open connection to simulator
        simulator = new Simulator( ipAddr, simulatorName, url );
        if (simulator.connectFlag() == false) {
          return;
        }
        listOfCommands = simulator.listOfCommands();
        simulatorInformation = simulator.version();
        iButtons = new ImButtons( this, commandWindow, responseWindow,
                                  gifURL, simulator );

        // Add the processor state and simulator state buttons
        stateButtons = new StateButtons( this, prevRegWindow,
                                         currRegWindow, simulator );
        simStateButtons = new SimStateButtons( this, simulator );
        lowerLeft.add( "North", stateButtons );
        lowerRight.add( "North", simStateButtons );

        // Display a menu of commands supported by the simulator
        commandMenu = new CommandMenu( listOfCommands );

        // Copy the commands in the Command menu to the Help menu
        int itemCount = commandMenu.getItemCount();
        indexMenuItem = new MenuItem[itemCount];
        for (int i = 0; i < itemCount; i++) {
            indexMenuItem[i] = new MenuItem( commandMenu.getItem(i) );
            indexMenuItem[i].addActionListener(this);
            indexMenu.add( indexMenuItem[i] );
        }

        commandMenu.getList().addActionListener(this);

        // Add the buttons across the top of the screen
        contentPane.add( "North", iButtons );
        contentPane.add( "Center", comResWins );
        contentPane.add( "West", commandMenu );

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                exitWindow();
            }
        });
    }

    public boolean exitWindow() {
      if (simulator == null) {
        System.out.println("Simulator="+"output null");
      }
      else {
        simulator.terminate();
        simulator = null;
      }
      hide();
      dispose();
      return true;
    }

    public boolean connectFlag(){
      boolean connectflag = false;
      if ( simulator != null ) {
        connectflag = simulator.connectFlag();
      }
      return connectflag;
    }

    private void placeMenus() {
        // Set the menu bar
        menuBar = new MenuBar();
        // Set the menus
        fileMenu = new Menu( "File" );
        indexMenu = new Menu( "Index" );
        helpMenu = new Menu( "Help" );
        // Put items in menus
        fileLoad = new MenuItem( LOAD_MENU_ITEM_NAME );
        fileLoad.setActionCommand(LOAD_MENU_ITEM_NAME);
        fileLoad.addActionListener(this);
        fileInfo = new MenuItem( INFO_MENU_ITEM_NAME );
        fileInfo.setActionCommand(INFO_MENU_ITEM_NAME);
        fileInfo.addActionListener(this);
        fileExit = new MenuItem( EXIT_MENU_ITEM_NAME );
        fileExit.setActionCommand( EXIT_MENU_ITEM_NAME );
        fileExit.addActionListener(this);

        helpAboutSimulator = new MenuItem( "About the GUI" );
        fileMenu.add( fileLoad );
        helpMenu.add( fileInfo );
        fileMenu.addSeparator();
        fileMenu.add( fileExit );
        menuBar.setHelpMenu( helpMenu );
        menuBar.add( fileMenu );
        menuBar.add( indexMenu );
        menuBar.add( helpMenu );
        setMenuBar( menuBar );
    }

    public void actionPerformed( ActionEvent e ) {
        if (e.getSource() instanceof MenuItem) {
          if (e.getActionCommand().equals(EXIT_MENU_ITEM_NAME)) {
            exitWindow();
            return;
          }
          else if (e.getActionCommand().equals(LOAD_MENU_ITEM_NAME)) {
            loadFileWindow = new LoadFile(this, simulator);
            return;
          }
          else if (e.getActionCommand().equals(STEP_MENU_ITEM_NAME)) return;
          else if (e.getActionCommand().equals(DEBUG_MENU_ITEM_NAME)) return;
          else if (e.getActionCommand().equals(INFO_MENU_ITEM_NAME)) {
            String info = new String( WEDS_INFO + "\n\n" + simulatorInformation );
            JOptionPane.showMessageDialog(this, info, "About WEDS", JOptionPane.INFORMATION_MESSAGE);
          }
          else {
            String result = null;
            MenuItem item = (MenuItem)e.getSource();
            result = new String(simulator.helpOnTopic(item.getLabel()));
            JOptionPane.showMessageDialog(this, result,
              "Help about " + item.getLabel(), JOptionPane.INFORMATION_MESSAGE);
            }
          }
        if (e.getSource() instanceof List) {
            String selectedCommand = ((java.awt.List)e.getSource()).getSelectedItem();
            commandWindow.appendText(selectedCommand + "\n");
        }
    }
}

