;************************************************************************
;*  The following program is an example file for the 320C30 SWDS.
;*  The program is written to be loaded into 320C30 internal memory
;*  and tests the 320C30 external memory
;*
;*  The file can be assembled with the 320C30 assembler and then linked
;*  with  the 320C30 linker.  The COFF file generated by the linker
;*  can then be loaded into the 320C30 SWDS using the 320C30/XDS Emulator
;*
;*  Program Flow:
;*  -Set 320C30 to run with zero wait states
;*  -Intialize Dual Port Ram semaphore registers
;*  -Test Dual Port Ram memory, hold test status
;*  -Clear block of dual port space to hold test status
;*  -Write dual port test status to dual port ram
;*  -Do walking '1' data test on external ram, save test status
;*  -Do walking '0' data test on external ram, save test status
;*  -Do basic read/write test on external ram, save test status
;*  -Do walking '1' data test on i/o ram, save test status
;*  -Do walking '0' data test on i/o ram, save test status
;*  -Do basic read/write test on i/o ram, save test status
;*  -Write '7' to dual port ram address 0x000 indicating that
;*   the test is complete.
;*
;*
;*
;*   Assemble File
;*   ===============
;*   To assemble this file enter:  asm30 c30exam -l -s	<CR>
;*   This will assemble the file, create a listing and produce complete
;*   symbol table
;*
;*   Link File
;*   =========
;*   To link the object file enter: lnk30 c30exam.cmd <CR>
;*   This will link c30exam.obj and create a COFF file that can be
;*   loaded with the 320C30/XDS Emulator.
;*
;*   Loading COFF File
;*   =================
;*   Enter the 320C30 emulator, type:  EMU30 <CR>
;*
;*   Reset the 320C30, type: XR <CR> <ESC>
;*
;*   Loading COFF file, type: LO
;*   at the file name prompt type: C30EXAM <CR>
;*
;*   Running the Program
;*   ===================
;*   To run the program type: X
;*   At this point you may use any of the execute commands to run the
;*   program.
;*
;*   Experiment with the program.
;*
;************************************************************************

	.global setup			;define code entry point

	.data
wait0	.word	000000f00h		;memory control reg val, parallel bus
wait1	.word	000000000h		;memory control reg val, i/o bus
cacheon .word	000001800h		;clear and enable the cache
mcntlr0 .word	000808064h		;i/o interface control reg. addr.
mcntlr1 .word	000808060h		;parallel interf. cntl. reg. addr.
stack	.word	000809bffh		;set top of stack
pram	.word	000f00000h		;sram, parallel bus base address
psize	.word	000004000h		;sram size, 16k words
ioram	.word	000800000h		;sram, i/o bus bus base address
iosize	.word	000002000h		;sram size, 8k words
dpram	.word	000804000h		;dual port ram, i/o bus address
dpsize	.word	000001000h		;dual port ram size, 4k words
dpsem	.word	000805ff8h		;dual port ram semaphore reg base
dprmsk	.word	0ffffff00h		;dual port ram data mask
r_reg	.word	000805ff7h		;control register R address
pat55	.word	055555555h		;data pattern
pataa	.word	0aaaaaaaah		;data pattern
pat01	.word	000000001h		;data pattern
patfe	.word	0fffffffeh		;data pattern
dasize	.word	32			;data word size
pasize	.word	24			;parallel bus addres size
ioasize .word	13			;i/o address size


	.text
setup:	ldi	080h,dp 		;data page internal
	ldi	@stack,sp		;set the stack pointer
	ldi	@wait0,r0		;get i/o ready setup
	ldi	@mcntlr0,ar0		;get memcntl reg address
	sti	r0,*ar0 		;set parallel ready
	ldi	@wait1,r0		;get i/o ready
	ldi	@mcntlr1,ar0		;get memcntl reg address
	sti	r0,*ar0 		;set io ready
	ldi	@cacheon,st		;load status register


	ldi	@dpsem,ar0		;get dual port semaphore address
	ldi	7,rc			;write '1' to all 8 semaphore
	ldi	1,r0			;bits
	rptb	setsem			;rptb is used instead of rpts to
setsem: sti	r0,*ar0++		;allow single step tracing

	;pattern test  dual port ram
	ldi	@dpsize,r0		;push memory size on the stack
	push	r0
	ldi	@dpram,r0		;push parallel address base on stack
	push	r0
	call	dprtst			;call dual port ramtest
	subi	2,sp			;adjust the stack
	xor	r0,r0			;set first 8 locations in the
	ldi	7,rc			;dual port ram to 0
	ldi	@dpram,ar0		;these locations will hold
	rptb	seterr			;the test error counts
seterr: sti	r0,*ar0++
	ldi	@dpram,ar2		;ar2 will hold error count position
	addi	1,ar2			;1st location reserved for test
	sti	r7,*ar2++		;write number of dpram failures
					;to the dual port ram

	;walking 1 data test on parallel data bus
	ldi	@dasize,r0		;push data bus size on the stack
	push	r0
	ldi	@pram,r0		;push parallel address base on stack
	push	r0
	call	w1data			;call walking '1' data test
	sti	r7,*ar2++		;write number of fails to dpram

	;walking 0 data test on parallel data bus
	call	w0data			;call walking '0' data test
					;note, parameters are on stack
					;from last test
	subi	2,sp			;adjust the stack
	sti	r7,*ar2++		;write number of fails to dpram

	;pattern test  parallel ram space
	ldi	@psize,r0		;push memory siz on the stack
	push	r0
	ldi	@pram,r0		;push parallel address base on stack
	push	r0
	call	pattst			;call pattern test
	sti	r7,*ar2++		;write number of fails to dpram
	subi	2,sp

	;walking 1 data test on i/o data bus
	ldi	@dasize,r0		;push data bus size on the stack
	push	r0
	ldi	@ioram,r0		;push parallel address base on stack
	push	r0
	call	w1data
	sti	r7,*ar2++		;write number of fails to dpram

	;walking 0 data test on i/o data bus
	call	w0data
	subi	2,sp
	sti	r7,*ar2++		;write number of fails to dpram

	;pattern test  io ram space
	ldi	@iosize,r0		;push ram size	on the stack
	push	r0
	ldi	@ioram,r0		;push io address base on stack
	push	r0
	call	pattst
	sti	r7,*ar2++		;write number of fails to dpram
	subi	2,sp

	ldi	@dpram,ar0		;write 7 to dual port ram address
	ldi	7,r0			;0x000 to indicate test complete
	sti	r0,*ar0
here:	br	here			;end of test routine, hold at
					;this point

;***********************************************************************
;*		 WALKING '1' DATA TEST
;***********************************************************************

w1data: ldi	sp,ar6			;use ar6 as frame pointer
	subi	1,ar6			;point to first value on stack
	ldi	*ar6,ar0		;set memory base address
	ldi	*-ar6(1),rc		;set data size
	subi	1,rc			;adjust repeat value
	ldi	@pat01,r1		;load data pattern
	xor	r7,r7			;zero r0
	rptb	wdat1			;test 32 data bits
	sti	r1,*AR0 		;store data pattern
	cmpi	r1,*AR0 		;read data pattern
	bne	w1err			;branch if good
wdat1:	lsh	1,r1			;shift the data pattern
	br	w1done			;do not set error flag
w1err:	addi	1,r7			;set error flag
w1done: rets

;***********************************************************************
;*		 WALKING '0' DATA TEST
;***********************************************************************

w0data: ldi	sp,ar6			;use ar6 as frame pointer
	subi	1,ar6			;point to first value on stack
	ldi	*ar6,ar0		;set memory base address
	ldi	*-ar6(1),rc		;set data size
	subi	1,rc			;adjust repeat value
	ldi	@patfe,r1		;load data pattern
	xor	r7,r7			;zero r0
	rptb	wdat0			;test 32 data bits
	sti	r1,*AR0 		;store data pattern
	cmpi	r1,*AR0 		;read data pattern
	bne	w0err			;branch if not good
wdat0:	rol	r1			;shift the data pattern
	br	w0done			;do not set error flag
w0err:	addi	1,r7			;set error flag
w0done: rets

;***********************************************************************
;*		 BASIC PATTERN TEST
;***********************************************************************

pattst: ldi	sp,ar6			;use ar6 as frame pointer
	subi	1,ar6			;point to first value on stack
	ldi	*ar6,ar0		;set memory base address
	ldi	*-ar6(1),rc		;set data size
	subi	1,rc			;adjust repeat value
	ldi	@patfe,r1		;load data pattern
	rptb	wrpat			;write pattern to memory
	sti	r1,*ar0++		;
wrpat:	addi	ar0,r1			;add address to the pattern
	xor	r7,r7			;clear error count
	ldi	*ar6,ar0		;set memory base address
	ldi	*-ar6(1),rc		;set data size
	subi	1,rc			;adjust repeat value
	ldi	@patfe,r1		;load data pattern
	rptb	rdpat			;read back pattern
	cmpi	r1,*ar0++		;and check
	bne	perr			;jump out if bad
rdpat:	addi	ar0,r1			;add address to data pattern
	br	pdone			;do not set error flag
perr:	addi	1,r7			;set error flag
pdone:	rets

;***********************************************************************
;*		 DUAL PORT RAM TEST
;***********************************************************************
dprtst: ldi	sp,ar6			;use ar6 as frame pointer
	subi	1,ar6			;point to first value on stack
	ldi	*ar6,ar0		;set memory base address
	ldi	*-ar6(1),rc		;set data size
	subi	1,rc			;adjust repeat value
	xor	r1,r1			;load data pattern
	not	r1			;take complement
	rptb	wrdpr			;write pattern to memory
	sti	r1,*ar0++
wrdpr:	subi	1,r1			;decrement the pattern
	xor	r7,r7			;clear error count
	ldi	*ar6,ar0		;set memory base address
	ldi	*-ar6(1),rc		;set data size
	subi	1,rc			;adjust repeat value
	xor	r1,r1			;load data pattern
	not	r1			;take complement
	ldi	@dprmsk,r2		;get mask
	rptb	rddpr
	ldi	*ar0++,r0		;read ram value
	or	r2,r1			;mask upper 24 bits
	or	r2,r0			;mask upper 24 bits
	cmpi	r0,r1			;and check
	bne	dperr			;if equal skip error increment
rddpr:	subi	1,r1			;decrement pattern
	br	dpdone			;do not set error flag
dperr:	addi	1,r7			;set the error flag
dpdone: rets
	.end

