/*************************************************************************/
/* string.h  v3.00                                                       */
/* Copyright (c) 1990 Texas Instruments Incorporated                     */
/*************************************************************************/
#ifndef _STRING
#define _STRING

#define NULL 0

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

void    *memchr(const void *_mem, int _ch, size_t _length);
int      memcmp(const void *_mem1, const void *_mem2, size_t _length);
void    *memcpy(void *_s1, const void *_s2, size_t _n);
void    *memmove(void *_s1, const void *_s2, size_t _n);
void    *memset(void *_s, int _c, size_t _n);

char    *strcat(char *_string1, const char *_string2);
char    *strchr(const char *_string, int _ch);
int      strcmp(const char *_string1, const char *_string2);
char    *strcpy(char *_to, const char *_from);
int      strcoll(const char *_string1, const char *_string2);
size_t   strcspn(const char *_string, const char *_chs);
char    *strerror(int _errno);
size_t   strlen(const char *_string);
char    *strncat(char *_to, const char *_from, size_t _n);
int      strncmp(const char *_string1, const char *_string2, size_t _n);
char    *strncpy(char *_to, const char *_from, size_t _n);
char    *strpbrk(const char *_string, const char *_chs);
char    *strrchr(const char *_string, int _ch);
size_t   strspn(const char *_string, const char *_chs);
char    *strstr(const char *_string1, const char *_string2);
char    *strtok(char *_str1, const char *_str2);
char    *strxfrm(char *_to, const char *_from, size_t _n);

#endif
