* Program examples for c2xx                          *
* PM - Program memory    DM - Data memory            *
* Command file         : c203.cmd                    *
* Assembler batch file : a.bat                       *
* Linker batch file    : l.bat                       *
* Function: Non-stop transmit in Continuous mode     *
*           Internal shift clock and frame sync      *	
*	    Transmit FIFO level is set to 4          *
* No ESSP register initialisation		     *
* Rev 2.0					     *
* CLKX = CLKOUT1/2     FSX = TX FIFO write rate      *
* Written by: Sam Saba/ASP/St,TX       Date: 7/17/97 *                   

* Variable and register declaration
SDTR	.set	0FFF0h	; SSP xmit/recieve Register, I/O space
SSPCR	.set	0FFF1h	; SSP control Register, I/O space
SSPST	.set	0FFF2h	; SSP status Register, I/O space
SSPMC	.set	0FFF3h	; SSP multi-channel Register, I/O space
SSPCT	.set	0FFFBh	; SSP pre-scalar counter Register, I/O space
WSGR	.set	0FFFCh	; SSP control Register, I/O space
RXCNT	.set	007Eh	; Receive count
ERR	.set	007Fh	; result register


	.title  " SSP Continuous mode"    ; Title 
	.copy "init.h"    	; Variable and register declaration
        .copy "vector.h"        ; Vector label declaration     
	.text

start:  clrc cnf                ; Block B0 in DM
	ldp #0h                 ; set DP=0
	setc INTM               ; Disable all interrupts
        splk #0000h, 60h        ; Set zero wait states 
        out 60h, wsgr           
        splk #0cc0ch,60h        ; reset the serial port 
	out 60h, sspcr		 
        splk #0cc3ch,60h        ; enable SSP, 4 word FIFO,
        out 60h,sspcr		; internal clocks, Continuous mode
				; Use sspcr= #0cc3eh for Burst mode
     	splk #1717h,61h		; dummy data for tx
	splk #7171h,63h		
	splk #0aa55h,64h
	splk #55aah,62h		 
        splk #0fffh,70h
	splk #10h,imr		; enable xinit interrupt
	clrc intm		; enable INTM 
	out 62h,sdtr		; Xmit once to start 
	out 61h,sdtr		; transmit interrupts
	out 63h,sdtr
	out 64h,sdtr
	
loop:   clrc xf			; clear xf flag
        idle
	b loop

codtx:	setc xf			; set xf bit
	out 62h,sdtr		; transmit 0x55aah again
        out 61h,sdtr		; transmit 1717h 
        out 63h,sdtr		; tranxmit 7171h
        out 64h,sdtr		; transmit aa55h
        splk #0010h, ifr	; clear ifr flag
        call delay
        clrc intm
        ret

delay   rpt 70h			; delay loop
        nop
        rpt 70h
        nop
        ret

codrx:  ret
inpt1: 	ret
inpt23:	ret
time:  	ret
uart:  	ret	
	.end                    ; Assembler module end directive

* Notes: This program sends out data through the DX pin
* of the SSP. No loopback involved. The XF pin will toggle
* if this program works correctly.
