* Program examples for c2xx                          *
* PM - Program memory    DM - Data memory            *
* Command file         : c203.cmd                    *
* Assembler batch file : a.bat                       *
* Linker batch file    : l.bat                       *
* Function: Continuous transmit                      *
*           MODE - Burst mode                        *
*           CLKX - EXTERNAL                          *
*           FSX  - EXTERNAL                          *
*	    CLKXOX -0 selects CLKOUT1 as             *
*           the input to the counter                 *

*	    CLKXOX -1 selects CLKX as                *
*           the input to the counter                 *
* Check : Timer using FSXCT/CLXCT                    *                                                    
*	  Polls FSXST for every  transmit            * 
* Rev 2.0                                            *
* Written by: Sam Saba/ASP/St,TX       Date: 7/17/97 *

        .title  " ESSP Burst mode"    ; Title 
	.copy "init.h"    	; Variable and register declaration
        .copy "vector.h"        ; Vector label declaration     
	.text

start:
	CLRC CNF                ; Block B0 in DM, as CNFD
	LDP #0h                 ; set DP=0
	SETC INTM               ; Disable all interrupts
	splk #0000h,60h		; I/O wait states =zero
        out 60h, wsgr
        splk #0cf02h,60h        ; reset the serial port by writing
	out 60h, sspcr		; zeros at NOR/RES,  
        splk #0cf32h,60h
        out 60h,sspcr		; enable Sync port, 4 word fifo,
                                ; CLX input, FSR as outputs. Burst mode
*ESSP register initialization
        splk #0ffh,60h          ; 
        out  60h,SSPCT          ; 
        splk #0001h,60h         ; GPC enabled - GPI NOT enabled      
        out  60h,SSPMC          ; b 0000 0000 0000 0101 =0005h
        splk #0100h,60h         ; b 0000 0011 0000 0000 =0300h         
        out  60h,SSPST          ; External CLKX  

main:   splk #8h,imr            ; enable receive interrupt
	clrc intm		
	splk #1717h,61h		; dummy data for tx
	splk #55aah,62h		
	splk #7171h,63h		
	splk #0aa55h,64h
        splk #0ffh,7fh
        mar *,ar1		; load ar1 with rx buffer
	lar ar1, #rxbuf
	lar ar0, #size
        out 62h,sdtr            ; Load transmit FIFO again
	
loop:	nop			; wait for transmit buffer empty
        in 70h,SSPST
        bit 70h,3
        bcnd loop,ntc
        out 70h,SSPST           ;clear FSXST
        in  71h,SSPST           ;read FSXST to check SSPST
        call codtx
        out 61h,sdtr
        out 62h,sdtr
        out 63h,sdtr
        out 64h,sdtr
	b loop

codtx:
       in *+,SSPCT
       mar *,ar0
       banz skip,ar1		; buffer limit check
       lar ar1,#rxbuf
       lar ar0,#size			
       in 65h,sspcr 

skip:  setc xf
       nop 
       clrc xf
       splk #10h,ifr
       clrc intm
       ret
	
	
codrx:  
       in 72h,sdtr
       in 73h,sdtr
       in 74h,sdtr
       in 75h,sdtr
       splk #0008h, ifr         ; clear ifr bit due to this interrupt
       clrc intm
       ret			
inpt1: 	ret
inpt23:	ret
time:  	ret
uart:  	ret	
	.end                    ; Assembler module end directive -optional

* Polls the FSXST bit in SSPST register. This bit is set to 1 whenever the
* 16-bit counter decrements to zero. XF is toggled whenever FSXST is set.
* The contents of FSXST is written back to it to reset the FSXST bit to 0