* Program examples for c2xx                          *
* PM - Program memory    DM - Data memory            *
* Command file         : c203.cmd                    *
* Assembler batch file : a.bat                       *
* Linker batch file    : l.bat                       *
* Function: Pulsing of XF                            *


*	    CLKXOX -0 selects CLKOUT1 as             *
*           the input to the counter                 *

*	    CLKXOX -1 selects CLKX as                *
*           the input to the counter                 *
*           Option 14 in ESSP configuration Table A  *
*						     *
* Check : Timer using FSXCT/CLXCT                    *                                                    
*         Check XF timing, to know xmit interrupt    *
*         rate which is counter interrupt rate       *
*         FSX should be synchronous to CLKX          * 
* Rev 2.0                                            *
* Written by: Sam Saba/ASP/St,TX       Date: 7/17/97 *

        .title  " ESSP Burst mode"    ; Title 
	.copy "init.h"    	; Variable and register declaration
        .copy "vector.h"        ; Vector label declaration     
	.text

start:
	CLRC CNF                ; Block B0 in DM, as CNFD
	LDP #0h                 ; set DP=0
	SETC INTM               ; Disable all interrupts
	splk #0000h,60h		; I/O wait states =zero
        out 60h, wsgr
        splk #0cf0eh,60h        ; reset the serial port by writing
	out 60h, sspcr		; zeros at NOR/RES, 
        splk #0cf3eh,60h	; Burst mode
        out 60h,sspcr		; enable Sync port, 4 word fifo,
                                ; CLX/FSR as outputs. 
*ESSP register initialization
        splk #00ffh,60h         ; SSPCT = 255
        out  60h,SSPCT          ; 
        splk #0005h,60h         ; GPC and GPI enabled        
        out  60h,SSPMC          ; b 0000 0000 0000 0101 =0005h
				; Xmit interrupt for timer enabled
				; GPI =1, GPC =1
        splk #0300h,60h         ; b 0000 0011 0000 0000 =0300h         
        out  60h,SSPST          ; CLXOX = 1 (ctr i/p = CLKX)	

main:   splk #10h,imr           ; enable xmit interrupt
	clrc intm		
	
	splk #55aah,62h		; dummy data for tx
	mar *,ar1		; load ar1 with rx buffer
	lar ar1, #rxbuf
	lar ar0, #size
	
loop:	nop			; wait for transmit buffer empty
        idle
        in 70h,SSPST
        out 62h,sdtr		; transmit  again
        in 71h,SSPST
   
	b loop

codtx:
       in *+,SSPCT
       mar *,ar0
       banz skip,ar1		; buffer limit check
       lar ar1,#rxbuf
       lar ar0,#size			
       in 65h,sspcr 

skip   setc xf
       nop 
       clrc xf
       splk #10h,ifr
       clrc intm
       ret
	
codrx:  
       splk #0008h, ifr         ; clear ifr bit due to this interrupt  
       clrc intm
       ret			
inpt1: 	ret
inpt23:	ret
time:  	ret
uart:  	ret	
	.end                    ; Assembler module end directive -optional

* Note: if the program is working correctly, XF should pulse 
* Timer output frequency = CLKX / SSPCT
* where SSPCT is the value in SSPCT register in decimal