* Program examples for c2xx                          *
* PM - Program memory    DM - Data memory            *
* Command file         : c203.cmd                    *
* Assembler batch file : a.bat                       *
* Linker batch file    : l.bat                       *
* Function: Non-stop transmit                        *
*           MODE - Burst mode                        *
*           CLKX - internal CLXCT =1                 *
*           FSX  - internal                          *
*           xmit FIFO level - 4                      *
*           FSN,CLN  - 1 for polarity change         *
*           Byte  - 1 for 8 bit word
*           Option 12 in ESSP configuration table A  * 
*           SPI  - enabled in SSPMC                  *
* Check: CLKX and FSX during delayed write to FIFO   *
*      	Check the polarity of the CLKX,FSX           *
* Rev 2.0	  	                             *
* Written by: Sam Saba/ASP/St,TX       Date: 7/17/97 *
        .title  " ESSP  "       ; Title 
	.copy "init.h"    	; Variable and register declaration
        .copy "vector.h"        ; Vector label declaration     
	.text

start:
	CLRC CNF                ; Block B0 in DM, as CNFD
	LDP #0h                 ; set DP=0
	SETC INTM               ; Disable all interrupts
	splk #0000h,60h		; I/O wait states =zero
        out 60h, wsgr
        splk #0cf0eh,60h        ; reset the serial port by writing
	out 60h, sspcr		; zeros at NOR/RES,   
        splk #0cf3eh,60h	; Burst mode
        out 60h,sspcr		; enable Sync port, 4 word fifo,
				; CLKX/FSX as outputs. 
*ESSP register initialization
        splk #0001h,60h         ; Variable CLKX
        out  60h,SSPCT          ; CLKX = CLKOUT1/(2*(CLXCT+1))
        splk #0040h,60h         ; b 0000 0000 0100 0000 = 0040h        
        out  60h,SSPMC          ; SPI enabled
	splk #4401h,60h         ; b 0100 0100 0000 0000 =4400h         
        out  60h,SSPST          ; PRSEN =0, FSN,CLN =1,Byte-1
        splk #4501h,60h         ; b 0000 0001 0000 0000 =4500h         
        out  60h,SSPST          ; PRSEN =1
	

main:   splk #10h,imr           ; enable transmit interrupt
	clrc intm		
	splk #0aah,61h		; dummy data for tx
	splk #0ffh,7fh
        mar *,ar1		; load ar1 with rx buffer
	lar ar1, #rxbuf
	lar ar0, #size
	rpt 3h
	out 61h,sdtr
	
	
loop:	nop			; wait for transmit buffer empty
        clrc xf			; clear xf flag
        idle
	b loop
codtx
       setc xf
       in 6ah,SSPST 
       in *+,sdtr
       rpt 7fh			; delay in writing to FIFO
       nop
       out 61h,sdtr		; transmit aa again
       mar *,ar0
       banz skip,ar1		; buffer limit check
       lar ar1,#rxbuf
       lar ar0,#size			
       in 65h,sspcr 
skip:  splk #0010h, ifr         ; clear tx intr flag     
       clrc intm
       ret	
	
codrx:  
      splk #0008h, ifr         ; clear ifr bit due to this interrupt  
       clrc intm
       ret			
inpt1: 	ret
inpt23:	ret
time:  	ret
uart:  	ret	
	.end                    ; Assembler module end directive -optional

* Notes : Loopback DX-DR externally
* If the program works properly, 00aah should be written
* cyclically in memory starting from 300h to 320h