* Program examples for c2xx                          *
* PM - Program memory    DM - Data memory            *
* Command file         : c203.cmd                    *
* Assembler batch file : a.bat                       *
* Linker batch file    : l.bat                       *
* Function: Nonstop transmit                         *
*           MODE - Burst mode                        *
*           CLKX - external                          *
*           FSX  - internal FSXCT =3fh               *
*           xmit FIFO level - 4                      *
*                                                    *
*Check:     Multi_channel bit enabled in SSPMC       *
*           Xmit 4 words in burst mode               *
*           Four channel DX/DR with external CLKX    *
* Rev 2.0                                            *
* Written by: Sam Saba/ASP/St,TX       Date: 7/17/97 *

        .title  " ESSP  "       ; Title
	.copy "init.h"    	; Variable and register declaration
        .copy "vector.h"        ; Vector label declaration     
	.text

start:
	CLRC CNF                ; Block B0 in DM, as CNFD
	LDP #0h                 ; set DP=0
	SETC INTM               ; Disable all interrupts
	splk #0000h,60h		; I/O wait states =zero
        out 60h, wsgr
        splk #0cf0ah,60h        ; reset the serial port 
	out 60h, sspcr		
        splk #0cf3ah,60h	; Burst mode
        out 60h,sspcr		; enable Sync port, 4 word fifo,
                                ; CLKX input

*ESSP register initialization
        splk #2501h,60h         ; Variable CLKX
        out  60h,SSPCT          ; CLKX = External CLKX
        splk #0038h,60h         ; b 0000 0000 0011 1000 = 0038h
        out  60h,SSPMC		; FSXCT =3fh
        splk #2100h,60h         ; b 0010 0001 0000 0000 =2100h         
        out  60h,SSPST          ; PRSEN=1, FSXOX =1
	

main:   splk #8h,imr           ; enable receive interrupt
	clrc intm		
	splk #1717h,61h		; dummy data for tx
	splk #55aah,62h		
	splk #7171h,63h		
	splk #0aa55h,64h
        splk #0ffh,7fh
        mar *,ar1		; load ar1 with rx buffer
	lar ar1, #rxbuf
	lar ar0, #size
	out 61h,sdtr
	out 62h,sdtr
	out 63h,sdtr
	out 64h,sdtr
	
loop:	nop			; wait for transmit buffer empty
        clrc xf			; clear xf flag
        idle
	b loop

codtx: splk #0010h, ifr	        ; clear tx intr flag		
       clrc intm
       ret	
	
codrx: 
       setc xf
       in 6ah,SSPST 		; Read FIFO status
       in *+,sdtr
       in 6bh,SSPST
       in *+,sdtr
       in 6ch,SSPST
       in *+,sdtr
       in 6dh,SSPST
       in *+,sdtr
       in 6eh,SSPST
       mar *,ar0
       banz skip,ar1		; buffer limitcheck
       lar ar1,#rxbuf
       lar ar0,#size			
       in 65h,sspcr 
skip:  in 70h,SSPST		; Read FIFO status
       out 61h,sdtr		; transmit again
       in 71h,SSPST
       out 62h,sdtr		
       in 72h,SSPST
       out 63h,sdtr
       in 73h,SSPST
       out 64h,sdtr
       in 74h,SSPST
       splk #0008h, ifr      	; clear ifr bit due to this interrupt  
       clrc intm
       ret			     
    
inpt1: 	ret
inpt23:	ret
time:  	ret
uart:  	ret	
	.end                    ; Assembler module end directive -optional

* Notes : Loopback DX-DR alone externally
* If the program works properly, 1717 55aa 7171 aa55 should be written
* cyclically in memory starting from 300h to 320h
* An external clock needs to be connected to CLKX of 2xx