* Program examples for c2xx                          *
* PM - Program memory    DM - Data memory            *
* Command file         : c203.cmd                    *
* Assembler batch file : a.bat                       *
* Linker batch file    : l.bat                       *
* Function: Non-stop transmit in Burst mode          *
*           Internal shift clock and frame sync      *	
*	    Transmit FIFO level is set to 4          *
*           For external loopback at the DX/DR pin   * 
* ESSP:     CLKXCT =0, uses only SSPCR initialization* 
* Rev 2.0					     *
* Written by: Sam Saba/ASP/St,TX       Date: 7/17/97 *                   

	.title  " SSP Burst mode"    ; Title 
	.copy "init.h"    	; Variable and register declaration
        .copy "vector.h"        ; Vector label declaration     
	.text

start:  clrc cnf                ; Block B0 in DM, as CNFD
	ldp #0h                 ; set DP=0
	setc INTM               ; Disable all interrupts
        splk #0000h, 60h        ; Set zero wait states 
        out 60h, wsgr           
        splk #0cf0eh,60h        ; reset the serial port 
	out 60h, sspcr		
        splk #0cf3eh,60h        ; enable Sync port, 4 word fifo,
        out 60h,sspcr		; internal clocks, burst mode
				
     	splk #1717h,61h		; dummy data for tx 
	splk #55aah,62h		
	splk #7171h,63h		
	splk #0aa55h,64h
	splk #0fffh,70h
	splk #8h,imr		; enable rx interrupt
        mar *,ar1		; load ar1 with rx buffer
	lar ar1, #rxbuf
	lar ar0, #size
	clrc intm		; enable INTM 
	out 61h,sdtr		; Xmit once to start 
	out 62h,sdtr		; transmit interrupts
	out 63h,sdtr
	out 64h,sdtr
	
loop:   clrc xf			; clear xf flag
        idle
	b loop

codtx:	
        splk #0010h, ifr	; clear ifr flag
        ret

delay:  rpt 70h			; delay loop
        nop
        rpt 70h
        nop
        ret

codrx: 
       setc xf
       in *+,sdtr
       in *+,sdtr
       in *+,sdtr
       in *+,sdtr
       out 61h,sdtr		; transmit 1717h  	
       call delay
       out 62h,sdtr		; transmit 0x55aah again
       call delay
       out 63h,sdtr
       call delay
       out 64h,sdtr

       mar *,ar0
       banz skip,ar1		; buffer check
       lar ar1,#rxbuf
       lar ar0,#size			
skip:  splk #0008h, ifr      	; clear ifr bit due to this interrupt  
       clrc intm
       ret		
	
inpt1: 	ret
inpt23:	ret
time:  	ret
uart:  	ret	
	.end                    ; Assembler module end directive -optional


* Notes : Loopback DX-DR, FSX-FSR and CLKX-CLKR externally
* If the program works properly, 1717 55aa 7171 aa55 should be written
* cyclically in memory starting from 300h to 320h
