/*----------------------------------------------------------------------------*/
/*  LINKER COMMAND FILE 								*/
/*  Used for linking USR (User's) version of Serial Boot Flash
/*  loader which is programmed during device Test time.
/*  Last update 21 Nov 97									*/
/*----------------------------------------------------------------------------*/
MEMORY
{
    PAGE 0 :	PROG	: origin =03E00h , length =  0200h	 /* code    */
	    /*	B0_PRG	: origin =0FE00h   length =  0100h	    code    */

    PAGE 1 :	B2	: origin = 0060h , length =   020h	 /* DARAM   */
	       	B0	: origin = 0100h , length =  0200h	 /* DARAM   */
	       	B1	: origin = 0300h , length =  0200h	 /* DARAM   */

    PAGE 2 :	B0_PRG	: origin =0FE00h , length =  0100h	 /* Overlay */
}

/*--------------------------------------------------------------------------*/
/* SECTIONS ALLOCATION                                                      */
/*--------------------------------------------------------------------------*/
SECTIONS
{
    .text    : { } > PROG      PAGE 0	   /* CODE			   */
    .bss     : { } > B1        PAGE 1	   /* Block B1 - page 6 	   */

    UNION: run = B0_PRG  PAGE 2
    {   
       kernel	   : load= PROG  PAGE 0
    }

}

