;*********************************************************************
;
; Filename:  TRANMAIN.ASM
;
; Author:  Chris Buehler, Jonas Keating
; Date:  9/20/95
; Last revision:  12/18/95
;
;*********************************************************************
;
; Description:  Main transmitter loop.
;
; Algorithm:  1) Wait for signal from PC.
;	      2) Initiate transmission at either 9.6, 14.4, 19.2 kbps.
;	      3) Send proper startup sequence.
;	      4) Enter infinite loop, send data from PC to receiver.
;	      5) Wait for signal from PC to stop.
;
;*********************************************************************
;
; Usage:  Begin execution at label '_main2'.
;
; Inputs:  none
;
; Outputs:  none
;
;*********************************************************************
;
; Comments:  This is the main transmitter file.  Calls all other
;            routines.
;
;*********************************************************************

  .mmregs
  .include macros.inc

  .global       _main2
  .global       initevm, initDSP
  .global       getdata
  .global       parse_data
  .global       shell_map, shell_mask,shell_check
  .global       get_initial_point
  .global       compute_rotation_factorZ
  .global       compute_rotation_factorW
  .global       rotate90_cw
  .global       complex_sum
  .global       complex_diff
  .global       get_binary_subset_label
  .global       precoder_filter_real
  .global       precoder_filter_imag
  .global       round_precoder_output
  .global       QAM_mod, QAM_init,QAM_start,QAM_wait
  .global       startup_S,startup_PP,startup_TRN,startup_MP,startup_TRN16
  .global       quantize
  .global       compute_c0
  .global       compute_u0
  .global       do_convolutional_encoder

  .global       datastart, int1data, go,tcont,scale
  .global       m,n
  .global       z,w,q,qbits,data_present
  .global       c_new_r,c_new_i, c_old_r, c_old_i
  .global       preal,pimag
  .global       s_early,s_late
  .global       g2,g2_14_19,g2_addr
  .global       g4,g4_14_19,g4_addr
  .global       z8,z8_14_19,z8_addr
  .global       parse_addr,quant_addr
  .global       numshells,maindone
  .global       xx,xy,state,randstat
  .global       parse_data96,quantize96,parse_data144,quantize144,parse_data192,quantize192
  .global       MP_sequence,bitstream,bitbuf,speed_flag

  .global       points,pointadd

  .text

_main2:

  clearmsg
  call  initDSP
  call  initevm
  call  QAM_init
  call  QAM_start

  call wait_for_go

startup:
  call  startup_S
  call  startup_PP
  call  startup_TRN
  call  startup_MP
  ldpk	go
  lacl	go
  sub	#3
  bcnd  not192,NEQ
  call  startup_TRN16

not192:
  ldpk  pointadd
  splk  #points,pointadd
  ldpk  datastart
  splk	#0,z
  splk	#0,randstat
  splk	#0,randstat+1

nloop:
  call  getdata
  zap
  sacl  n
  sacl  m
  call  parse_data,*,AR0
  call  shell_map,*,AR0
  call  shell_check,*,AR0
mloop:
  call  get_initial_point,*,AR0
  call  compute_rotation_factorZ,*,AR0
  call  rotate90_cw
  call  complex_sum
  call  complex_diff
  call  get_binary_subset_label
  sacl  s_early

  call  QAM_mod,*,AR0
  call  QAM_wait

  call  precoder_filter_real,*,AR0
  call  round_precoder_output
  sacl  preal
  call  precoder_filter_imag,*,AR0
  call  round_precoder_output
  sacl  pimag

;// c_old_r = c_new_r;
;// c_old_i = c_new_i;
  lacc  c_new_r
  sacl  c_old_r
  lacc  c_new_i
  sacl  c_old_i

  lacc  preal
  call  quantize
  sacl  c_new_r
  lacc  pimag
  call  quantize
  sacl  c_new_i

  call  compute_c0
  call  compute_u0
  call  compute_rotation_factorW,*,AR0
  call  get_initial_point,*,AR0
  lacl  w
  call  rotate90_cw
  call  complex_sum
  call  complex_diff
  call  get_binary_subset_label
  sacl  s_late

  call  QAM_mod,*,AR0
  call  QAM_wait

  call  precoder_filter_real,*,AR0
  call  round_precoder_output
  sacl  preal
  call  precoder_filter_imag,*,AR0
  call  round_precoder_output
  sacl  pimag

  lacc  c_new_r
  sacl  c_old_r
  lacc  c_new_i
  sacl  c_old_i

  lacc  preal
  call  quantize
  sacl  c_new_r
  lacc  pimag
  call  quantize
  sacl  c_new_i

  call  do_convolutional_encoder,*,AR0

  ldpk go
  lacl go
  bcnd wait_for_go,EQ
  ldpk datastart

  lacl  m
  add   #1
  and   #3
  sacl  m
  bcnd  mloop,NEQ
  b     nloop

maindone:
  b     maindone

wait_for_go:
  ldpk  go
  splk  #0,go
  splk	#0,data_present
  ldpk  bitbuf
  splk	#0FFFFh,bitbuf
  splk	#0FFFFh,bitbuf+1
  splk	#0FFFFh,bitbuf+2
  splk	#0FFFFh,bitbuf+3
  ldpk  datastart
  splk  #0,randstat
  splk  #0,randstat+1
  splk  #0,state
  splk  #0,w
  splk  #0,z
  lar   AR0,#qbits
  mar   *,AR0
  rptz  #7
    sacl  *+

watch_go:
  ldpk  datastart
  splk  #0,xx
  splk  #0,xy
  call  QAM_mod,*,AR0
  call  QAM_wait
  ldpk  go
  lacl  go
  nop
  nop
  nop
  bcnd  watch_go,EQ

  sub   #1
  bcnd  go96,EQ
  sub   #1
  bcnd  go144,EQ
  sub   #1
  bcnd  go192,EQ
  zap
  sacl  go
  b     wait_for_go

go96:
  ldpk  MP_sequence
  splk  #1,speed_flag
  ldpk  parse_addr
  splk  #parse_data96,parse_addr
  splk  #quantize96,quant_addr
  ldpk  datastart
  splk  #0,q
  splk  #g2,g2_addr
  splk  #g4,g4_addr
  splk  #z8,z8_addr
  splk  #6,numshells
  splk  #2,scale
  b     startup

go144:
  ldpk  MP_sequence
  splk  #2,speed_flag
  ldpk  parse_addr
  splk  #parse_data144,parse_addr
  splk  #quantize144,quant_addr
  ldpk  datastart
  splk  #1,q
  splk  #g2_14_19,g2_addr
  splk  #g4_14_19,g4_addr
  splk  #z8_14_19,z8_addr
  splk  #12,numshells
  splk  #1,scale
  b     startup

go192:
  ldpk  MP_sequence
  splk  #3,speed_flag
  ldpk  parse_addr
  splk  #parse_data192,parse_addr
  splk  #quantize192,quant_addr
  ldpk  datastart
  splk  #3,q
  splk  #g2_14_19,g2_addr
  splk  #g4_14_19,g4_addr
  splk  #z8_14_19,z8_addr
  splk  #12,numshells
  splk  #0,scale
  b     startup

.end


