;*********************************************************************
;
; Filename:  STARTUP.ASM
;
; Author:  Chris Buehler, Jonas Keating
; Date: 11/20/95
; Last revision:  12/23/95
;
;*********************************************************************
;
; Description:  contains the following routines which together form the
;		startup sequence of the modem.
;
;	      1 startup_S     - sends a 2 point dotting sequence.
;				used for initial symbol clock recovery.
;				4800 bauds.
;	      2	startup_PP    - sends the periodic polyphase signal.
;				used for fast training the equalizer.
;				288 bauds.
;	      3	startup_TRN   - sends a 4 point training sequence.
;				used for fine training the equalizer.
;				4800 bauds.
;	      4	startup_MP    - sends a sequence of 10 differentially
;				encoded words which inform the receiver
;				of transmission parameters.
;				80 bauds.
;
;	      5	startup_TRN16 - sends a 16 point training sequence.
;				used for fine tuning the equalizer when
;				transmitting at 19.2.
;				4800 bauds.
;
; Algorithm: All sequences are just points that are QAM modulated by
;	     QAM_mod and QAM_wait.  The PP sequence is stored in a table
;	     called PP0.  The other points are calculated on the fly.
;
;
;*********************************************************************
;
; Usage:  Call the 5 routines in order to output the total startup
;	  sequence.
;
; Inputs:  the array MP_sequence is transmitted by startup_MP
;
; Outputs:  none
;
;*********************************************************************
;
; Comments:  startup sequence routines should only be called at the beginning
;            of a transmission
;
;*********************************************************************

  .mmregs
  .include macros.inc


  .global	startup_PP,startup_S,startup_TRN,startup_MP,startup_TRN16
  .global	QAM_mod,QAM_wait
  .global	scramble16,rotate90_cw

  .global	datastart,scale,xx,xy,PP0,n
  .global	ux,uy,vx,vy,bitstream,randstat,z
  .global	MP_sequence,saveAR0,coords


startup_PP:
  ldpk	datastart
  lacl	scale
  sacl	temp2
  splk	#0,scale
  splk	#6,temp0
  splk	#0,n
PP_outer:
  lar	AR0,#PP0
  splk	#48,temp1
PP_inner:
  mar	*,AR0
  lacc	*+
  bsar	5
  sacl	xx
  lacc	*+
  bsar	5
  sacl	xy
  sar	AR0,temp3
  call	QAM_mod,*,AR0
  call	QAM_wait
  lar	AR0,temp3
  lacl	temp1
  sub	#1
  sacl	temp1
  bcnd	PP_inner,NEQ
  lacl  temp0
  sub	#1
  sacl  temp0
  bcnd	PP_outer,NEQ
  lacl	temp2
  sacl	scale
  ret

startup_S:
  ldpk	datastart
  splk	#2400,temp0
  lacl	scale
  sacl	temp2
  splk	#3,scale
  mar	*,AR0
S_outer:
  ldpk	datastart
  splk	#128,xx
  splk	#128,xy
  call	QAM_mod,*,AR0
  call	QAM_wait
  ldpk	datastart
  splk	#(-128),xx
  splk	#(128),xy
  call	QAM_mod,*,AR0
  call	QAM_wait
  ldpk	datastart
  lacl	temp0
  sub	#1
  sacl	temp0
  bcnd	S_outer,NEQ
  lacl	temp2
  sacl	scale
  ret

; execute outer loop 600 time, inner loop 8 times = 4800 bauds
; uses z variable for differential encoder

startup_TRN:
  ldpk	datastart
  splk	#1200,temp0
  lacl	scale
  sacl	temp2
  splk	#3,scale
  splk	#0,randstat
  splk	#0,randstat+1
TRN_outer:
  ldpk	datastart
  splk	#0FFFFh,bitstream
  lar	AR0,#bitstream
  call	scramble16,*,AR0
  lacl	bitstream
  sacl	temp1
  splk	#8,temp3
TRN_inner:
  splk	#128,vx
  splk	#128,vy
  lacc	temp1,16
  rol
  rol
  sach	temp1
  rol
  and	#3
  sacl	z
  call	rotate90_cw
  lacl	ux
  sacl	xx
  lacl	uy
  sacl	xy
  call	QAM_mod,*,AR0
  call  QAM_wait
  lacl	temp3
  sub	#1
  sacl	temp3
  bcnd	TRN_inner,NEQ

  lacl	temp0
  sub	#1
  sacl	temp0
  bcnd	TRN_outer,NEQ
  lacl	temp2
  sacl	scale
  ret


; differential encoder initialized with 'z' from TRN sequence
;
;  send 16 0's
;  send 16 1's
;  speed  4 = 9600  6 = 14.4  8 = 19.2
;  coeffs hreal(-1,-2,-3), himag(-1,-2,-3)
;  10 words total
startup_MP:
  ldpk	datastart
  splk	#11,temp0
  lacl	scale
  sacl	temp2
  splk	#3,scale
  lar	AR0,#MP_sequence
  mar	*,AR0
MP_outer:
  ldpk	datastart
  mar	*,AR0
  lacl	*+
;  sacl	bitstream
;  call	scramble16
;  lacl	bitstream
  sacl	temp1
;  splk	#0ffffh,temp1
  splk	#8,temp3
MP_inner:
  splk	#128,vx
  splk	#128,vy
  lacc	temp1,16
  rol
  rol
  sach	temp1
  rol
  and	#3
  add	z				; differentially encoded
  and	#3
  sacl	z
  call	rotate90_cw
  lacl	ux
  sacl	xx
  lacl	uy
  sacl	xy
  sar	AR0,temp4
  call	QAM_mod,*,AR0
  call  QAM_wait
  lar	AR0,temp4
  lacl	temp3
  sub	#1
  sacl	temp3
  bcnd	MP_inner,NEQ

  lacl	temp0
  sub	#1
  sacl	temp0
  bcnd	MP_outer,NEQ
  lacl	temp2
  sacl	scale
  ret

; for 19.2 startup only (others don't need it)
startup_TRN16:
  ldpk	datastart
  splk	#1200,temp0
  lacl	scale
  sacl	temp2
  splk	#2,scale
  splk	#0,randstat
  splk	#0,randstat+1
TRN16_outer:
  ldpk	datastart
  splk	#0FFFFh,bitstream
  lar	AR0,#bitstream
  call	scramble16,*,AR0
  lacl	bitstream
  sacl	temp1
  splk	#4,temp3
TRN16_inner:
  ldpk  datastart
  lacc	temp1,16
  rol
  rol
  sach	temp1
  rol
  and	#3
  sfl
  add	#coords
  samm	AR0
  mar	*,AR0
  nop
  lacc	*+,7
  sacl	vx
  lacc	*,7
  sacl	vy

  lacc	temp1,16
  rol
  rol
  sach	temp1
  rol
  and	#3
  sacl	z
  call	rotate90_cw
  lacl	ux
  sacl	xx
  lacl	uy
  sacl	xy
  call	QAM_mod,*,AR0
  call  QAM_wait
  lacl	temp3
  sub	#1
  sacl	temp3
  bcnd	TRN16_inner,NEQ

  lacl	temp0
  sub	#1
  sacl	temp0
  bcnd	TRN16_outer,NEQ
  lacl	temp2
  sacl	scale
  ret

