;*********************************************************************
;
; Filename:  SHELL.ASM
;
; Author:  Chris Buehler, Jonas Keating
; Date:  9/10/95
; Last revision:  11/20/95
;
;*********************************************************************
;
; Description:
;		shell_map:
;		Outputs a sequence of eight ring indices ranging from
;		0 .. numshells-1.  Accepts a 20 or 28 bit number in
;		the accumulator.
;
;		shell_mask:
;		Masks the output ring indices so that they assume only
;		restricted values.  Used for debugging.
;
;		shell_check:
;		Checks to make sure the ring indices are within the
;		proper range.  Halts the program if not.  Used for
;		debugging.
;
; Algorithm:  shell_map:
;	      Uses the shell mapping algorithm explained in Appendix C
;             of the project submission.
;
;*********************************************************************
;
; Usage:  Store the bits to shell map in the accumulator and call shell_map
;
; Inputs: A K bit number in the accumulator.
;
; Outputs:  A sequence of 8 ring indices in array mjk.
;
;*********************************************************************
;
; Comments: shell_mask and shell_check are not needed in the final product.
;           C comments from file trans96a.cpp.
;
;*********************************************************************
  .mmregs
  .text


  .global	shell_map,shell_mask,shell_check
  .global	datastart
  .global	r0,r1,r2,r3,r4,r5
  .global	A,B,C,D,E,F,G,H
  .global	g2_addr,g4_addr,z8_addr,numshells
  .global	mjk
  .global	shellmask,xx_10,maindone

shell_check:
  ldpk	datastart
  lacl	mjk
  sub	numshells
  nop
  xc	2,GEQ
    splk #1,xx_10
  lacl	mjk+1
  sub	numshells
  nop
  xc	2,GEQ
    splk  #2,xx_10
   lacl	mjk+2
  sub	numshells
  nop
  xc	2,GEQ
    splk  #3,xx_10
  lacl	mjk+3
  sub	numshells
  nop
  xc	2,GEQ
    splk  #4,xx_10
  lacl	mjk+4
  sub	numshells
  nop
  xc	2,GEQ
    splk  #5,xx_10
  lacl	mjk+5
  sub	numshells
  nop
  xc	2,GEQ
    splk  #6,xx_10
  lacl	mjk+6
  sub	numshells
  nop
  xc	2,GEQ
    splk  #7,xx_10
  lacl	mjk+7
  sub	numshells
  nop
  xc	2,GEQ
    splk  #8,xx_10
  lacl	xx_10
  bcnd	maindone,NEQ
  ret

shell_mask:
  lacl	mjk
  and	shellmask
  sacl	mjk
  lacl	mjk+1
  and   shellmask
  sacl	mjk+1
  lacl	mjk+2
  and   shellmask
  sacl	mjk+2
  lacl	mjk+3
  and   shellmask
  sacl	mjk+3
  lacl	mjk+4
  and   shellmask
  sacl	mjk+4
  lacl	mjk+5
  and   shellmask
  sacl	mjk+5
  lacl	mjk+6
  and   shellmask
  sacl	mjk+6
  lacl	mjk+7
  and   shellmask
  sacl	mjk+7
  ret

shell_map:

;//  A = 0;
;//  while(z8[A] <= r0)
;//  {A++;}
;//  A--;

  ldp	#0 				; load dp0 to set INDX
  splk  #3,INDX				; set INDX to 3 for funky array indexing
  ldpk	datastart			; get normal data page
  lacc	r0+1,16				; load r0
  or	r0
  sacb					; save it in ACCB for comparison w/crgt
;  lar	AR0,#(z8+1)			; get start of z8 table
  lar	AR0,z8_addr
  mar 	*,AR0
  mar	*+

findA:
  lacc  *-,16				; load current value from z8 table
  or	*0+
  sbb					; compare to r0
  bcnd	findA,LEQ			; if ACC >= ACCB drop out of loop

  lamm  AR0				; get table address to calculate A
;  sub	#(z8+5)				; subtract base address and 5
  sub	z8_addr
  sub	#5
  sfr					; divide by 2 (table is long words)
  sacl	A				; store to A

;  add	#g4
  add	g4_addr
  samm	AR2    				; AR2 = g4 + A
;  lar	AR1,#g4				; AR1 = g4
  lar	AR1,g4_addr

;//  r1 = r0-z8[A];
  lacc	r0+1,16				; reload r0
  or	r0
  sbrk	#5				; get proper z8 table index back
  subs	*+				; subtract z8[A]
  sub	*,16,AR1			; r1 = r0 - z8[A] now in ACC
  sacb

;// AR1 = g4[0]
;// AR2 = g4[A]

;//  B = -1;
;//  while(r1 >= 0)
;//  {
;//	B++;
;//	r1 -= g4[B]*g4[A-B];
;//  }
;//  r1 += g4[B]*g4[A-B];

  lt	*+,AR2
findB:
  mpyu  *-,AR1
  lts   *+,AR2
  bcnd  findB,GEQ
  apac
  sacl	r1
  sach	r1+1
  lamm	AR1
;  sub	#(g4+2)
  sub	g4_addr
  sub	#2
  sacl	B

;  add	#g2
  add	g2_addr
  samm	AR2				; AR2 = g2 + B
;//  lar	AR1,#g2				; AR1 = g2


;//  r2 = r1 % g4[B];
;//  r3 = (r1-r2)/g4[B];
  mar	*,AR1
  sbrk  #2
  lacc	r1+1,16
  or	r1
  rpt	#15
	subc  *
  sacl	r3
  sach	r2

;//  r4 = r2;
;//  C = -1;
;//  while(r4 >= 0)
;//  {
;//	C++;
;//	r4 -= g2[C]*g2[B-C];
;//  }
;//  r4 += g2[C]*g2[B-C];
;  lar	AR1, #g2
  lar	AR1,g2_addr
  lacl	r2
  lt	*+,AR2
findC:
  mpyu  *-,AR1
  lts   *+,AR2
  bcnd  findC,GEQ
  apac
  sacl	r4
  sach	r4+1
  lamm	AR1
;  sub	#(g2+2)
  sub	g2_addr
  sub	#2
  sacl	C

  lacc	A
  sub	B
;  add	#g2
  add	g2_addr
  samm	AR2				; AR2 = g2 + A - B
;//  lar	AR1,#g4				; AR1 = g4

;//  E = r4 % g2[C];
;//  F = (r4-E)/g2[C];
  mar	*,AR1
  sbrk	#2
  lacc	r4+1,16
  or	r4
  rpt	#15
	subc *
  sacl	F
  sach	E

;//  r5 = r3;
;//  D=-1;
;//  while(r5 >= 0)
;//  {
;//	D++;
;//	r5 -= g2[D]*g2[A-B-D];
;//  }
;//  r5 += g2[D]*g2[A-B-D];
;  lar	AR1,#g2
  lar	AR1,g2_addr
  lacl	r3
  lt	*+,AR2
findD:
  mpyu  *-,AR1
  lts   *+,AR2
  bcnd  findD,GEQ
  apac
  sacl	r5
  sach	r5+1
  lamm	AR1
;  sub	#(g2+2)
  sub	g2_addr
  sub	#2
  sacl	D

;//  G = r5 % g2[D];
;//  H = (r5-G)/g2[D];
  mar	*,AR1
  sbrk	#2
  lacc	r5+1,16
  or	r5
  rpt	#15
	subc *
  sacl	H
  sach	G

;//  if(C < M)
;//  {
;//	mjk[0] = E;
;//	mjk[1] = C-mjk[0];
;//  }
;//  else
;//  {
;	mjk[0] = C-M+1+E);
;	mjk[1] = C-mjk[0];
;//	mjk[1] = M-1-E;
;//	mjk[0] = C-mjk[1];
;//  }
  lar	AR0,#mjk
  mar	*,AR0
  lacl	C
;  sub	#M
  sub	numshells
  bcnd	getmjk01,GEQ
  lacl	E
  sacl	*+
  sub	C
  neg
  sacl	*+
  b	mjk01done
getmjk01:
  lacl	C
;  sub	#(M-1)
  sub	numshells
  add	#1
  add	E
  sacl	*+
  sub	C
  neg
  sacl	*+
mjk01done:

;//  if(B-C<M)
;//  {
;//	mjk[2] = F;
;//	mjk[3] = B-C-mjk[2];
;//  }
;//  else
;//  {
;//	mjk[3] = M-1-F;
;//	mjk[2] = B-C-mjk[3];
;//  }
  lacl	B
  sub	C
;  sub	#M
  sub	numshells
  bcnd	getmjk23,GEQ
  lacl	F
  sacl	*+
  sub	B
  add	C
  neg
  sacl	*+
  b	mjk23done
getmjk23:
  lacl	B
  sub	C
;  sub	#(M-1)
  sub	numshells
  add	#1
  add	F
  sacl	*+
  sub	B
  add	C
  neg
  sacl	*+
mjk23done:

;//  if(D<M)
;//  {
;//	mjk[4] = G;
;//	mjk[5] = D-mjk[4];
;//  }
;//  else
;//  {
;	mjk[4] = D - (M-1-G) = D - M + 1 + G;
;//	mjk[5] = M-1-G;
;//	mjk[4] = D-mjk[5];
;//  }
  lacl	D
;  sub	#M
  sub	numshells
  bcnd	getmjk45,GEQ
  lacl	G
  sacl	*+
  sub	D
  neg
  sacl	*+
  b	mjk45done
getmjk45:
  lacl	D
;  sub	#(M-1)
  sub	numshells
  add	#1
  add	G
  sacl	*+
  sub	D
  neg
  sacl	*+
mjk45done:

;//  if(A-B-D < M)
;//  {
;//	mjk[6] = H;
;//	mjk[7] = A-B-D-mjk[6];
;//  }
;//  else
;//  {
;//	mjk[7] = M-1-H;
;//  	mjk[6] = A-B-D-mjk[7];
;//  }
  lacl	A
  sub	B
  sub	D
;  sub	#M
  sub	numshells
  bcnd	getmjk67,GEQ
  lacl	H
  sacl	*+
  sub	A
  add	B
  add	D
  neg
  sacl	*+
  b	mjk67done
getmjk67:
  lacl	A
  sub	B
  sub	D
;  sub	#(M-1)
  sub	numshells
  add	#1
  add	H
  sacl	*+
  sub	A
  add	B
  add	D
  neg
  sacl	*+
mjk67done:
  ret

  .end