;*********************************************************************
;
; Filename:  SCRAM.ASM
;
; Author:  Chris Buehler
; Date:  9/10/96
; Last revision:  11/15/95
;
;*********************************************************************
;
; Description:  Scrambles 16 bits of data using a linear shift feedback
;		register with generating polynomial 1 + x^-18 + x^-23.
;		Input is in variable bitstream.
;
; Algorithm:  First loads the random state variable randstat in the ACC.
;	      Stores in ACCB and loads it again shifted by 5 bits.
;	      XOR's the ACC and ACCB and stores in ACCB.  Then loads
;	      the data, shifted properly, and XOR's ACC and ACCB again.
;	      Final 16 bits are masked off, the random state variable is
;	      updated, and the scrambled data is stored in memory.
;
;*********************************************************************
;
; Usage:  Just call scramble16.
;
; Inputs:  AR0 contains pointer to data to scramble.
;
; Outputs:  data is scrambled in place upon exit.
;
;*********************************************************************
  .mmregs
  .text

  .global scramble16
  .global randstat, bitstream, datastart


; assumes AR0 points to word to scramble
scramble16:
  clrc	SXM
  mar	*,AR0
  ldpk	datastart
  lacc	randstat+1,11
  sacb
  lacc	randstat+1,16
  or    randstat
  xorb
  sacb
  lacc	*,11
;  lacc	bitstream,11
  xorb
  and	#0FFFFh,11
  bsar	2
  sacb
  bsar	9
  sacl	*
;  sacl	bitstream
  lacc	randstat,16
  orb
  sach	randstat+1
  sacl	randstat
  setc  SXM
  ret

  .end
