;*********************************************************************
;
; Filename:  ROTATE.ASM
;
; Author:  Chris Buehler
; Date:  9/15/95
; Last revision:  10/12/95
;
;*********************************************************************
;
; Description:  rotate90_cw:
;		Rotate a point clockwise by a multiple of 90 degrees
;		based on a value passed in the accumulator.
;
;		compute_rotation_factorZ:
;		Computes the rotation factor for the early 2D symbol.
;
;		compute_rotation_factorW:
;		Computes the rotation factor for the early 2D symbol.
;
;
; Algorithm:  Just use swaps and negations to do the rotations.
;             Rotation factors computed with mod-4 arithmetic.
;
;*********************************************************************
;
; Usage:  Call compute_rotation_factor*, *=Z or W, result is stored in
;	  variables z or w.
;	  Call rotate90_cw.  The point stored in (ux,uy) is rotated to
;	  the point (vx,vy) according to the number stored in the ACC.
;
; Inputs:  rotate90_cw:
;	   (ux,uy) and ACC
;
; Outputs: rotate90_cw:
;          (vx,vy)
;
;*********************************************************************
;
; Comments:  No problem, man.
;
;*********************************************************************
  .mmregs
  .text

  .global rotate90_cw
  .global compute_rotation_factorZ
  .global compute_rotation_factorW
  .global vx,vy,ux,uy
  .global m,ibits,z,w,u0

compute_rotation_factorZ:
;// assumes AR0 is current
;//  z = (z + (ibits[m]>>1))&3;
  lacl	m
  add	#ibits
  samm	AR0
  nop
  nop
  lacl	*
  sfr
  add	z
  and	#3
  sacl	z
  ret

compute_rotation_factorW:
;// assumes AR0 is current
;  // mask out lsb
;//  w = (z + ((ibits[m]&1)<<1) + u0)&3;
  lacl	m
  add	#ibits
  samm	AR0
  lacl	z
  add	u0
  sacb
  lacc	*,1
  and	#2
;  sfl
  addb
  and	#3
  sacl	w
  ret

rotate90_cw:
;//  switch(ACC){
;//	case 0:  ux = vx;
;// 		 uy = vy;
;//              break;
;//	case 1:  ux = vy;
;//		 uy = -vx;
;//		 break;
;//	case 2:  ux = -vx;
;//		 uy = -vy;
;//		 break;
;//	case 3:  ux = -vy;
;//		 uy = vx;
;//		 break; }
  bcnd	check1,NEQ
  lacc	vx
  sacl	ux
  lacc	vy
  sacl	uy
  ret
check1:
  sub	#1
  bcnd	check2,NEQ
  lacc	vy
  sacl	ux
  lacc	vx
  neg
  sacl	uy
  ret
check2:
  sub	#1
  bcnd	check3,NEQ
  lacc	vx
  neg
  sacl	ux
  lacc	vy
  neg
  sacl	uy
  ret
check3:
  lacc	vy
  neg
  sacl	ux
  lacc	vx
  sacl	uy
  ret

  .end