;*********************************************************************
;
; Filename:  QUANTIZE.ASM
;
; Author:  Chris "No Problem" Buehler, Jonas "" Keating
; Date:  9/10/95
; Last revision:  10/20/95
;
;*********************************************************************
;
; Description:  Perform the quanTIzaTIon according to the ITU spec.
;		Round to either 2 or 4.
;
; Algorithm:  Basically add a .49999999... (all ones below the lsb),
;	      chop off the insignificant bits and mask off any we don't
;	      want left over.
;
;*********************************************************************
;
; Usage:  Call quantize.  The contents of the accumulator are quantized
;	  according to the transmission speed.  The proper subfunction
;	  is chosen depending on the variable 'go', which indicates the
;	  current speed of transmission.
;
; Inputs: accumulator
;
; Outputs:  accumulator
;
;*********************************************************************
;
; Comments:  "Hey, if it's not working, then what the heck is it doing??"
;
;*********************************************************************
  .mmregs
  .text

  .global quant_addr,datastart
  .global quantize,quantize96,quantize144,quantize192

quantize:
  sacb
  ldpk	quant_addr
  lacl	quant_addr
  ldpk	datastart
  bacc


quantize96:
;//  ACCB = ACC;
;//  ACC = (labs(ACC) + 0x07F)>>7;
;//    we must mask out the 1st bit because we are rounding to the 2nd bit
;//    all numbers should be even coming out of quantize96
;//  ACC &= 0xFFFFFFFEL;
;//  if(ACCB < 0)
;//	ACC = -ACC;

  lacb
  bcnd quan96_neg,LT
  add	#07Fh
  bsar	7
  and	#0FFFEh
  ret
quan96_neg:
  abs
  add	#07Fh
  bsar	7
  and	#0FFFEh
  neg
  ret

quantize144:
  lacb
  bcnd quan144_neg,LT
  add	#07Fh
  bsar	7
  and	#0FFFEh
  ret
quan144_neg:
  abs
  add	#07Fh
  bsar	7
  and	#0FFFEh
  neg
  ret

quantize192:
  lacb
  bcnd quan192_neg,LT
  add	#0FFh
  bsar	7
  and	#0FFFCh
  ret
quan192_neg:
  abs
  add	#0FFh
  bsar	7
  and	#0FFFCh
  neg
  ret

  .end