;*********************************************************************
;
; Filename:  PRE_FILT.ASM
;
; Author:  Chris Buehler, Jonas Keating
; Date:  10/20/95
; Last revision:  11/21/95
;
;*********************************************************************
;
; Description:  Contains routines:
;		1) precoder_filter_real
;		2) precoder_filter_imag
;		3) round_precoder_output
;
; Algorithm:  Multiplies the precoder filter coefficients by the past
;	      three values of output.
;
;*********************************************************************
;
; Usage:  call precoder_filter_real,*,AR0
;		     or
;	  call precoder_filter_imag,*,AR0
;		     or
;	  call round_precoder_output
;
; Inputs:  xy, xx
;
; Outputs:  ACC
;
;*********************************************************************
;
; Comments:  These routines return their results in the accumulator.
;	     The first two routines require that AR0 are set as the
;	     active auxilliary register.
;
;*********************************************************************

  .mmregs
  .text

  .global precoder_filter_real
  .global precoder_filter_imag
  .global round_precoder_output
  .global xy,xx
  .global hreal,himag

precoder_filter_real:
;//  assumes AR0 is current ARP

;//  int p;
;//  ACC = 0;
;//  for(p=1; p < 4; p++)
;//  {
;//	ACC += xx[XOFF + n - p]*h[p-1].real -
;//		xy[XOFF + n - p]*h[p-1].imag;
;//  }
  lar	AR0,#(xy+1) 	;//This sets AR0 to the first element in xy (not yet shifted down)
  zap
  rpt	#2              ;//This adds 1 to AR0 so that the first element of xy is skipped
    mac   himag,*+
  apac
  sacb

  lar	AR0,#(xx+1)
  zap
  rpt	#2
    mac	  hreal,*+
  apac
  sbb
  ret

precoder_filter_imag:
;//  assumes AR0 is current ARP

;//  int p;
;//  ACC = 0;
;//  for(p=1; p < 4; p++)
;//  {
;//	ACC += xy[XOFF + n - p]*h[p-1].real +
;//		xx[XOFF + n - p]*h[p-1].imag;
;//  }
  lar	AR0,#(xy+1)
  zap
  rpt	#2
    mac   hreal,*+
  apac
  sacb

  lar	AR0,#(xx+1)
  zap
  rpt	#2
    mac	  himag,*+
  apac
  addb
  ret

round_precoder_output:
;//  ACCB = ACC;
;//  ACC = (labs(ACC) + 0x01FFFL)>>14;

;//  if(ACCB < 0)
;//	ACC = -ACC;
  bcnd	rpo_neg,LT
  add	#1FFFh
  bsar	14
  ret
rpo_neg:
  abs
  add	#1FFFh
  bsar	14
  neg
  ret

; precoder filter coefficients

  .end