;*********************************************************************
;
; Filename:  GETPOINT.ASM
;
; Author:  Chris Buehler, Jonas Keating
; Date:  10/20/95
; Last revision:  11/24/95
;
;*********************************************************************
;
; Description:  Contains routines:
;	         1) get_initial_point
;
; Algorithm:  1) Computes the map index from mjk and qbits
;	      2) Uses the map index to find x and y coordinates -
;	         vy and vy.
;
;*********************************************************************
;
; Usage:  call get_initial_point
;
; Inputs:  mjk, qbits, coords, n, q
;
; Outputs:  vx, vy
;
;*********************************************************************

  .mmregs
  .text

  .global get_initial_point
  .global mjk, n, qbits, coords, vx, vy,q

get_initial_point:
;//  int map_index = (mjk[n]*TWOtotheQ + qbits[n])<<1;

;//  vx = coords[map_index];
;//  vy = coords[map_index + 1];
  lacl	n
  add	#mjk
  samm	AR0
  lacl	n
  add	#qbits
  samm	AR1
  mar	*,AR0
  lacc	*,AR1
  rpt	q		; Actually shifting (q+1) times:  96 : 1 time
    sfl                 ;				 144 : 2 times
  add	*,1		;				 192 : 4 times
  add	#coords
  samm	AR1
  nop
  nop
  lacc	*+
  sacl	vx
  lacc	*
  sacl	vy
  ret

  .end

