;*********************************************************************
;
; Filename:  GETDATA.ASM
;
; Author:  Chris Buehler, Jonas Keating
; Date:  10/20/95
; Last revision:  12/16/95
;
;*********************************************************************
;
; Description:  Contains routines:
;	         1) getdata
;
; Algorithm:  1) Checks if data present
;	      2) If data present copy data from bitbuf to bitstream
;		 and scramble it
;	      3) If no data present, then fill bitstream with all 1's
;		 and scramble it
;	      4) Return
;
;*********************************************************************
;
; Usage:  call getdata
;
; Inputs:  bitstream, datastart, go, data_present, bitbuf
;
; Outputs:  data_present, bitstream
;
;*********************************************************************
;
; Comments:  Requires that go is set correctly, and that correct
;	     data is stored in bitbuf.
;
;*********************************************************************

  .mmregs
  .text

  .global getdata
  .global bitstream,scramble16, datastart, go, data_present,bitbuf

getdata:

  ldpk	data_present
  lacc	data_present
  bcnd  no_data,EQ

  ldpk	bitbuf
  lacl  bitbuf
  ldpk	bitstream
  sacl	bitstream
  ldpk	bitbuf
  lacl  bitbuf+1
  ldpk	bitstream
  sacl	bitstream+1
  ldpk	bitbuf
  lacl  bitbuf+2
  ldpk	bitstream
  sacl	bitstream+2
  ldpk	bitbuf
  lacl  bitbuf+3
  ldpk	bitstream
  sacl	bitstream+3
  ldpk	data_present
  splk	#0,data_present		; set data_present flag to zero

goforit:
  ldpk	go			; get go to find out how much data to scramble
  lacl	go			;   go = 1,2,3 --> 2 ,3, 4 words
  bcnd	no_data,EQ
  sub	#1
  bcnd	data96,EQ
  sub	#1
  bcnd	data144,EQ
data192:
  lar	AR0,#(bitstream+3)
  call	scramble16,*,AR0
data144:
  lar	AR0,#(bitstream+2)
  call	scramble16,*,AR0
data96:
  lar	AR0,#(bitstream+1)
  call	scramble16,*,AR0
  lar	AR0,#(bitstream+0)
  call	scramble16,*,AR0
  b	gotdata

no_data:
  ldpk	bitstream
  splk	#0FFFFh, bitstream
  splk	#0FFFFh, bitstream+1
  splk	#0FFFFh, bitstream+2
  splk	#0FFFFh, bitstream+3
  b	goforit

gotdata:
  ret

  .end
