;*********************************************************************
;
; Filename:    CSUMDIFF.ASM
;
; Author:  Chris Buehler
; Date:  9/10/95
; Last revision:  9/12/95
;
;*********************************************************************
;
; Description:  Contains routines to perform complex addition and
;		subtraction.
;
; Algorithm:
;	complex_sum:
;	1) yx = ux + c_new_r
;	2) yy = uy + c_new_i
;	complex_diff:
;	1) xx = (yx<<7) - pr
;	2) xy = (yy<<7) - pi
;
;*********************************************************************
;
; Usage:  call complex_sum
;	         or
;	  call complex_diff
;
; Inputs:  ux, uy, c_new_r, c_new_i, yx, yy, preal, pimag, xx, xy
;
; Outputs:  yx, yy, xx, xy
;
;*********************************************************************

  .mmregs
  .text

  .global complex_sum
  .global complex_diff
  .global ux,uy,yx,yy,xx,xy,tx,ty
  .global c_new_r, c_new_i, preal, pimag


complex_sum:
;//  yx = ux + c_new_r;
;//  yy = uy + c_new_i;
  lacc	ux
  add	c_new_r
  sacl	yx
  lacc	uy
  add	c_new_i
  sacl	yy
  ret

complex_diff:
;//  xx = (yx<<7) - pr;
;//  xy = (yy<<7) - pi;
  lacc	yx,7
  sub	preal
  sacl	xx
  lacc	yy,7
  sub	pimag
  sacl	xy
  ret

  .end
