;-------------------------------------------------------------------------------------
; VAR.H: VARIABLES AND TIMING DEFINITIONS FOR THE FLASH PROGRAMMING TOOLS
;
;
;
; PROCEDURE:
;-------------------------------------------------------------------------------------
;       This file as distributed, configures the PLL to x4 and implements
;       timings at a CPU_CLK of 30MHz.
;
;       To change this 
;
;       Step 1: Select a Clock prescaler / clock input configuration.
;-------------------------------------------------------------------------------------
;       Step 2: Use one of the pre-set timing sets.
;               To do this uncomment the include statement to pull in
;               one of the timing information files: 
;                                               
;-------------------------------------------------------------------------------------
;       Step 3: If pre-set timing is not available for your needs,
;               see the Timings.xls worksheet to generate a custom
;               timings.h for your system.
;
;
;               Then, uncomment the include statement to include timings.xx
;                     where timings.xx is the filename you used when generating 
;                     a custom timing file.
;
;-------------------------------------------------------------------------------------
;       Step 4: Run the batch file buildall.bat to use the new timings.
;
;
;
;-------------------------------------------------------------------------------------
;       STEP 1:
;-------------------------------------------------------------------------------------
;
; Clock prescaler selection: 
; 
; The CPU clock is given as CPU_CLK = INPUT_CLK * PLL_RATIO.
;
; To choose the PLL_RATIO, uncomment ONLY ONE of the lines below.


PLL_RATIO_CONST         .set    0000h           ; CPU_CLK = INPUTCLK * 4.00

;PLL_RATIO_CONST         .set    0200h           ; CPU_CLK = INPUTCLK * 2.00
;PLL_RATIO_CONST         .set    0400h           ; CPU_CLK = INPUTCLK * 1.33
;PLL_RATIO_CONST         .set    0600h           ; CPU_CLK = INPUTCLK * 1.00
;PLL_RATIO_CONST         .set    0800h           ; CPU_CLK = INPUTCLK * 0.80
;PLL_RATIO_CONST         .set    0A00h           ; CPU_CLK = INPUTCLK * 0.66
;PLL_RATIO_CONST         .set    0C00h           ; CPU_CLK = INPUTCLK * 0.57
;PLL_RATIO_CONST         .set    0E00h           ; CPU_CLK = INPUTCLK * 0.50

;
;
;
;
;
;
;-------------------------------------------------------------------------------------
;       STEP 2:
;-------------------------------------------------------------------------------------
;
;       Uncomment ONLY one of the following:
;
;       .include        "timings.15"
;       .include        "timings.xx"
;       .include        "timings.20"


     .include        "timings.30"


;
;-------------------------------------------------------------------------------------
;       STEP 3: (If needed)
;-------------------------------------------------------------------------------------
;       Use timings.xls ( A Microsoft Excel file )
;       to generate the timings.xx file.
;
;
;-------------------------------------------------------------------------------------
;
;
;-------------------------------------------------------------------------------------
;       STEP 4: Re-build algos by running buildall.bat
;
;-------------------------------------------------------------------------------------
;
;
;       END OF CUSTOMIZATION 
;


	.DEF 	PAD		;Address of SCRATCH PAD
	.DEF 	PAD1
	.DEF 	READ		;Address of word to be verified
	.DEF 	DATA		;Address of register holding COMPARE value 
	.DEF 	ADDR		;Address of current word	
	.DEF	FL_SECST
	.DEF	FL_SECEND
	.DEF 	PLS_CNT		;ADDRESS OF # OF ALLOWABLE PULSES LEFT	
	.DEF 	ERASESEC	;VARIABLE DETERMINES WHICH SECTOR TO ERASE
	.DEF	SECTOR
	.DEF	MX_PCNT		;MAX # OF PROG PULSES ALLOWED
	.DEF	LASTVER 	;SEE BELOW
;-------------------------------------------------------------------------------------
ADDR		.SET	00060h
PAD		    .SET	00061h	; SCRATCH PAD
READ		.SET	00062h	; WORD READ DURING VERIFY
SIZE		.SET	00063h
DATA		.SET	00064h	
PAD1		.SET	00065h
PLS_CNT		.SET	00066h
LASTVER 	.SET	00067h	;HOLDS FLAG THAT INDICATES IF ON LAST VERIFY 
                                ;(AFTER CMPCTVER HAS PASED)
FL_SECST	.SET	00068h 	;FLASH SECTOR STARTING ADDRESS
FL_SECEND	.SET	00069h	;FLASH SECTOR ENDING ADDRESS
FL_CMD		.SET	0006Ah	;ROWRED COMMAND 
ERASESEC	.SET	0006Bh	;ERASE SECTOR (0000h FOR SECTOR 0 , 8000h SECTOR 1)
SECTOR		.SET	00070h	;SECTOR 0 OR SECTOR 1 KEY
DATA0		.SET	0007Ah	;MISC STORAGE AREA 
DATA1		.SET	0007Bh	;MISC STORAGE AREA
FAIL_CMD    .SET    0007Ch  ;FAIL ON/IGNORE EXCEEDING MAX PULSES.
;
;
;-------------------------------------------------------------------------------*
; Flash Control Registers
;-------------------------------------------------------------------------------*

PMPC 	.SET  0h
CTRL    .SET  1h
WADDR   .SET  2h
WDATA   .SET  3h
TCR     .SET  4h
ENAB    .SET  5h
SECT    .SET  6h
;

STICKS	.SET	64              ;# OF STICKS
	    .DEF	STICKS		;# OF STICKS



