/*********************************************************************
;
; Filename: RECEIVE.C
;
;
; Author: Chris Buehler, Jonas Keating
; Date: 10/20/95
; Last revision: 1/3/96
;
;*********************************************************************
;
; Description: Displays receiver data in a graphical format. Can be
;	used to display constellation points, filter coefficients,
;	and so on.
;
;*********************************************************************
;
; Usage:  While recv.out is running on the evm board, run receive.exe
;	from a dos prompt.
;
;
;*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <string.h>

#define PAUSELEN 10
#define MEMLEN  512            /*                          */
#define DIVFACTOR 32           /*                          */
#define SCALEFACTOR 7          /* initial scale of display */

void pause(void);
void send(int,int);
void setmode(int);
void putpix(int,int,int);
void quadplot(int,int,int);
void clearscr(void);
void ploth(int,int);
void waitfordata(void);
void waitforcommand(void);
void sendcommand(int);

unsigned int     CONT_REG     = (unsigned int )(0x240 + 0x804);
unsigned int     CMND_REG     = (unsigned int )(0x240 + 0x802);
unsigned int     DATA_REG     = (unsigned int )(0x240 + 0x800);
unsigned int     TDATAINT     = (unsigned int ) 0x0002;
unsigned int     TCMNDINT     = (unsigned int ) 0x0001;

int hr[144];
int hi[144];
int p[200];
int db[8];
int bitrate;
int pscale = 8;
int scalefactor = SCALEFACTOR;
int show_data = 1;
char far * vm = (char far *) 0xA0000000;

void main(int argc,char **argv)
{
  int data, i;
  int x,y;/*//,oldx,oldy; */
  int xx[MEMLEN],yy[MEMLEN];
  int ch=0;
  int temp;
/*  outport(DATA_REG,1);

//  outport(CONT_REG,0x0000); */
  for(i=0; i < MEMLEN; i++)
  {
    xx[i] = 0;
    yy[i] = 0;
  }

  setmode(19);

  send(CONT_REG,0xC200);
  pause();

    if(argc > 1)
  {
    scalefactor = atoi(argv[1]);
  }
/*
//  printf("hello\n");

/* Maybe we should change this... it waits in the while loop for
the data to be ready and then exits the loop without ever reading it
		-Jonas	*/

/*  // starting sending data points */
  send(CMND_REG,0);
  while(ch != 'q')
  {
/*    printf("Got here\n");   */
    waitfordata();
/*    printf("Got here2\n");      */
    x = inport(DATA_REG);
/*//    printf("(%d,",data);
//    pause();*/

    waitfordata();
    y = inport(DATA_REG);

/*//    printf("(%d,%d)\n",x,y);*/
    if(x > 0)
      x >>= scalefactor;
    else
    {
      x = -x;
      x >>=scalefactor;
      x = -x;
    }
    if(y > 0)
      y >>= scalefactor;
    else
    {
      y = -y;
      y >>=scalefactor;
      y = -y;
    }
    xx[0] = x;
    yy[0] = y;

    if (show_data){
	    waitfordata();
	    send(CMND_REG,9);
	    i = 1;
	    pause();
	    waitfordata();
	    data = inport(DATA_REG);
	/*    printf("[%04x]",data);*/
	/*    pause();    */
	    waitfordata();
	    waitfordata();
	    data = inport(DATA_REG);
	    while((data != -1) && (i < 4))
	    {
	      pause();
	/*      printf("%04X",data); */
	      printf("%c%c",(char)data,((char)(data>>8)));
	      waitfordata();
	      data = inport(DATA_REG);
	      i++;
    }
    waitfordata();
    send(CMND_REG,0);
    }

/*    if(!y)
      printf("(%d,%d)\n",x,y); */

    for(i = 0; i < MEMLEN; i++)
    {
      if((1)||(yy[i]))
	quadplot(xx[i], yy[i],30-i/DIVFACTOR+1);
      else
      {
	quadplot(xx[i], yy[i],4);
/*//	printf("(%d,%d)\n",xx[i],yy[i]);*/
      }

    }
    quadplot(xx[MEMLEN-1],yy[MEMLEN-1],0);
    for(i = MEMLEN-1; i >0; i--)
    {
      xx[i] = xx[i-1];
      yy[i] = yy[i-1];
    }
    if(kbhit())
    {
      ch = getch();
      switch(ch)
      {
	/* display real coefficients */
	case 'r' : clearscr();
		   waitfordata();
		   send(CMND_REG,2);
		   for(i=0; i < 144; i++)
		   {
		     waitfordata();
		     hr[i] = inport(DATA_REG);
		     //printf("%d ",x);
		   }
		   clearscr();
		   for(i=0; i < 144; i++)
		   {
		     if(hr[i] > 0)
		     {
		       _fmemset(vm+320*i+80,15,(hr[i]>>8));
		     }
		     else
		     {
		       temp = (-hr[i])>>8;
		       _fmemset(vm+320*i+80-temp,15,temp);
		     }
		   }
		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* display imaginary coefficients */
	case 'i' : clearscr();
		   waitfordata();
		   send(CMND_REG,3);
		   for(i=0; i < 144; i++)
		   {
		     waitfordata();
		     hi[i] = inport(DATA_REG);
/*//		     printf("%d ",hi[i]);*/
		   }
		   clearscr();
		   for(i=0; i < 144; i++)
		   {
		     if(hi[i] > 0)
		     {
		       _fmemset(vm+320*i+240,15,(hi[i]>>8));
		     }
		     else
		     {
		       temp = (-hi[i])>>8;
		       _fmemset(vm+320*i+240-temp,15,temp);
		     }
		   }

		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* show the received power for the last 144 bauds */
	case 'p' : clearscr();
		   waitfordata();
		   send(CMND_REG,4);
		   for(i=0; i < 200; i++)
		   {
		     waitfordata();
		     p[i] = inport(DATA_REG);
/*//		     printf("%d ",hi[i]);*/
		   }
		   clearscr();
		   for(i=0; i < 200; i++)
		   {
		     if(p[i] > 0)
		     {
		       _fmemset(vm+320*i+160,15,(p[i]>>pscale));
		     }
		     else
		     {
		       temp = (-hi[i])>>8;
		       _fmemset(vm+320*i+160-temp,15,temp);
		     }
		   }

		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* increase the scale of the power display */
	case ']' : clearscr();
		   pscale--;
		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* decrease the scale of the power display */
	case '[' : clearscr();
		   pscale++;
		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* zoom out of the constellation display */
	case '+' : clearscr();
		   scalefactor++;
		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* zoom in to the constellation display */
	case '-' : clearscr();
		   scalefactor--;
		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* toggle whether or not to show received data */
	case 's' : clearscr();
		   show_data = (show_data)? 0 : 1;
		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* clear the screen */
	case 'c' : clearscr();
		   waitfordata();
		   send(CMND_REG,0);
		   break;

	/* debugging - increase the slicer scale */
	case ',' : clearscr();
		   waitfordata();
		   send(CMND_REG,6);	/* send scaledn */
		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* debugging - decrease the slicer scale */
	case '.' : clearscr();
		   waitfordata();
		   send(CMND_REG,5);	/* send scaleup */
		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* debugging - print the contents of debug_buffer */
	case 'd' : clearscr();
		   waitfordata();
		   send(CMND_REG,7);
		   for(i=0; i < 7; i++)
		   {
		     waitfordata();
		     db[i] = inport(DATA_REG);
		     //printf("%d ",x);
		   }
		   clearscr();
		   for(i=0; i < 7; i++)
		   {
		     printf("%04x ",db[i]);
		   }
		   printf("\n");
		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* debugging - print the contents of bitbuf */
	case 'z' : clearscr();
		   waitfordata();
		   send(CMND_REG,10);
		   for(i=0; i < 4; i++)
		   {
		     waitfordata();
		     data = inport(DATA_REG);
		     printf("%04X ",data);
		   }
		   printf("\n");
		   waitfordata();
		   send(CMND_REG,0);
		   break;
	/* debugging - print bit_rate, the slicer scale */
	case 'b' : clearscr();
		   waitfordata();
		   send(CMND_REG,8);
		   waitfordata();
		   bitrate = inport(DATA_REG);
		   clearscr();
		   printf("%04x ",bitrate);
		   printf("\n");
		   waitfordata();
		   send(CMND_REG,0);
		   break;


	/* quit this program */
	case 'q' :
		break;
	default: /*//waitfordata();
		//send(CMND_REG,0);*/
		break;
      }
    }
/*//    printf("(%d,%d)\n",x,y);
//    pause();
//    printf("%d\n",data);*/

  }
/*//  data = getch();
//  if(!data) getch();*/
  setmode(3);
  printf("bye bye\n");
/*  outport(CMND_REG,1);
  outport(CONT_REG,1);
*/
}

void waitfordata(void)
{
/*  printf("d"); */
  while(!(inport(CONT_REG) & TDATAINT)&&!kbhit());
/*  printf("D");  */
}

void waitforcommand(void)
{
  printf("c");
  while(!(inport(CONT_REG) & TCMNDINT)&&!kbhit());
  printf("C");
}

void putpix(int x, int y, int color)
{
  char far *vidmem = (char far *) 0xA0000000L;

  *(vidmem + y*320 + x) = color;
}

void clearscr(void)
{
  char far *vidmem = (char far *) 0xA0000000L;
  _fmemset(vidmem,0,64000L);
}

void quadplot(int x, int y, int color)
{
    x += 160;
    y = 100-y;
  if((x > 0) && (x < 318) && (y>0) && (y < 198))
  {
    putpix(x,y,color);
/*//    putpix(x+1,y,color);
//    putpix(x,y+1,color);
 //   putpix(x+1,y+1,color);*/
  }
}

void setmode( int mode)
{
  asm mov  AX, mode
  asm int  0x10

}

void send(int reg, int data)
{
/*//  printf("writing: %d\n",data);*/
  outport(reg,data);
}

void sendcommand(int command)
{
  int test=-1;
  outport(CMND_REG,command);
  waitfordata();
  outport(CMND_REG,command);
  while(test != command)
  {
    test = inport(DATA_REG);
    waitfordata();
  }
}

void pause(void)
{
  int i = PAUSELEN;
  while ((i-->0) && !kbhit());
}
