;---------------------------------------------------------------------
; RAND.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; This example shows nested loops with a call to a random number
; within the inner loop.
;
; CAUTION: FOR BOOTLOADING
; ------------------------
; This example does not use 0x809800 and 0x809801 since the
; bootloader uses these locations for mini call stack space during
; the boot process.  By avoiding these locations this file can be
; either loaded or bootloaded.
;
; For DSK3D, loading to these locations is a dont care
;---------------------------------------------------------------------
        .start "CODE",0x809802 ; Start assembling CODE section here
        .sect  "CODE"          ;
        .entry  SAMPLE         ; Debugger entry point
        ;----------------------
SAMPLE  ldp     @stack         ; Load a data page
        ldi     @stack,SP      ; Load a stack pointer
        ;----------------------
        ldi     0,R0           ; Start with SEED = 0
        ldi     0,R1           ; Inner loop counter
        ldi     0,R2           ; Outer loop counter
        ;----------------------
OUTER   ldi     3,RC           ; Start 'OUTER' loop
        rptb    INNER          ; Repeat block 'INNER' (RC+1) times
        call    RAND           ; Call function
INNER   addi    1,R1           ; Count 'INNER' loops
        addi    1,R2           ; Count 'OUTER' loops
        b       OUTER          ; Do it again!
;----------------------------------------
; Fast 32 bit random number generator
;----------------------------------------
RANDX:  ldi     @SEED,R0       ; Call here for last SEED
RAND:   mpyi    @A,R0          ; Calculate RAND(R0)
        addi    @C,R0          ;
        sti     R0,@SEED       ; Result is returned in R0
        rets                   ;
        ;----------------------
A       .word   0107465h       ; Constants needed for RAND
C       .word   0234567h       ;
SEED    .word   0              ;
;------------------------------
stack   .word   $+1            ; Begin stack here
        .end
