//----------------------------------------------------------------------
// DSKGRAPH.CPP        Graphs DSK data at a user defined address
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//----------------------------------------------------------------------
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <bios.h>
#include <graphics.h>
#include <math.h>
#include "DSK.H"
#include "EXP_ANAL.H"
//===================================================================
//Constants for functions and setup
//===================================================================
#define Xd        512                   // X pix width
#define Yd        320                   // Y pix height
//===================================================================
typedef enum GRAPHMODES
{
  LIN,
  LOG,
  SQRT,
  CMPLX_LOG,
  CMPLX_MAG
};
//---------------------------------------------------
MSGS init_graphics(void)
{
  int gdriver = VGA, gmode = VGAHI, errorcode;
  errorcode = registerbgidriver(EGAVGA_driver);
  if (errorcode < 0)  // report any registration errors
  { sprintf(EXTMSG,"Graphics error: %s", grapherrormsg(errorcode));
    return EXT_MSG_ERR;
  }
  initgraph(&gdriver, &gmode, "");        // if possible open EGA mode
  errorcode = graphresult();
  if (errorcode != grOk)
  { sprintf(EXTMSG,"Graphics error: %s", grapherrormsg(errorcode));
    return EXT_MSG_ERR;
  }
  return NO_ERR;
}
//---------------------------------------------------------
int inline xwarp(float in)
{
  return(1 + 50*log(in));
}

typedef union LF
{
  long  l;
  float f;
};

void ConvertData(int graphmode, NUM_TYPE DATATYPE,
                 ulong *DATA,float *PLOT, int GSIZE)
{
  int x;
  float f0=1,f1=1;
  switch(DATATYPE)
  {
    case NT_FLOAT  : for(x=0;x<GSIZE;x++)
                     {
                       f0 = TMS_IEEE(DATA[x]);
                      // if(f0<-10e9) f0=-10e9;
                      // if(f0> 10e9) f0= 10e9;
                       PLOT[x] = f0;
                     }
                     break;
    default:
    case NT_BASE2  :
    case NT_SLONG  :
    case NT_ULONG  :
    case NT_QFORM  :
    case NT_INTEGER: for(x=0;x<GSIZE;x++) PLOT[x]=DATA[x]; break;
  }
  switch(graphmode)
  {
    default:
    case       LIN: return;
    case       LOG: for(x=0;x<GSIZE;x++)
                    { f0 = PLOT[x];
                      if(f0 < 1.0e-36) f0 = 1.0e-36;
                      PLOT[x] = log(f0);
                    }break;
    case CMPLX_LOG: for(x=0;x<GSIZE;x+=2)
                    { f0 = PLOT[x  ];
                      f1 = PLOT[x+1];
                      f0 = (f0*f0)+(f1*f1);
                      if(f0 < 1.0e-38) f0 = 1.0e-38;
                      f0=log(f0);
                      PLOT[x  ] = f0; // log (mag)
                      PLOT[x+1] = f0; // Phase?
                    }break;
    case CMPLX_MAG: for(x=0;x<GSIZE;x+=2)
                    { f0 = PLOT[x  ];
                      f1 = PLOT[x+1];
                      f0 = (f0*f0)+(f1*f1);
                      if(f0 < 0) f0 = 0;
                      f0=sqrt(f0);
                      PLOT[x  ] = f0; // log (mag)
                      PLOT[x+1] = f0; // Phase?
                    }break;
    case      SQRT: for(x=0;x<GSIZE;x++)
                    { f0 = PLOT[x];
                      if(f0 < 0) f0 = 0;
                      PLOT[x] = sqrt(f0);
                    }break;
  }
}

double ygain=16.0;
double yoffs= 0.0;
double xgain= 1.0;

void autoscale(float *PLOTDATA, int GSIZE)//, double *yoffs)
{
  float yc;
  int x;
  float grmax, grmin;
  grmax = PLOTDATA[0];
  grmin = grmax;
  for(x=0;x<GSIZE;x++)
  {
    yc = PLOTDATA[x];
    if(yc>grmax) grmax = yc;
    if(yc<grmin) grmin = yc;
  }
  ygain = Yd/(grmax-grmin);
  yoffs = (Yd/2) - 0.5*(grmax+grmin) * ygain;
}

//---------------------------------------------------------

MSGS graph(ulong *DSPDATA, ulong Addr, NUM_TYPE DATATYPE)
{
//  ulong test;
  char  MSG[160];
  float PLOTDATA[512];
//double ygain =16.0;
//double xgain = 1.0;
//float yoffs =   0;
  float f0, f1, f2;
  int   yc,  xc;
  int   x, y;
  int   Y;
  int   d;
  int   key;
  int   GSIZE     = 128;
  int   graphmode = LIN;    // Which type of bode display
  MSGS err;
  if((err=init_graphics())!=NO_ERR) return err;
  getmem(Addr,GSIZE,DSPDATA);
  ConvertData(graphmode,DATATYPE,DSPDATA,PLOTDATA,GSIZE);
  autoscale(PLOTDATA,GSIZE);
  for(;;)
  {
    cleardevice();
    moveto(0,0);
    //------------------------------------------
    // Plot vertical lines and Freq markers
    //------------------------------------------
    switch(graphmode)
    {
      default:
      case LIN:
            for(d=0;d<11;d++)
            {
              x = d * (float)GSIZE/10.0;
              f2 =  x;
              if((f2>=  0)&&(f2<1E3)) sprintf(MSG,"%0.1f" ,(float)f2     );
              if((f2>=1E3)&&(f2<1E6)) sprintf(MSG,"%0.1fk",(float)f2*1E-3);
              if((f2>=1E6)&&(f2<1E9)) sprintf(MSG,"%0.1fM",(float)f2*1E-6);
              xc = Xd*d/10.0;
              setcolor(GREEN);     line(xc-1,Yd,xc-1,Yd+4);
                                   line(xc  ,Yd,xc  ,Yd+4);
                                   line(xc+1,Yd,xc+1,Yd+4);
                                   line(xc,0,xc,Yd);
              setcolor(LIGHTGRAY); outtextxy(xc,Yd+10,MSG);

              if((d== 0)||(d==10))
              {
                if(d== 0) sprintf(MSG,"%06lx",(ulong)(Addr      ));
                if(d==10) sprintf(MSG,"%06lx",(ulong)(Addr+GSIZE));
                outtextxy(xc,Yd+20,MSG);
              }
            }
            xc = Xd;
            break;

    case LOG:
            f1=1;
            f2=1;
            for(f0=1;f0<100e3;)
            { if(f1==1)
              { if((f2>=  0)&&(f2<1E3)) sprintf(MSG,"%0.0fhz" , f1*f2);
                if((f2>=1E3)&&(f2<1E6)) sprintf(MSG,"%0.0fkhz",(f1*f2)*1E-3);
                if((f2>=1E6)&&(f2<1E9)) sprintf(MSG,"%0.0fMhz",(f1*f2)*1E-6);
                xc = xwarp(f1*f2);
                setcolor(GREEN);     line(xc-1,Yd,xc-1,Yd+4);
                                     line(xc  ,Yd,xc  ,Yd+4);
                                     line(xc+1,Yd,xc+1,Yd+4);
                setcolor(LIGHTGRAY); outtextxy(xc,Yd+10,MSG);
              }
              f0 = f1 * f2;
              xc = xwarp(f1*f2);
              if(xc<0) xc=0; if(xc>Xd) xc=Xd;
              setcolor(GREEN);    line(xc,0,xc,Yd);
              f1++;
              if(f1>=10)
              {
                f1=1;
                f2*=10;
              }
              f0 = f1*f2;
            }
            break;
    }
    //------------------------------------------
    // Plot horizontal lines and dB markers
    //------------------------------------------
    for(y=0;y<17;y++)
    {
      if(y==8) setcolor(LIGHTGRAY);
      else     setcolor(GREEN    );
      Y = y * Yd/16;
      line(0,Y,xc,Y);
      setcolor(LIGHTGRAY);
   // if(y== 0) {sprintf(MSG,"%7.3e",grmax); outtextxy(Xd+2,   10,MSG);}
   // if(y==16) {sprintf(MSG,"%7.3e",grmin); outtextxy(Xd+2,Yd-10,MSG);}
    }
    //------------------------------------------
    // Now graph the response
    //------------------------------------------
    xgain = 512.0/GSIZE;
    getmem(Addr,GSIZE,DSPDATA);
    ConvertData(graphmode,DATATYPE,DSPDATA,PLOTDATA,GSIZE);
    setcolor(WHITE);
    moveto( 0, 0);
    //
    // The floating point multiply could result in an NAN, +/-INF
    // plus a floating point error trap.  This is generaly handled
    // by MATHERR.CPP, which will attempt to printf an error message
    // to the screen.  Since the screen is not in text mode, this
    // corrupts the stack. DSK3D is set to 1 to disable the printf().
    // Furthermore, the assignement of the NAN, +/-INF cannot be
    // made to an integer.
    //
    DSK3D = 1;
    for(x=0;x<GSIZE;x++)
    {
      #if 1
      f0 = PLOTDATA[x] * ygain;
      f0+= yoffs;
      f1 = (double)x * xgain;
      if(f0<  0) f0= 0;
      if(f0> Yd) f0=Yd;
      if(f1<0.0) f1= 0;
      if(f1> Xd) f1=Xd;
      yc = f0;
      xc = f1;
      #else
      yc = PLOTDATA[x] * ygain;
      yc+= yoffs;
      xc = (double)x * xgain;
      if(yc<  0) yc= 0;
      if(yc> Yd) yc=Yd;
      if(xc<0.0) xc= 0;
      if(xc> Xd) xc=Xd;
      #endif
      lineto(xc,yc);
    }
    DSK3D = 0;
    //==============================================================
    // Check for keyhits
    //==============================================================
    y = Yd+30;
    sprintf(MSG,"x gain:%7.3e",(float)xgain);outtextxy(300,y+=10,MSG);
    sprintf(MSG,"y offs:%7.3e",(float)yoffs);outtextxy(300,y+=10,MSG);
    sprintf(MSG,"y gain:%7.3e",(float)ygain);outtextxy(300,y+=10,MSG);

    y = Yd+30;
    sprintf(MSG,"F1-F2  Points to plot");outtextxy(  1,y+=10,MSG);
    sprintf(MSG,"F3-F4  Vertical gain" );outtextxy(  1,y+=10,MSG);
    sprintf(MSG,"F5-F6  Vertical shift");outtextxy(  1,y+=10,MSG);
    sprintf(MSG,"F7     Autoscale"     );outtextxy(  1,y+=10,MSG);
    y+=10;
    sprintf(MSG,"[Q]uit"               );outtextxy(  1,y+=10,MSG);
    switch(graphmode)
    {
      default        : sprintf(MSG,"[M]ode:ERR"      ); break;
      case       LIN : sprintf(MSG,"[M]ode:LIN"      ); break;
      case       LOG : sprintf(MSG,"[M]ode:LOG"      ); break;
      case      SQRT : sprintf(MSG,"[M]ode:SQRT"     ); break;
      case CMPLX_MAG : sprintf(MSG,"[M]ode:CMPLX_MAG"); break;
      case CMPLX_LOG : sprintf(MSG,"[M]ode:CMPLX_LOG"); break;
    }                                outtextxy(  1,y+=10,MSG);
    switch(DATATYPE)
    { case NT_FLOAT  : sprintf(MSG,"[D]ata:FLOAT  "  ); break;
      case NT_BASE2  : sprintf(MSG,"[D]ata:BASE2  "  ); break;
      case NT_SLONG  : sprintf(MSG,"[D]ata:SLONG  "  ); break;
      case NT_ULONG  : sprintf(MSG,"[D]ata:ULONG  "  ); break;
      case NT_QFORM  : sprintf(MSG,"[D]ata:QFORM  "  ); break;
      default:
      case NT_INTEGER: sprintf(MSG,"[D]ata:INTEGER"  ); break;
    }                                outtextxy(  1,y+=10,MSG);
    sprintf(MSG,"[A]ddr:%08lx - up,dn,pup,pdn",Addr);
                                     outtextxy(  1,y+=10,MSG);
    while(!kbhit());
    key = bioskey(0) & 0xFF00;
    switch(key)
    {
      case _ESC: break;
      case _Q  : // closegraph();    // Temp fast exit for debug
                 // exit(0);
                closegraph();
                return NO_ERR;
      case _M:  switch(graphmode)
                { default:
                  case       LIN: graphmode =       LOG; break;
                  case       LOG: graphmode =      SQRT; break;
                  case      SQRT: graphmode = CMPLX_LOG; break;
                  case CMPLX_LOG: graphmode = CMPLX_MAG; break;
                  case CMPLX_MAG: graphmode =       LIN; break;
                }
                break;
      case _D:  switch(DATATYPE)
                { default:
                  case NT_FLOAT  : DATATYPE = NT_BASE2  ; break;
                  case NT_BASE2  : DATATYPE = NT_SLONG  ; break;
                  case NT_SLONG  : DATATYPE = NT_ULONG  ; break;
                  case NT_ULONG  : DATATYPE = NT_QFORM  ; break;
                  case NT_QFORM  : DATATYPE = NT_INTEGER; break;
                  case NT_INTEGER: DATATYPE = NT_FLOAT  ; break;
                }
                 break;
      case _F1 : GSIZE*=2;
                 if(GSIZE<  8)GSIZE=  8; if(GSIZE>512)GSIZE=512;
                 autoscale(PLOTDATA,GSIZE);
                 break;

      case _F2 : GSIZE/=2;
                 if(GSIZE<  8)GSIZE=  8; if(GSIZE>512)GSIZE=512;
                 autoscale(PLOTDATA,GSIZE);
                 break;
      case _F3 : ygain*=2; if(ygain>16384.0) ygain=16384.0; break;
      case _F4 : ygain/=2; if(ygain<0.03125) ygain=0.03125; break;
      case _F5 : yoffs+=16; if(yoffs>+1024) yoffs = +1024; break;
      case _F6 : yoffs-=16; if(yoffs<-1024) yoffs = -1024; break;

      case _F7 : // Find min/max according to type.  Then
                 // adjust gain and offset to fit to screen
                 autoscale(PLOTDATA,GSIZE);
                 break;

      case _Pup: Addr-=24; break;  // Page window up
      case _Pdn: Addr+=24; break;  // Page window down
      case _Up : Addr-= 4; break;  // Scroll up
      case _Dn : Addr+= 4; break;  // Scroll down
      case _A  : // An expression can be used if there
                 // were a graphics equivlent to scanf()
                 //
                 //sprintf("\nInput expression for address: ");
                 //scanf(MSG,"%60s",instrg);
                 //expressionz(MSG, &DSP_addr, NT_INTEGER);
                 break;
      default  : break;
    }
  }
//  closegraph();
//  return NO_ERR;
}

