//-----------------------------------------------------------------
// DSK3HELP.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//-----------------------------------------------------------------
// DSK3HELP.EXE is a standalone DOS executable that contains only
// the debugger help screens.  This is useful in cases where the
// user may want to see the onscreen help while using the debugger.
// Creating this application was also useful in finding which
// functions were truly need for DOS support and could therefor be
// seperated from the other core routines.  IE this makes porting
// to other OS platforms that much easier.
//-----------------------------------------------------------------
//  The project file should include the following files in a directory
//  tree similar to the one shown below.
//
//                  (root)
//
//  C:\---\DSK3SRC--+--\DSK3--+-- \DSK3A  (not used for DSK3D)
//                  |         +-- \DSK3D
//                  |         +-- \COMMON
//                  |         +-- \COMMON2
//                  |         +-- \DSK3APPS
//                  |
//                  +-- Verxxx
//                  +-- Veryyy
//                      etc...
//
//  Files in root directory
//  -----------------------
//    DSK3HELP.PRJ  Borland project file
//    DSK3HELP.DSK  Borland desktop file
//    CMDHELP.TXT   Text for DSK3D commands help
//    HARDWARE.TXT  Text for command line (hardware) help
//    CMDHELP.CPP   C string of above
//    HARDWARE.CPP  C string of above
//           *.obj  Compiler object output
//
//  Files in DSK3D directory
//  ------------------------
//    DSK3HELP.CPP  Help utility main routine
//    TEXTWIN.CPP   DOS level text window support
//    DSK3DHLP.CPP  DSK3D Debugger help routines
//
//  Files in COMMON2 directory
//  --------------------------
//    ERRORMSG.CPP  Enumerated errors and string messages
//--------------------------------------------------------------
#include <bios.h>               // Compiler header files
#include <string.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <dos.h>
//--------------------------------------------------------------
#include "textwin.h"            // DSK header files
#include "errormsg.h"
#include "typedefs.h"
#include "keydef.h"
#include "dsk.h"
//--------------------------------------------------------------
float DSK3_rev  = DSK3_ver;     // Software version
//--------------------------------------------------------------
// Top menu... Used in place of the debugger
//--------------------------------------------------------------
char DSK3_HELP[]=
 " To get help on a topic hit a key\r\n"
 "\r\n"
 " 1    Application help volume 1 (not in debugger)\r\n"
 " 2    Application help volume 2 (not in debugger)\r\n"
 " D    Disassembler window\r\n"
 " E    Edit command window\r\n"
 " H    Hardware window\r\n"
 " C    CPU register window\r\n"
 " M    Memory window\r\n"
 " A    About window\r\n\r\n"
 " Q    Quit\r\n"
 "\r\n";
char huge App_hlp1[]=   // Application and daughter card help
  #include "APPHELP1.CPP"
char huge App_hlp2[]=   // Application and daughter card help
  #include "APPHELP2.CPP"
/*-------------------------------------------------------------
    Opens the app add on card display
  -----------------------------------------------------------*/
MSGS App_Help1(void)
{
  if(screenmode==C4350) return(Help_Menu("ADD_ONS",App_hlp1,1,80,1,39));
  else                  return(Help_Menu("ADD_ONS",App_hlp1,1,80,1,25));
}
MSGS App_Help2(void)
{
  if(screenmode==C4350) return(Help_Menu("ADD_ONS",App_hlp2,1,80,1,39));
  else                  return(Help_Menu("ADD_ONS",App_hlp2,1,80,1,25));
}

//--------------------------------------------------------------
// Main is simply a shell that calls the sub-help menus
// using the same functions calls as the debugger
//--------------------------------------------------------------
void main(void)
{
  MSGS err = NO_ERR;
  int x;
  struct text_info ti;
  /*-------------------------------------------------------------*/
  /* The following line is used to insert DSK3D specific command */
  /* line options into the help string before being printed. The */
  /* help string itself has enough WS chars to allow this.       */
  /*-------------------------------------------------------------*/
  Edit_Help_Msg("DSK3HELP","",
  "  LV                25x80 display\r\n"
  "  HV                43x80 or 50x80 display\r\n");
  /*----------------------------------------------------*/
  /* Determine present screen mode                      */
  screenmode =   C80;
  gettextinfo(&ti);
  if(ti.screenheight > 25) screenmode = C4350;
  else                     screenmode =   C80;  // default
  /* If requested, force mode */
  for(x=1;x<_argc;x++)
  {
    strupr(_argv[x]);
    if(strexact(_argv[x],"H" )) screenmode = C4350; // Force HiVid
    if(strexact(_argv[x],"HV")) screenmode = C4350; // Force HiVid
    if(strexact(_argv[x],"L" )) screenmode =   C80; // Force LoVid
    if(strexact(_argv[x],"LV")) screenmode =   C80; // Force LoVid
  }
  InitVideo();
  /*----------------------------------------------------*/
  for(;;)
  {
    textcolor     (LIGHTGRAY);
    textbackground(    BLACK);
    clrscr();
    cputs(DSK3_HELP);
    switch(bioskey(0)&0xFF00)
    {
      case _1   : err =   App_Help1(); break;
      case _2   : err =   App_Help2(); break;
      case _E   : err =  Edit_Help(); break;
      case _A   : err = About_Help(); break;
      case _D   : err =  Dasm_Help(); break;
      case _M   : err =   Mem_Help(); break;
      case _C   : err =   CPU_Help(); break;
      case _H   : err = Ext_Help(EXT_HELP); break;
      default   : clrscr();
                  printf("Quit [Y/N]\n");
                  if(toupper(getch())!='Y') break;
                  textcolor     (LIGHTGRAY);
                  textbackground(BLACK);
                  clrscr();
                  _setcursortype(_NORMALCURSOR);
                  cputs(Exit_Hlp);
                  exit(0);
    }
    if((err!=NO_ERR)&&(err!=EXT_HELP))
    {
      printf("DSK3HELP ERROR\n\n%s",Error_Strg(err));
      exit(0);
    }
  }
}

